/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.filters;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.openscience.cdk.smsd.helper.FinalMappings;

public class PostFilter {
    public static List<Map<Integer, Integer>> filter(List<List<Integer>> mappings) {
        FinalMappings finalMappings = FinalMappings.getInstance();
        if (mappings != null && !mappings.isEmpty()) {
            finalMappings.set(PostFilter.removeRedundantMapping(mappings));
            mappings.clear();
        } else {
            finalMappings.set(new ArrayList<Map<Integer, Integer>>());
        }
        return finalMappings.getFinalMapping();
    }

    private static boolean hasMap(Map<Integer, Integer> newMap, List<Map<Integer, Integer>> nonRedundantMapping) {
        for (Map<Integer, Integer> storedMap : nonRedundantMapping) {
            if (!storedMap.equals(newMap)) continue;
            return true;
        }
        return false;
    }

    private static List<Map<Integer, Integer>> removeRedundantMapping(List<List<Integer>> mappingOrg) {
        ArrayList<Map<Integer, Integer>> nonRedundantMapping = new ArrayList<Map<Integer, Integer>>();
        for (List<Integer> mapping : mappingOrg) {
            Map<Integer, Integer> newMap = PostFilter.getMappingMapFromList(mapping);
            if (PostFilter.hasMap(newMap, nonRedundantMapping)) continue;
            nonRedundantMapping.add(newMap);
        }
        return nonRedundantMapping;
    }

    private static Map<Integer, Integer> getMappingMapFromList(List<Integer> list) {
        TreeMap<Integer, Integer> newMap = new TreeMap<Integer, Integer>();
        for (int index = 0; index < list.size(); index += 2) {
            newMap.put(list.get(index), list.get(index + 1));
        }
        return newMap;
    }
}

