/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer;

import java.awt.Color;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.event.ICDKChangeListener;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.renderer.generators.IGenerator;
import org.openscience.cdk.renderer.generators.IGeneratorParameter;
import org.openscience.cdk.renderer.generators.parameter.AbstractGeneratorParameter;
import org.openscience.cdk.renderer.selection.IChemObjectSelection;

public class RendererModel
implements Serializable,
Cloneable {
    private static final long serialVersionUID = -4420308906715213445L;
    private boolean notification = true;
    private transient List<ICDKChangeListener> listeners = new ArrayList<ICDKChangeListener>();
    private Map<IAtom, String> toolTipTextMap = new HashMap<IAtom, String>();
    private IAtom highlightedAtom = null;
    private IBond highlightedBond = null;
    private IAtomContainer externalSelectedPart = null;
    private IAtomContainer clipboardContent = null;
    private IChemObjectSelection selection;
    private Map<IAtom, IAtom> merge = new HashMap<IAtom, IAtom>();
    private IGeneratorParameter<Color> externalHighlightColor = new ExternalHighlightColor();
    private IGeneratorParameter<Map<IChemObject, Color>> colorHash = new ColorHash();
    private Map<String, IGeneratorParameter<?>> renderingParameters = new HashMap();

    public RendererModel() {
        this.renderingParameters.put(this.colorHash.getClass().getName(), this.colorHash);
        this.renderingParameters.put(this.externalHighlightColor.getClass().getName(), this.externalHighlightColor);
        this.renderingParameters.put(SelectionColor.class.getName(), new SelectionColor());
        this.renderingParameters.put(Padding.class.getName(), new Padding());
        this.renderingParameters.put(TitleFontScale.class.getName(), new TitleFontScale());
        this.renderingParameters.put(TitleColor.class.getName(), new TitleColor());
        this.renderingParameters.put(MarkedOutput.class.getName(), new MarkedOutput());
    }

    public List<IGeneratorParameter<?>> getRenderingParameters() {
        ArrayList parameters = new ArrayList();
        parameters.addAll(this.renderingParameters.values());
        return parameters;
    }

    public <T extends IGeneratorParameter<?>> T getParameter(Class<T> param) {
        if (this.renderingParameters.containsKey(param.getName())) {
            return (T)this.renderingParameters.get(param.getName());
        }
        throw new IllegalAccessError("You requested the active parameter of type " + param.getName() + ", but it " + "has not been registered yet. Did you " + "make sure the IGeneratorParameter is registered, by " + "registring the appropriate IGenerator? Alternatively, " + "you can use getDefault() to query the default value for " + "any parameter on the classpath.");
    }

    public <T extends IGeneratorParameter<S>, S> S getDefault(Class<T> param) {
        if (this.renderingParameters.containsKey(param.getName())) {
            return this.getParameter(param).getDefault();
        }
        try {
            return (S)((IGeneratorParameter)param.newInstance()).getDefault();
        }
        catch (InstantiationException exception) {
            throw new IllegalArgumentException("Could not instantiate a default " + param.getClass().getName(), exception);
        }
        catch (IllegalAccessException exception) {
            throw new IllegalArgumentException("Could not instantiate a default " + param.getClass().getName(), exception);
        }
    }

    public <T extends IGeneratorParameter<S>, S, U extends S> void set(Class<T> paramType, U value) {
        U parameter = this.getParameter(paramType);
        parameter.setValue(value);
    }

    public <T extends IGeneratorParameter<S>, S> S get(Class<T> paramType) {
        return this.getParameter(paramType).getValue();
    }

    public void registerParameters(IGenerator<? extends IChemObject> generator) {
        for (IGeneratorParameter<?> param : generator.getParameters()) {
            this.renderingParameters.put(param.getClass().getName(), param);
        }
    }

    public void setSelection(IChemObjectSelection selection) {
        this.selection = selection;
    }

    public IChemObjectSelection getSelection() {
        return this.selection;
    }

    public Map<IAtom, IAtom> getMerge() {
        return this.merge;
    }

    public IAtom getHighlightedAtom() {
        return this.highlightedAtom;
    }

    public void setHighlightedAtom(IAtom highlightedAtom) {
        if (this.highlightedAtom != null || highlightedAtom != null) {
            this.highlightedAtom = highlightedAtom;
            this.fireChange();
        }
    }

    public IBond getHighlightedBond() {
        return this.highlightedBond;
    }

    public void setHighlightedBond(IBond highlightedBond) {
        if (this.highlightedBond != null || highlightedBond != null) {
            this.highlightedBond = highlightedBond;
            this.fireChange();
        }
    }

    public IAtomContainer getClipboardContent() {
        return this.clipboardContent;
    }

    public void setClipboardContent(IAtomContainer content) {
        this.clipboardContent = content;
    }

    public void addCDKChangeListener(ICDKChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<ICDKChangeListener>();
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeCDKChangeListener(ICDKChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void fireChange() {
        if (this.getNotification() && this.listeners != null) {
            EventObject event = new EventObject(this);
            for (int i = 0; i < this.listeners.size(); ++i) {
                this.listeners.get(i).stateChanged(event);
            }
        }
    }

    public String getToolTipText(IAtom atom) {
        if (this.toolTipTextMap.get(atom) != null) {
            return this.toolTipTextMap.get(atom);
        }
        return null;
    }

    public void setToolTipTextMap(Map<IAtom, String> map) {
        this.toolTipTextMap = map;
        this.fireChange();
    }

    public Map<IAtom, String> getToolTipTextMap() {
        return this.toolTipTextMap;
    }

    public IAtomContainer getExternalSelectedPart() {
        return this.externalSelectedPart;
    }

    public void setExternalSelectedPart(IAtomContainer externalSelectedPart) {
        this.externalSelectedPart = externalSelectedPart;
        Map colorHash = (Map)this.getParameter(ColorHash.class).getValue();
        colorHash.clear();
        if (externalSelectedPart != null) {
            for (int i = 0; i < externalSelectedPart.getAtomCount(); ++i) {
                colorHash.put(externalSelectedPart.getAtom(i), this.getParameter(ExternalHighlightColor.class).getValue());
            }
            Iterator<IBond> bonds = externalSelectedPart.bonds().iterator();
            while (bonds.hasNext()) {
                colorHash.put(bonds.next(), this.getParameter(ExternalHighlightColor.class).getValue());
            }
        }
        this.fireChange();
    }

    public boolean getNotification() {
        return this.notification;
    }

    public <T extends IGeneratorParameter<?>> boolean hasParameter(Class<T> param) {
        return this.renderingParameters.containsKey(param.getName());
    }

    public void setNotification(boolean notification) {
        this.notification = notification;
    }

    public static class MarkedOutput
    extends AbstractGeneratorParameter<Boolean> {
        @Override
        public Boolean getDefault() {
            return true;
        }
    }

    public static class TitleColor
    extends AbstractGeneratorParameter<Color> {
        @Override
        public Color getDefault() {
            return Color.RED;
        }
    }

    public static class TitleFontScale
    extends AbstractGeneratorParameter<Double> {
        @Override
        public Double getDefault() {
            return 0.8;
        }
    }

    public static class ColorHash
    extends AbstractGeneratorParameter<Map<IChemObject, Color>> {
        @Override
        public Map<IChemObject, Color> getDefault() {
            return new Hashtable<IChemObject, Color>();
        }
    }

    public static class Padding
    extends AbstractGeneratorParameter<Double> {
        @Override
        public Double getDefault() {
            return 16.0;
        }
    }

    public static class ExternalHighlightColor
    extends AbstractGeneratorParameter<Color> {
        @Override
        public Color getDefault() {
            return Color.gray;
        }
    }

    public static class SelectionColor
    extends AbstractGeneratorParameter<Color> {
        @Override
        public Color getDefault() {
            return new Color(4841471);
        }
    }
}

