/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.modeling.builder3d;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.fingerprint.BitSetFingerprint;
import org.openscience.cdk.fingerprint.HybridizationFingerprinter;
import org.openscience.cdk.fingerprint.IBitFingerprint;
import org.openscience.cdk.graph.Cycles;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.io.MDLV2000Writer;
import org.openscience.cdk.io.iterator.IteratingSDFReader;
import org.openscience.cdk.isomorphism.matchers.QueryAtomContainerCreator;
import org.openscience.cdk.ringsearch.RingPartitioner;
import org.openscience.cdk.silent.SilentChemObjectBuilder;
import org.openscience.cdk.smiles.SmilesGenerator;
import org.openscience.cdk.tools.LoggingToolFactory;
import org.openscience.cdk.tools.manipulator.AtomContainerManipulator;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

public class TemplateExtractor {
    static final String usage = "Usage: TemplateExtractor SDFinfile outfile anyAtom=true/false anyBondAnyAtom=true/false";
    private static final IChemObjectBuilder builder = SilentChemObjectBuilder.getInstance();

    public void cleanDataSet(String dataFile) {
        IteratingSDFReader imdl = null;
        IAtomContainerSet som = builder.newInstance(IAtomContainerSet.class, new Object[0]);
        try {
            System.out.println("Start clean dataset...");
            BufferedReader fin = new BufferedReader(new FileReader(dataFile));
            imdl = new IteratingSDFReader(fin, builder);
            System.out.print("Read File in..");
        }
        catch (Exception exc) {
            System.out.println("Could not read Molecules from file " + dataFile + " due to: " + exc.getMessage());
        }
        System.out.println("READY");
        int c = 0;
        while (imdl.hasNext()) {
            if (++c % 1000 == 0) {
                System.out.println("...");
            }
            IAtomContainer m = builder.newInstance(IAtomContainer.class, new Object[0]);
            m = imdl.next();
            if (m.getAtomCount() <= 2 || m.getAtom(0).getPoint3d() == null) continue;
            som.addAtomContainer(m);
        }
        try {
            imdl.close();
        }
        catch (Exception exc1) {
            System.out.println("Could not close Reader due to: " + exc1.getMessage());
        }
        System.out.println(som.getAtomContainerCount() + " Templates are read in");
        this.writeChemModel(som, dataFile, "_CLEAN");
    }

    public void ReadNCISdfFileAsTemplate(String dataFile) {
        IteratingSDFReader imdl = null;
        IAtomContainerSet som = builder.newInstance(IAtomContainerSet.class, new Object[0]);
        try {
            System.out.println("Start...");
            BufferedReader fin = new BufferedReader(new FileReader(dataFile));
            imdl = new IteratingSDFReader(fin, builder);
            System.out.print("Read File in..");
        }
        catch (Exception exc) {
            System.out.println("Could not read Molecules from file " + dataFile + " due to: " + exc.getMessage());
        }
        System.out.println("READY");
        while (imdl.hasNext()) {
            som.addAtomContainer(imdl.next());
        }
        try {
            imdl.close();
        }
        catch (Exception exc1) {
            System.out.println("Could not close Reader due to: " + exc1.getMessage());
        }
        System.out.println(som.getAtomContainerCount() + " Templates are read in");
    }

    public void PartitionRingsFromComplexRing(String dataFile) {
        IteratingSDFReader imdl = null;
        IAtomContainerSet som = builder.newInstance(IAtomContainerSet.class, new Object[0]);
        IAtomContainer m = null;
        try {
            System.out.println("Start...");
            BufferedReader fin = new BufferedReader(new FileReader(dataFile));
            imdl = new IteratingSDFReader(fin, builder);
            System.out.print("Read File in..");
        }
        catch (Exception exc) {
            System.out.println("Could not read Molecules from file " + dataFile + " due to: " + exc.getMessage());
        }
        System.out.println("READY");
        while (imdl.hasNext()) {
            m = imdl.next();
            System.out.println("Atoms:" + m.getAtomCount());
            IRingSet ringSetM = Cycles.sssr(m).toRingSet();
            for (int i = 0; i < ringSetM.getAtomContainerCount(); ++i) {
                som.addAtomContainer(builder.newInstance(IAtomContainer.class, ringSetM.getAtomContainer(i)));
            }
        }
        try {
            imdl.close();
        }
        catch (Exception exc1) {
            System.out.println("Could not close Reader due to: " + exc1.getMessage());
        }
        System.out.println(som.getAtomContainerCount() + " Templates are read in");
        this.writeChemModel(som, dataFile, "_VERSUCH");
    }

    public void extractUniqueRingSystemsFromFile(String dataFile) {
        System.out.println("****** EXTRACT UNIQUE RING SYSTEMS ******");
        System.out.println("From file:" + dataFile);
        IAtomContainer m = null;
        List<IRingSet> ringSystems = null;
        IteratingSDFReader imdl = null;
        HashMap<String, String> hashRingSystems = new HashMap<String, String>();
        SmilesGenerator smilesGenerator = new SmilesGenerator();
        int counterRings = 0;
        int counterMolecules = 0;
        int counterUniqueRings = 0;
        IRingSet ringSet = null;
        String key = "";
        IAtomContainer ac = null;
        String molfile = dataFile + "_UniqueRings";
        MDLV2000Writer mdlw = null;
        try {
            FileOutputStream fout = new FileOutputStream(molfile);
            mdlw = new MDLV2000Writer(fout);
        }
        catch (Exception ex2) {
            System.out.println("IOError:cannot write file due to:" + ex2.toString());
        }
        try {
            System.out.println("Start...");
            BufferedReader fin = new BufferedReader(new FileReader(dataFile));
            imdl = new IteratingSDFReader(fin, builder);
            System.out.println("Read File in..");
        }
        catch (Exception exc) {
            System.out.println("Could not read Molecules from file " + dataFile + " due to: " + exc.getMessage());
        }
        while (imdl.hasNext()) {
            m = imdl.next();
            IRingSet ringSetM = Cycles.sssr(m).toRingSet();
            if (++counterMolecules % 1000 == 0) {
                System.out.println("Molecules:" + counterMolecules);
            }
            if (ringSetM.getAtomContainerCount() <= 0) continue;
            ringSystems = RingPartitioner.partitionRings(ringSetM);
            for (int i = 0; i < ringSystems.size(); ++i) {
                ringSet = ringSystems.get(i);
                ac = builder.newInstance(IAtomContainer.class, new Object[0]);
                Iterator<IAtomContainer> containers = RingSetManipulator.getAllAtomContainers(ringSet).iterator();
                while (containers.hasNext()) {
                    ac.add(containers.next());
                }
                ++counterRings;
                for (int j = 0; j < ac.getAtomCount(); ++j) {
                    ac.getAtom(j).setSymbol("C");
                }
                try {
                    key = smilesGenerator.create(builder.newInstance(IAtomContainer.class, ac));
                }
                catch (CDKException e) {
                    LoggingToolFactory.createLoggingTool(this.getClass()).error(e);
                    return;
                }
                if (hashRingSystems.containsKey(key)) continue;
                ++counterUniqueRings;
                hashRingSystems.put(key, "1");
                try {
                    mdlw.write(builder.newInstance(IAtomContainer.class, ac));
                    continue;
                }
                catch (IllegalArgumentException | CDKException emdl) {
                    // empty catch block
                }
            }
        }
        try {
            imdl.close();
            mdlw.close();
        }
        catch (Exception exc1) {
            System.out.println("Could not close iterator mdl reader due to: " + exc1.getMessage());
        }
        System.out.println("READY Molecules:" + counterMolecules + " RingSystems:" + counterRings + " UniqueRingsSystem:" + counterUniqueRings);
        System.out.println("HashtableKeys:" + hashRingSystems.size());
    }

    public void writeChemModel(IAtomContainerSet som, String file, String endFix) {
        System.out.println("WRITE Molecules:" + som.getAtomContainerCount());
        String molfile = file + endFix;
        try {
            FileOutputStream fout = new FileOutputStream(molfile);
            MDLV2000Writer mdlw = new MDLV2000Writer(fout);
            mdlw.write(som);
            mdlw.close();
        }
        catch (IOException | CDKException ex2) {
            System.out.println("IOError:cannot write file due to:" + ex2.toString());
        }
    }

    public void makeCanonicalSmileFromRingSystems(String dataFileIn, String dataFileOut) {
        System.out.println("Start make SMILES...");
        IAtomContainer m = null;
        IteratingSDFReader imdl = null;
        ArrayList<String> data = new ArrayList<String>();
        SmilesGenerator smiles = new SmilesGenerator();
        try {
            System.out.println("Start...");
            BufferedReader fin = new BufferedReader(new FileReader(dataFileIn));
            imdl = new IteratingSDFReader(fin, builder);
            System.out.println("Read File in..");
        }
        catch (Exception exc) {
            System.out.println("Could not read Molecules from file " + dataFileIn + " due to: " + exc.getMessage());
        }
        while (imdl.hasNext()) {
            m = imdl.next();
            try {
                data.add(smiles.create(builder.newInstance(IAtomContainer.class, m)));
            }
            catch (IllegalArgumentException | CDKException exc1) {
                System.out.println("Could not create smile due to: " + exc1.getMessage());
            }
        }
        try {
            imdl.close();
        }
        catch (Exception exc2) {
            // empty catch block
        }
        System.out.print("...ready\nWrite data...");
        BufferedWriter fout = null;
        try {
            fout = new BufferedWriter(new FileWriter(dataFileOut));
        }
        catch (Exception exc3) {
            System.out.println("Could not write smile in file " + dataFileOut + " due to: " + exc3.getMessage());
        }
        for (int i = 0; i < data.size(); ++i) {
            try {
                fout.write((String)data.get(i));
                fout.newLine();
                continue;
            }
            catch (Exception exc4) {
                // empty catch block
            }
        }
        System.out.println("number of smiles:" + data.size());
        System.out.println("...ready");
        try {
            fout.close();
        }
        catch (Exception exc5) {
            // empty catch block
        }
    }

    public List<IBitFingerprint> makeFingerprintsFromSdf(boolean anyAtom, boolean anyAtomAnyBond, Map<String, Integer> timings, BufferedReader fin, int limit) throws Exception {
        HybridizationFingerprinter fingerPrinter = new HybridizationFingerprinter(1024, 8);
        IAtomContainer m = null;
        IteratingSDFReader imdl = null;
        IAtomContainer query2 = null;
        ArrayList<IBitFingerprint> data = new ArrayList<IBitFingerprint>();
        try {
            System.out.print("Read data file in ...");
            imdl = new IteratingSDFReader(fin, builder);
            System.out.println("ready");
        }
        catch (Exception exc) {
            System.out.println("Could not read Molecules from file due to: " + exc.getMessage());
        }
        int moleculeCounter = 0;
        int fingerprintCounter = 0;
        System.out.print("Generated Fingerprints: " + fingerprintCounter + "    ");
        while (imdl.hasNext() && (moleculeCounter < limit || limit == -1)) {
            m = imdl.next();
            ++moleculeCounter;
            query2 = anyAtom && !anyAtomAnyBond ? QueryAtomContainerCreator.createAnyAtomContainer(m, false) : AtomContainerManipulator.anonymise(m);
            try {
                long time = -System.currentTimeMillis();
                if (anyAtom || anyAtomAnyBond) {
                    data.add(fingerPrinter.getBitFingerprint(query2));
                    ++fingerprintCounter;
                } else {
                    data.add(fingerPrinter.getBitFingerprint(query2));
                    ++fingerprintCounter;
                }
                String bin = Integer.toString((int)Math.floor((time += System.currentTimeMillis()) / 10L));
                if (timings.containsKey(bin)) {
                    timings.put(bin, timings.get(bin) + 1);
                } else {
                    timings.put(bin, 1);
                }
            }
            catch (Exception exc1) {
                System.out.println("QueryFingerprintError: from molecule:" + moleculeCounter + " due to:" + exc1.getMessage());
                BitSetFingerprint allOnesFingerprint = new BitSetFingerprint(fingerPrinter.getSize());
                for (int i = 0; i < fingerPrinter.getSize(); ++i) {
                    allOnesFingerprint.set(i, true);
                }
                data.add(allOnesFingerprint);
                ++fingerprintCounter;
            }
            if (fingerprintCounter % 2 == 0) {
                System.out.print("\b/");
            } else {
                System.out.print("\b\\");
            }
            if (fingerprintCounter % 100 != 0) continue;
            System.out.print("\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\bGenerated Fingerprints: " + fingerprintCounter + "   \n");
        }
        try {
            imdl.close();
        }
        catch (Exception exc2) {
            exc2.printStackTrace();
        }
        System.out.print("...ready with:" + moleculeCounter + " molecules\nWrite data...of data vector:" + data.size() + " fingerprintCounter:" + fingerprintCounter);
        return data;
    }

    public void makeFingerprintFromRingSystems(String dataFileIn, String dataFileOut, boolean anyAtom, boolean anyAtomAnyBond) throws Exception {
        HashMap<String, Integer> timings = new HashMap<String, Integer>();
        System.out.println("Start make fingerprint from file:" + dataFileIn + " ...");
        BufferedReader fin = new BufferedReader(new FileReader(dataFileIn));
        List<IBitFingerprint> data = this.makeFingerprintsFromSdf(anyAtom, anyAtomAnyBond, timings, fin, -1);
        BufferedWriter fout = null;
        try {
            fout = new BufferedWriter(new FileWriter(dataFileOut));
        }
        catch (Exception exc3) {
            System.out.println("Could not write Fingerprint in file " + dataFileOut + " due to: " + exc3.getMessage());
        }
        for (int i = 0; i < data.size(); ++i) {
            try {
                fout.write(data.get(i).toString());
                fout.newLine();
                continue;
            }
            catch (Exception exc4) {
                // empty catch block
            }
        }
        System.out.println("\nFingerprints:" + data.size() + " are written...ready");
        System.out.println("\nComputing time statistics:\n" + ((Object)timings).toString());
        try {
            fout.close();
        }
        catch (Exception exc5) {
            // empty catch block
        }
    }

    public IAtomContainer removeLoopBonds(IAtomContainer molecule, int position) {
        for (int i = 0; i < molecule.getBondCount(); ++i) {
            IBond bond = molecule.getBond(i);
            if (bond.getAtom(0) != bond.getAtom(1)) continue;
            System.out.println("Loop found! Molecule:" + position);
            molecule.removeBond(bond);
        }
        return molecule;
    }

    public IAtomContainer createAnyAtomAtomContainer(IAtomContainer atomContainer) throws Exception {
        IAtomContainer query2 = atomContainer.clone();
        for (int i = 0; i < query2.getAtomCount(); ++i) {
            query2.getAtom(i).setSymbol("C");
        }
        return query2;
    }

    public IAtomContainer resetFlags(IAtomContainer ac) {
        int f;
        for (f = 0; f < ac.getAtomCount(); ++f) {
            ac.getAtom(f).setFlag(16, false);
        }
        for (f = 0; f < ac.getElectronContainerCount(); ++f) {
            ac.getElectronContainer(f).setFlag(16, false);
        }
        return ac;
    }

    public static void main(String[] args) {
        if (args.length < 4) {
            System.out.println(usage);
        }
        try {
            new TemplateExtractor().makeFingerprintFromRingSystems(args[0], args[1], Boolean.valueOf(args[2]), Boolean.valueOf(args[3]));
        }
        catch (Exception e) {
            System.out.println(usage);
            e.printStackTrace();
        }
    }
}

