/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.isomorphism.matchers;

import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import org.openscience.cdk.CDKConstants;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomType;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.isomorphism.matchers.IQueryAtom;
import org.openscience.cdk.isomorphism.matchers.QueryChemObject;
import org.openscience.cdk.tools.periodictable.PeriodicTable;

public abstract class QueryAtom
extends QueryChemObject
implements IQueryAtom {
    protected Double charge = (Double)CDKConstants.UNSET;
    protected Point2d point2d = (Point2d)CDKConstants.UNSET;
    protected Point3d point3d = (Point3d)CDKConstants.UNSET;
    protected Point3d fractionalPoint3d = (Point3d)CDKConstants.UNSET;
    protected Integer hydrogenCount = (Integer)CDKConstants.UNSET;
    protected Integer stereoParity = (Integer)CDKConstants.UNSET;
    IBond.Order maxBondOrder = null;
    Double bondOrderSum = (Double)CDKConstants.UNSET;
    Double covalentRadius = (Double)CDKConstants.UNSET;
    protected Integer formalCharge = (Integer)CDKConstants.UNSET;
    protected IAtomType.Hybridization hybridization = (IAtomType.Hybridization)((Object)CDKConstants.UNSET);
    protected Integer electronValency = (Integer)CDKConstants.UNSET;
    protected Integer formalNeighbourCount = (Integer)CDKConstants.UNSET;
    private String identifier = (String)CDKConstants.UNSET;
    public Double exactMass;
    public Double naturalAbundance;
    private Integer massNumber;
    protected String symbol;
    protected Integer atomicNumber = (Integer)CDKConstants.UNSET;

    public QueryAtom(String symbol, IChemObjectBuilder builder) {
        this(builder);
        this.symbol = symbol;
        this.atomicNumber = PeriodicTable.getAtomicNumber(symbol);
    }

    public QueryAtom(IChemObjectBuilder builder) {
        super(builder);
    }

    @Override
    public void setCharge(Double charge) {
        this.charge = charge;
        this.notifyChanged();
    }

    @Override
    public Double getCharge() {
        return this.charge;
    }

    @Override
    public void setImplicitHydrogenCount(Integer hydrogenCount) {
        this.hydrogenCount = hydrogenCount;
        this.notifyChanged();
    }

    @Override
    public Integer getImplicitHydrogenCount() {
        return this.hydrogenCount;
    }

    @Override
    public void setPoint2d(Point2d point2d) {
        this.point2d = point2d;
        this.notifyChanged();
    }

    @Override
    public void setPoint3d(Point3d point3d) {
        this.point3d = point3d;
        this.notifyChanged();
    }

    @Override
    public void setFractionalPoint3d(Point3d point3d) {
        this.fractionalPoint3d = point3d;
        this.notifyChanged();
    }

    @Override
    public void setStereoParity(Integer stereoParity) {
        this.stereoParity = stereoParity;
        this.notifyChanged();
    }

    @Override
    public Point2d getPoint2d() {
        return this.point2d;
    }

    @Override
    public Point3d getPoint3d() {
        return this.point3d;
    }

    @Override
    public Point3d getFractionalPoint3d() {
        return this.fractionalPoint3d;
    }

    @Override
    public Integer getStereoParity() {
        return this.stereoParity;
    }

    @Override
    public void setAtomTypeName(String identifier) {
        this.identifier = identifier;
        this.notifyChanged();
    }

    @Override
    public void setMaxBondOrder(IBond.Order maxBondOrder) {
        this.maxBondOrder = maxBondOrder;
        this.notifyChanged();
    }

    @Override
    public void setBondOrderSum(Double bondOrderSum) {
        this.bondOrderSum = bondOrderSum;
        this.notifyChanged();
    }

    @Override
    public String getAtomTypeName() {
        return this.identifier;
    }

    @Override
    public IBond.Order getMaxBondOrder() {
        return this.maxBondOrder;
    }

    @Override
    public Double getBondOrderSum() {
        return this.bondOrderSum;
    }

    @Override
    public void setFormalCharge(Integer charge) {
        this.formalCharge = charge;
        this.notifyChanged();
    }

    @Override
    public Integer getFormalCharge() {
        return this.formalCharge;
    }

    @Override
    public void setFormalNeighbourCount(Integer count) {
        this.formalNeighbourCount = count;
        this.notifyChanged();
    }

    @Override
    public Integer getFormalNeighbourCount() {
        return this.formalNeighbourCount;
    }

    @Override
    public void setHybridization(IAtomType.Hybridization hybridization) {
        this.hybridization = hybridization;
        this.notifyChanged();
    }

    @Override
    public IAtomType.Hybridization getHybridization() {
        return this.hybridization;
    }

    @Override
    public void setNaturalAbundance(Double naturalAbundance) {
        this.naturalAbundance = naturalAbundance;
        this.notifyChanged();
    }

    @Override
    public void setExactMass(Double exactMass) {
        this.exactMass = exactMass;
        this.notifyChanged();
    }

    @Override
    public Double getNaturalAbundance() {
        return this.naturalAbundance;
    }

    @Override
    public Double getExactMass() {
        return this.exactMass;
    }

    @Override
    public Integer getMassNumber() {
        return this.massNumber;
    }

    @Override
    public void setMassNumber(Integer massNumber) {
        this.massNumber = massNumber;
        this.notifyChanged();
    }

    @Override
    public Integer getAtomicNumber() {
        return this.atomicNumber;
    }

    @Override
    public void setAtomicNumber(Integer atomicNumber) {
        this.atomicNumber = atomicNumber;
        this.notifyChanged();
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public void setSymbol(String symbol) {
        this.symbol = symbol;
        this.notifyChanged();
    }

    @Override
    public void setCovalentRadius(Double radius) {
        this.covalentRadius = radius;
        this.notifyChanged();
    }

    @Override
    public Double getCovalentRadius() {
        return this.covalentRadius;
    }

    @Override
    public void setValency(Integer valency) {
        this.electronValency = valency;
        this.notifyChanged();
    }

    @Override
    public Integer getValency() {
        return this.electronValency;
    }

    @Override
    public boolean isAromatic() {
        return this.getFlag(32);
    }

    @Override
    public void setIsAromatic(boolean arom) {
        this.setFlag(32, arom);
    }

    @Override
    public boolean isInRing() {
        return this.getFlag(2);
    }

    @Override
    public void setIsInRing(boolean ring) {
        this.setFlag(2, ring);
    }

    @Override
    public IAtom clone() throws CloneNotSupportedException {
        return (IAtom)super.clone();
    }
}

