/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org._3pq.jgrapht.Edge;
import org._3pq.jgrapht.UndirectedGraph;
import org._3pq.jgrapht.alg.ConnectivityInspector;
import org._3pq.jgrapht.event.GraphEdgeChangeEvent;
import org._3pq.jgrapht.event.GraphVertexChangeEvent;
import org._3pq.jgrapht.graph.SimpleGraph;
import org._3pq.jgrapht.graph.Subgraph;

public class BiconnectivityInspector {
    private List biconnectedSets;
    private UndirectedGraph graph;

    public BiconnectivityInspector(UndirectedGraph g) {
        this.graph = g;
    }

    private List lazyFindBiconnectedSets() {
        if (this.biconnectedSets == null) {
            this.biconnectedSets = new ArrayList();
            for (Set connectedSet : new ConnectivityInspector(this.graph).connectedSets()) {
                if (connectedSet.size() == 1) continue;
                Subgraph subgraph = new Subgraph(this.graph, connectedSet, null);
                Stack<Object> vertexStack = new Stack<Object>();
                HashSet<Object> visitedVertices = new HashSet<Object>();
                HashMap<Object, Object> parent = new HashMap<Object, Object>();
                ArrayList<Object> dfsVertices = new ArrayList<Object>();
                HashSet<Edge> treeEdges = new HashSet<Edge>();
                Object currentVertex = subgraph.vertexSet().toArray()[0];
                vertexStack.push(currentVertex);
                visitedVertices.add(currentVertex);
                while (!vertexStack.isEmpty()) {
                    currentVertex = vertexStack.pop();
                    Object parentVertex = parent.get(currentVertex);
                    if (parentVertex != null) {
                        Edge edge = subgraph.getEdge(parentVertex, currentVertex);
                        treeEdges.add(edge);
                    }
                    visitedVertices.add(currentVertex);
                    dfsVertices.add(currentVertex);
                    for (Edge edge : subgraph.edgesOf(currentVertex)) {
                        Object object;
                        if (treeEdges.contains(edge) || visitedVertices.contains(object = edge.oppositeVertex(currentVertex))) continue;
                        vertexStack.push(object);
                        parent.put(object, currentVertex);
                    }
                }
                SimpleGraph h = new SimpleGraph();
                h.addAllVertices(treeEdges);
                visitedVertices.clear();
                HashSet<Edge> connected = new HashSet<Edge>();
                for (Object e : dfsVertices) {
                    visitedVertices.add(e);
                    for (Edge l : subgraph.edgesOf(e)) {
                        if (treeEdges.contains(l)) continue;
                        h.addVertex(l);
                        Object u = l.oppositeVertex(e);
                        if (visitedVertices.contains(u)) continue;
                        while (u != e) {
                            Object pu = parent.get(u);
                            Edge f = subgraph.getEdge(u, pu);
                            h.addEdge(f, l);
                            if (!connected.contains(f)) {
                                connected.add(f);
                                u = pu;
                                continue;
                            }
                            u = e;
                        }
                    }
                }
                ConnectivityInspector connectivityInspector = new ConnectivityInspector(h);
                this.biconnectedSets.addAll(connectivityInspector.connectedSets());
            }
        }
        return this.biconnectedSets;
    }

    public List biconnectedSets() {
        return this.lazyFindBiconnectedSets();
    }

    private void init() {
        this.biconnectedSets = null;
    }

    public void edgeAdded(GraphEdgeChangeEvent e) {
        this.init();
    }

    public void edgeRemoved(GraphEdgeChangeEvent e) {
        this.init();
    }

    public void vertexAdded(GraphVertexChangeEvent e) {
        this.init();
    }

    public void vertexRemoved(GraphVertexChangeEvent e) {
        this.init();
    }
}

