/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.List;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerArrayResult;
import org.openscience.cdk.qsar.result.IntegerArrayResultType;
import org.openscience.cdk.tools.manipulator.BondManipulator;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.CarbonTypesDescriptorTest")
public class CarbonTypesDescriptor
implements IMolecularDescriptor {
    private static final String[] names = new String[]{"C1SP1", "C2SP1", "C1SP2", "C2SP2", "C3SP2", "C1SP3", "C2SP3", "C3SP3", "C4SP3"};

    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#carbonTypes", this.getClass().getName(), "$Id: ab88e6f55b258640c8da0c1cbb96d65a2c15ecac $", "The Chemistry Development Kit");
    }

    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
    }

    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return null;
    }

    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return null;
    }

    @TestMethod(value="testCalculate_IAtomContainer,testButane,testComplex1,testComplex2")
    public DescriptorValue calculate(IAtomContainer container) {
        int c1sp1 = 0;
        int c2sp1 = 0;
        int c1sp2 = 0;
        int c2sp2 = 0;
        int c3sp2 = 0;
        int c1sp3 = 0;
        int c2sp3 = 0;
        int c3sp3 = 0;
        int c4sp3 = 0;
        for (IAtom atom : container.atoms()) {
            if (!atom.getSymbol().equals("C") && !atom.getSymbol().equals("c")) continue;
            List<IAtom> connectedAtoms = container.getConnectedAtomsList(atom);
            int cc = 0;
            for (IAtom connectedAtom : connectedAtoms) {
                if (!connectedAtom.getSymbol().equals("C") && !connectedAtom.getSymbol().equals("c")) continue;
                ++cc;
            }
            IBond.Order maxBondOrder = this.getHighestBondOrder(container, atom);
            if (maxBondOrder == IBond.Order.TRIPLE && cc == 1) {
                ++c1sp1;
                continue;
            }
            if (maxBondOrder == IBond.Order.TRIPLE && cc == 2) {
                ++c2sp1;
                continue;
            }
            if (maxBondOrder == IBond.Order.DOUBLE && cc == 1) {
                ++c1sp2;
                continue;
            }
            if (maxBondOrder == IBond.Order.DOUBLE && cc == 2) {
                ++c2sp2;
                continue;
            }
            if (maxBondOrder == IBond.Order.DOUBLE && cc == 3) {
                ++c3sp2;
                continue;
            }
            if (maxBondOrder == IBond.Order.SINGLE && cc == 1) {
                ++c1sp3;
                continue;
            }
            if (maxBondOrder == IBond.Order.SINGLE && cc == 2) {
                ++c2sp3;
                continue;
            }
            if (maxBondOrder == IBond.Order.SINGLE && cc == 3) {
                ++c3sp3;
                continue;
            }
            if (maxBondOrder != IBond.Order.SINGLE || cc != 4) continue;
            ++c4sp3;
        }
        IntegerArrayResult retval = new IntegerArrayResult(9);
        retval.add(c1sp1);
        retval.add(c2sp1);
        retval.add(c1sp2);
        retval.add(c2sp2);
        retval.add(c3sp2);
        retval.add(c1sp3);
        retval.add(c2sp3);
        retval.add(c3sp3);
        retval.add(c4sp3);
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), retval, this.getDescriptorNames());
    }

    private IBond.Order getHighestBondOrder(IAtomContainer container, IAtom atom) {
        List<IBond> bonds = container.getConnectedBondsList(atom);
        IBond.Order maxOrder = IBond.Order.SINGLE;
        for (IBond bond : bonds) {
            if (!BondManipulator.isHigherOrder(bond.getOrder(), maxOrder)) continue;
            maxOrder = bond.getOrder();
        }
        return maxOrder;
    }

    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new IntegerArrayResultType(9);
    }
}

