/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.algorithm.mcgregor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.isomorphism.matchers.IQueryAtomContainer;
import org.openscience.cdk.smsd.algorithm.mcgregor.McGregorChecks;
import org.openscience.cdk.smsd.algorithm.mcgregor.McgregorHelper;
import org.openscience.cdk.smsd.algorithm.mcgregor.QueryProcessor;
import org.openscience.cdk.smsd.algorithm.mcgregor.TargetProcessor;
import org.openscience.cdk.smsd.helper.BinaryTree;

@TestClass(value="org.openscience.cdk.smsd.algorithm.mcgregor.McGregorTest")
public final class McGregor {
    private IAtomContainer source = null;
    private IAtomContainer target = null;
    private BinaryTree last = null;
    private BinaryTree first = null;
    private Stack<List<Integer>> bestARCS = null;
    private List<Integer> modifiedARCS = null;
    private int bestarcsleft = 0;
    private int globalMCSSize = 0;
    private List<List<Integer>> mappings = null;
    private static final String[] SIGNS = new String[]{"$1", "$2", "$3", "$4", "$5", "$6", "$7", "$8", "$9", "$10", "$11", "$12", "$13", "$15", "$16", "$17", "$18", "$19", "$20", "$21", "$22", "$23", "$24", "$25", "$26", "$27", "$28", "$29", "$30", "$31", "$32", "$33", "$34", "$35", "$36", "$37", "$38", "$39", "$40", "$41", "$42", "$43", "$44", "$45", "$46", "$47", "$48", "$49", "$50", "$51", "$52", "$53", "$54", "$55"};
    private boolean newMatrix = false;
    private boolean bondMatch = false;

    public McGregor(IAtomContainer source, IAtomContainer target, List<List<Integer>> _mappings, boolean shouldMatchBonds) {
        this.setBondMatch(shouldMatchBonds);
        this.source = source;
        this.target = target;
        this.mappings = _mappings;
        this.bestarcsleft = 0;
        this.globalMCSSize = !_mappings.isEmpty() ? _mappings.get(0).size() : 0;
        this.modifiedARCS = new ArrayList<Integer>();
        this.bestARCS = new Stack();
        this.newMatrix = false;
    }

    public McGregor(IQueryAtomContainer source, IAtomContainer target, List<List<Integer>> _mappings) {
        this.setBondMatch(true);
        this.source = source;
        this.target = target;
        this.mappings = _mappings;
        this.bestarcsleft = 0;
        this.globalMCSSize = !_mappings.isEmpty() ? _mappings.get(0).size() : 0;
        this.modifiedARCS = new ArrayList<Integer>();
        this.bestARCS = new Stack();
        this.newMatrix = false;
    }

    public void startMcGregorIteration(int largestMappingSize, Map<Integer, Integer> present_Mapping) throws IOException {
        this.globalMCSSize = largestMappingSize / 2;
        List<String> c_tab1_copy = McGregorChecks.generateCTabCopy(this.source);
        List<String> c_tab2_copy = McGregorChecks.generateCTabCopy(this.target);
        ArrayList<Integer> mapped_atoms = new ArrayList<Integer>();
        for (Map.Entry<Integer, Integer> map : present_Mapping.entrySet()) {
            mapped_atoms.add(map.getKey());
            mapped_atoms.add(map.getValue());
        }
        int mapping_size = present_Mapping.size();
        List<Integer> i_bond_neighborsA = new ArrayList<Integer>();
        List<String> c_bond_neighborsA = new ArrayList<String>();
        ArrayList<Integer> i_bond_setA = new ArrayList<Integer>();
        ArrayList<String> c_bond_setA = new ArrayList<String>();
        List<Integer> i_bond_neighborsB = new ArrayList<Integer>();
        ArrayList<Integer> i_bond_setB = new ArrayList<Integer>();
        List<String> c_bond_neighborsB = new ArrayList<String>();
        ArrayList<String> c_bond_setB = new ArrayList<String>();
        List<Integer> unmapped_atoms_molA = McGregorChecks.markUnMappedAtoms(true, this.source, present_Mapping);
        int counter = 0;
        int gSetBondNumA = 0;
        int gSetBondNumB = 0;
        int gNeighborBondnumA = 0;
        int gNeighborBondNumB = 0;
        QueryProcessor queryProcess = new QueryProcessor(c_tab1_copy, c_tab2_copy, SIGNS, gNeighborBondnumA, gSetBondNumA, i_bond_neighborsA, c_bond_neighborsA, mapping_size, i_bond_setA, c_bond_setA);
        if (!(this.source instanceof IQueryAtomContainer)) {
            queryProcess.process(this.source, this.target, unmapped_atoms_molA, mapped_atoms, counter);
        } else {
            queryProcess.process((IQueryAtomContainer)this.source, this.target, unmapped_atoms_molA, mapped_atoms, counter);
        }
        c_tab1_copy = queryProcess.getCTab1();
        c_tab2_copy = queryProcess.getCTab2();
        gSetBondNumA = queryProcess.getBondNumA();
        gNeighborBondnumA = queryProcess.getNeighborBondNumA();
        i_bond_neighborsA = queryProcess.getIBondNeighboursA();
        c_bond_neighborsA = queryProcess.getCBondNeighborsA();
        List<Integer> unmapped_atoms_molB = McGregorChecks.markUnMappedAtoms(false, this.target, present_Mapping);
        TargetProcessor targetProcess = new TargetProcessor(c_tab1_copy, c_tab2_copy, SIGNS, gNeighborBondNumB, gSetBondNumB, i_bond_neighborsB, c_bond_neighborsB, gNeighborBondnumA, i_bond_neighborsA, c_bond_neighborsA);
        targetProcess.process(this.target, unmapped_atoms_molB, mapping_size, i_bond_setB, c_bond_setB, mapped_atoms, counter);
        c_tab1_copy = targetProcess.getCTab1();
        c_tab2_copy = targetProcess.getCTab2();
        gSetBondNumB = targetProcess.getBondNumB();
        gNeighborBondNumB = targetProcess.getNeighborBondNumB();
        i_bond_neighborsB = targetProcess.getIBondNeighboursB();
        c_bond_neighborsB = targetProcess.getCBondNeighborsB();
        boolean dummy = false;
        McgregorHelper mcGregorHelper = new McgregorHelper(dummy, present_Mapping.size(), mapped_atoms, gNeighborBondnumA, gNeighborBondNumB, i_bond_neighborsA, i_bond_neighborsB, c_bond_neighborsA, c_bond_neighborsB, gSetBondNumA, gSetBondNumB, i_bond_setA, i_bond_setB, c_bond_setA, c_bond_setB);
        this.iterator(mcGregorHelper);
    }

    public void startMcGregorIteration(int largestMappingSize, List<Integer> clique_vector, List<Integer> comp_graph_nodes) throws IOException {
        this.globalMCSSize = largestMappingSize / 2;
        List<String> c_tab1_copy = McGregorChecks.generateCTabCopy(this.source);
        List<String> c_tab2_copy = McGregorChecks.generateCTabCopy(this.target);
        ArrayList<Integer> mapped_atoms = new ArrayList<Integer>();
        int mappedAtomCount = 0;
        List<Integer> iBondNeighborAtomsA = new ArrayList<Integer>();
        List<String> cBondNeighborsA = new ArrayList<String>();
        ArrayList<Integer> i_bond_setA = new ArrayList<Integer>();
        ArrayList<String> c_bond_setA = new ArrayList<String>();
        List<Integer> iBondNeighborAtomsB = new ArrayList<Integer>();
        ArrayList<Integer> i_bond_setB = new ArrayList<Integer>();
        List<String> cBondNeighborsB = new ArrayList<String>();
        ArrayList<String> c_bond_setB = new ArrayList<String>();
        int clique_siz = clique_vector.size();
        int vec_size = comp_graph_nodes.size();
        int cliqueNumber = 0;
        for (int a = 0; a < clique_siz; ++a) {
            cliqueNumber = clique_vector.get(a);
            for (int b = 0; b < vec_size; b += 3) {
                if (cliqueNumber != comp_graph_nodes.get(b + 2)) continue;
                mapped_atoms.add(comp_graph_nodes.get(b));
                mapped_atoms.add(comp_graph_nodes.get(b + 1));
                ++mappedAtomCount;
            }
        }
        List<Integer> unmapped_atoms_molA = McGregorChecks.markUnMappedAtoms(true, this.source, mapped_atoms, clique_siz);
        int counter = 0;
        int setNumA = 0;
        int setNumB = 0;
        int localNeighborBondnumA = 0;
        int localNeighborBondNumB = 0;
        QueryProcessor queryProcess = new QueryProcessor(c_tab1_copy, c_tab2_copy, SIGNS, localNeighborBondnumA, setNumA, iBondNeighborAtomsA, cBondNeighborsA, clique_siz, i_bond_setA, c_bond_setA);
        queryProcess.process(this.source, this.target, unmapped_atoms_molA, mapped_atoms, counter);
        c_tab1_copy = queryProcess.getCTab1();
        c_tab2_copy = queryProcess.getCTab2();
        setNumA = queryProcess.getBondNumA();
        localNeighborBondnumA = queryProcess.getNeighborBondNumA();
        iBondNeighborAtomsA = queryProcess.getIBondNeighboursA();
        cBondNeighborsA = queryProcess.getCBondNeighborsA();
        List<Integer> unmapped_atoms_molB = McGregorChecks.markUnMappedAtoms(false, this.target, mapped_atoms, clique_siz);
        TargetProcessor targetProcess = new TargetProcessor(c_tab1_copy, c_tab2_copy, SIGNS, localNeighborBondNumB, setNumB, iBondNeighborAtomsB, cBondNeighborsB, localNeighborBondnumA, iBondNeighborAtomsA, cBondNeighborsA);
        targetProcess.process(this.target, unmapped_atoms_molB, clique_siz, i_bond_setB, c_bond_setB, mapped_atoms, counter);
        c_tab1_copy = targetProcess.getCTab1();
        c_tab2_copy = targetProcess.getCTab2();
        setNumB = targetProcess.getBondNumB();
        localNeighborBondNumB = targetProcess.getNeighborBondNumB();
        iBondNeighborAtomsB = targetProcess.getIBondNeighboursB();
        cBondNeighborsB = targetProcess.getCBondNeighborsB();
        boolean dummy = false;
        McgregorHelper mcGregorHelper = new McgregorHelper(dummy, mappedAtomCount, mapped_atoms, localNeighborBondnumA, localNeighborBondNumB, iBondNeighborAtomsA, iBondNeighborAtomsB, cBondNeighborsA, cBondNeighborsB, setNumA, setNumB, i_bond_setA, i_bond_setB, c_bond_setA, c_bond_setB);
        this.iterator(mcGregorHelper);
    }

    private int iterator(McgregorHelper mcGregorHelper) throws IOException {
        boolean mappingCheckFlag = mcGregorHelper.isMappingCheckFlag();
        int mappedAtomCount = mcGregorHelper.getMappedAtomCount();
        ArrayList<Integer> mappedAtoms = new ArrayList<Integer>(mcGregorHelper.getMappedAtomsOrg());
        int neighborBondNumA = mcGregorHelper.getNeighborBondNumA();
        int neighborBondNumB = mcGregorHelper.getNeighborBondNumB();
        boolean furtherMappingFlag = McGregorChecks.isFurtherMappingPossible(this.source, this.target, mcGregorHelper, this.isBondMatch());
        if (neighborBondNumA == 0 || neighborBondNumB == 0 || mappingCheckFlag || !furtherMappingFlag) {
            this.setFinalMappings(mappedAtoms, mappedAtomCount);
            return 0;
        }
        this.modifiedARCS.clear();
        int size = neighborBondNumA * neighborBondNumB;
        for (int i = 0; i < size; ++i) {
            this.modifiedARCS.add(i, 0);
        }
        this.setModifedArcs(mcGregorHelper);
        this.last = this.first = new BinaryTree(-1);
        this.last.setEqual(null);
        this.last.setNotEqual(null);
        this.bestarcsleft = 0;
        this.startsearch(mcGregorHelper);
        Stack<List<Integer>> BESTARCS_copy = new Stack<List<Integer>>();
        BESTARCS_copy.addAll(this.bestARCS);
        while (!this.bestARCS.empty()) {
            this.bestARCS.pop();
        }
        this.searchAndExtendMappings(BESTARCS_copy, mcGregorHelper);
        return 0;
    }

    private void searchAndExtendMappings(Stack<List<Integer>> BESTARCS_copy, McgregorHelper mcGregorHelper) throws IOException {
        int mappedAtomCount = mcGregorHelper.getMappedAtomCount();
        int setNumA = mcGregorHelper.getSetNumA();
        int setNumB = mcGregorHelper.getsetNumB();
        List<Integer> i_bond_setA = mcGregorHelper.getIBondSetA();
        List<Integer> i_bond_setB = mcGregorHelper.getIBondSetB();
        List<String> c_bond_setA = mcGregorHelper.getCBondSetA();
        List<String> c_bond_setB = mcGregorHelper.getCBondSetB();
        while (!BESTARCS_copy.empty()) {
            ArrayList<Integer> MARCS_vector = new ArrayList<Integer>((Collection)BESTARCS_copy.peek());
            List<Integer> new_Mapping = this.findMcGregorMapping(MARCS_vector, mcGregorHelper);
            int newMapingSize = new_Mapping.size() / 2;
            boolean no_further_MAPPINGS = false;
            if (mappedAtomCount == newMapingSize) {
                no_further_MAPPINGS = true;
            }
            List<Integer> new_i_neighborsA = new ArrayList<Integer>();
            List<Integer> new_i_neighborsB = new ArrayList<Integer>();
            List<String> new_c_neighborsA = new ArrayList<String>();
            List<String> new_c_neighborsB = new ArrayList<String>();
            ArrayList<Integer> new_i_bond_setA = new ArrayList<Integer>();
            ArrayList<Integer> new_i_bond_setB = new ArrayList<Integer>();
            ArrayList<String> new_c_bond_setA = new ArrayList<String>();
            ArrayList<String> new_c_bond_setB = new ArrayList<String>();
            List<String> c_setA_copy = McGregorChecks.generateCSetCopy(setNumA, c_bond_setA);
            List<String> c_setB_copy = McGregorChecks.generateCSetCopy(setNumB, c_bond_setB);
            ArrayList<Integer> unmapped_atoms_molA = new ArrayList<Integer>();
            int unmapped_numA = 0;
            boolean atomA_is_unmapped = true;
            for (int a = 0; a < this.source.getAtomCount(); ++a) {
                for (int b = 0; b < newMapingSize; ++b) {
                    if (a != new_Mapping.get(b * 2 + 0)) continue;
                    atomA_is_unmapped = false;
                }
                if (atomA_is_unmapped) {
                    unmapped_atoms_molA.add(unmapped_numA++, a);
                }
                atomA_is_unmapped = true;
            }
            int counter = 0;
            int newSetBondNumA = 0;
            int newNeighborNumA = 0;
            QueryProcessor queryProcess = new QueryProcessor(c_setA_copy, c_setB_copy, SIGNS, newNeighborNumA, newSetBondNumA, new_i_neighborsA, new_c_neighborsA, newMapingSize, new_i_bond_setA, new_c_bond_setA);
            queryProcess.process(setNumA, setNumB, i_bond_setA, i_bond_setB, unmapped_atoms_molA, new_Mapping, counter);
            c_setA_copy = queryProcess.getCTab1();
            c_setB_copy = queryProcess.getCTab2();
            newSetBondNumA = queryProcess.getBondNumA();
            newNeighborNumA = queryProcess.getNeighborBondNumA();
            new_i_neighborsA = queryProcess.getIBondNeighboursA();
            new_c_neighborsA = queryProcess.getCBondNeighborsA();
            ArrayList<Integer> unmapped_atoms_molB = new ArrayList<Integer>();
            int unmapped_numB = 0;
            boolean atomB_is_unmapped = true;
            for (int a = 0; a < this.target.getAtomCount(); ++a) {
                for (int b = 0; b < newMapingSize; ++b) {
                    if (a != new_Mapping.get(b * 2 + 1)) continue;
                    atomB_is_unmapped = false;
                }
                if (atomB_is_unmapped) {
                    unmapped_atoms_molB.add(unmapped_numB++, a);
                }
                atomB_is_unmapped = true;
            }
            int newSetBondNumB = 0;
            int newNeighborNumB = 0;
            TargetProcessor targetProcess = new TargetProcessor(c_setA_copy, c_setB_copy, SIGNS, newNeighborNumB, newSetBondNumB, new_i_neighborsB, new_c_neighborsB, newNeighborNumA, new_i_neighborsA, new_c_neighborsA);
            targetProcess.process(setNumB, unmapped_atoms_molB, newMapingSize, i_bond_setB, c_bond_setB, new_Mapping, counter, new_i_bond_setB, new_c_bond_setB);
            c_setA_copy = targetProcess.getCTab1();
            c_setB_copy = targetProcess.getCTab2();
            newSetBondNumB = targetProcess.getBondNumB();
            newNeighborNumB = targetProcess.getNeighborBondNumB();
            new_i_neighborsB = targetProcess.getIBondNeighboursB();
            new_c_neighborsB = targetProcess.getCBondNeighborsB();
            McgregorHelper newMH = new McgregorHelper(no_further_MAPPINGS, newMapingSize, new_Mapping, newNeighborNumA, newNeighborNumB, new_i_neighborsA, new_i_neighborsB, new_c_neighborsA, new_c_neighborsB, newSetBondNumA, newSetBondNumB, new_i_bond_setA, new_i_bond_setB, new_c_bond_setA, new_c_bond_setB);
            this.iterator(newMH);
            BESTARCS_copy.pop();
        }
    }

    private List<Integer> findMcGregorMapping(List<Integer> MARCS, McgregorHelper mcGregorHelper) {
        int neighborBondNumA = mcGregorHelper.getNeighborBondNumA();
        int neighborBondNumB = mcGregorHelper.getNeighborBondNumB();
        ArrayList<Integer> currentMapping = new ArrayList<Integer>(mcGregorHelper.getMappedAtomsOrg());
        ArrayList<Integer> additional_mapping = new ArrayList<Integer>();
        for (int x = 0; x < neighborBondNumA; ++x) {
            for (int y = 0; y < neighborBondNumB; ++y) {
                if (MARCS.get(x * neighborBondNumB + y) != 1) continue;
                this.extendMapping(x, y, mcGregorHelper, additional_mapping, currentMapping);
            }
        }
        int additionalMappingSize = additional_mapping.size();
        for (int a = 0; a < additionalMappingSize; a += 2) {
            currentMapping.add((Integer)additional_mapping.get(a + 0));
            currentMapping.add((Integer)additional_mapping.get(a + 1));
        }
        List<Integer> unique_MAPPING = McGregorChecks.removeRecurringMappings(currentMapping);
        return unique_MAPPING;
    }

    private void setModifedArcs(McgregorHelper mcGregorHelper) {
        int neighborBondNumA = mcGregorHelper.getNeighborBondNumA();
        int neighborBondNumB = mcGregorHelper.getNeighborBondNumB();
        List<Integer> iBondNeighborAtomsA = mcGregorHelper.getiBondNeighborAtomsA();
        List<Integer> iBondNeighborAtomsB = mcGregorHelper.getiBondNeighborAtomsB();
        List<String> cBondNeighborsA = mcGregorHelper.getcBondNeighborsA();
        List<String> cBondNeighborsB = mcGregorHelper.getcBondNeighborsB();
        for (int row = 0; row < neighborBondNumA; ++row) {
            for (int column = 0; column < neighborBondNumB; ++column) {
                IAtom P2_B;
                String G2B;
                String G1B;
                String G2A;
                String G1A = cBondNeighborsA.get(row * 4 + 0);
                if (!this.matchGAtoms(G1A, G2A = cBondNeighborsA.get(row * 4 + 1), G1B = cBondNeighborsB.get(column * 4 + 0), G2B = cBondNeighborsB.get(column * 4 + 1))) continue;
                int Index_I = iBondNeighborAtomsA.get(row * 3 + 0);
                int Index_IPlus1 = iBondNeighborAtomsA.get(row * 3 + 1);
                IAtom R1_A = this.source.getAtom(Index_I);
                IAtom R2_A = this.source.getAtom(Index_IPlus1);
                IBond reactantBond = this.source.getBond(R1_A, R2_A);
                int Index_J = iBondNeighborAtomsB.get(column * 3 + 0);
                int Index_JPlus1 = iBondNeighborAtomsB.get(column * 3 + 1);
                IAtom P1_B = this.target.getAtom(Index_J);
                IBond productBond = this.target.getBond(P1_B, P2_B = this.target.getAtom(Index_JPlus1));
                if (!McGregorChecks.isMatchFeasible(this.source, reactantBond, this.target, productBond, this.isBondMatch())) continue;
                this.modifiedARCS.set(row * neighborBondNumB + column, 1);
            }
        }
    }

    private void partsearch(int xstart, int ystart, List<Integer> TEMPMARCS_ORG, McgregorHelper mcGregorHelper) {
        int neighborBondNumA = mcGregorHelper.getNeighborBondNumA();
        int neighborBondNumB = mcGregorHelper.getNeighborBondNumB();
        int xIndex = xstart;
        int yIndex = ystart;
        ArrayList<Integer> TEMPMARCS = new ArrayList<Integer>(TEMPMARCS_ORG);
        if ((Integer)TEMPMARCS.get(xstart * neighborBondNumB + ystart) == 1) {
            McGregorChecks.removeRedundantArcs(xstart, ystart, TEMPMARCS, mcGregorHelper);
            int arcsleft = McGregorChecks.countArcsLeft(TEMPMARCS, neighborBondNumA, neighborBondNumB);
            if (arcsleft >= this.bestarcsleft) {
                this.setArcs(xIndex, yIndex, arcsleft, TEMPMARCS, mcGregorHelper);
            }
        } else {
            do {
                if (++yIndex != neighborBondNumB) continue;
                yIndex = 0;
                ++xIndex;
            } while (xIndex < neighborBondNumA && (Integer)TEMPMARCS.get(xIndex * neighborBondNumB + yIndex) != 1);
            if (xIndex < neighborBondNumA) {
                this.partsearch(xIndex, yIndex, TEMPMARCS, mcGregorHelper);
                TEMPMARCS.set(xIndex * neighborBondNumB + yIndex, 0);
                this.partsearch(xIndex, yIndex, TEMPMARCS, mcGregorHelper);
            } else {
                int arcsleft = McGregorChecks.countArcsLeft(TEMPMARCS, neighborBondNumA, neighborBondNumB);
                if (arcsleft >= this.bestarcsleft) {
                    this.popBestArcs(arcsleft);
                    if (this.checkMARCS(TEMPMARCS, neighborBondNumA, neighborBondNumB)) {
                        this.bestARCS.push(TEMPMARCS);
                    }
                }
            }
        }
    }

    private boolean checkMARCS(List<Integer> MARCS_T, int neighborBondNumA, int neighborBondNumB) {
        int size = neighborBondNumA * neighborBondNumA;
        ArrayList<Integer> posnum_list = new ArrayList<Integer>(size);
        for (int i = 0; i < posnum_list.size(); ++i) {
            posnum_list.add(i, 0);
        }
        int yCounter = 0;
        int count_entries = 0;
        for (int x = 0; x < neighborBondNumA * neighborBondNumB; ++x) {
            if (MARCS_T.get(x) != 1) continue;
            posnum_list.add(yCounter++, x);
            ++count_entries;
        }
        boolean flag = false;
        this.verifyNodes(posnum_list, this.first, 0, count_entries);
        if (this.isNewMatrix()) {
            flag = true;
        }
        return flag;
    }

    private boolean verifyNodes(List<Integer> matrix, BinaryTree currentStructure, int index, int fieldLength) {
        if (index < fieldLength) {
            if (matrix.get(index).intValue() == currentStructure.getValue() && currentStructure.getEqual() != null) {
                this.setNewMatrix(false);
                this.verifyNodes(matrix, currentStructure.getEqual(), index + 1, fieldLength);
            }
            if (matrix.get(index).intValue() != currentStructure.getValue()) {
                if (currentStructure.getNotEqual() != null) {
                    this.verifyNodes(matrix, currentStructure.getNotEqual(), index, fieldLength);
                }
                if (currentStructure.getNotEqual() == null) {
                    currentStructure.setNotEqual(new BinaryTree(matrix.get(index)));
                    currentStructure.getNotEqual().setNotEqual(null);
                    int yIndex = 0;
                    BinaryTree last_one = currentStructure.getNotEqual();
                    while (yIndex + index + 1 < fieldLength) {
                        last_one.setEqual(new BinaryTree(matrix.get(yIndex + index + 1)));
                        last_one = last_one.getEqual();
                        last_one.setNotEqual(null);
                        ++yIndex;
                    }
                    last_one.setEqual(null);
                    this.setNewMatrix(true);
                }
            }
        }
        return true;
    }

    private void startsearch(McgregorHelper mcGregorHelper) {
        int neighborBondNumA = mcGregorHelper.getNeighborBondNumA();
        int neighborBondNumB = mcGregorHelper.getNeighborBondNumB();
        int size = neighborBondNumA * neighborBondNumB;
        ArrayList<Integer> FIXARCS = new ArrayList<Integer>(size);
        for (int i = 0; i < size; ++i) {
            FIXARCS.add(i, 0);
        }
        int xIndex = 0;
        int yIndex = 0;
        while (xIndex < neighborBondNumA && this.modifiedARCS.get(xIndex * neighborBondNumB + yIndex) != 1) {
            if (++yIndex != neighborBondNumB) continue;
            yIndex = 0;
            ++xIndex;
        }
        if (xIndex == neighborBondNumA) {
            yIndex = neighborBondNumB - 1;
            --xIndex;
        }
        if (this.modifiedARCS.get(xIndex * neighborBondNumB + yIndex) == 0) {
            this.partsearch(xIndex, yIndex, this.modifiedARCS, mcGregorHelper);
        }
        if (this.modifiedARCS.get(xIndex * neighborBondNumB + yIndex) != 0) {
            this.partsearch(xIndex, yIndex, this.modifiedARCS, mcGregorHelper);
            this.modifiedARCS.set(xIndex * neighborBondNumB + yIndex, 0);
            this.partsearch(xIndex, yIndex, this.modifiedARCS, mcGregorHelper);
        }
    }

    public List<List<Integer>> getMappings() {
        return this.mappings;
    }

    public int getMCSSize() {
        return this.globalMCSSize;
    }

    private void setFinalMappings(List<Integer> mapped_atoms, int mappedAtomCount) {
        try {
            if (mappedAtomCount >= this.globalMCSSize) {
                if (mappedAtomCount > this.globalMCSSize) {
                    this.globalMCSSize = mappedAtomCount;
                    this.mappings.clear();
                }
                this.mappings.add(mapped_atoms);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void setArcs(int xIndex, int yIndex, int arcsleft, List<Integer> TEMPMARCS, McgregorHelper mcGregorHelper) {
        int neighborBondNumA = mcGregorHelper.getNeighborBondNumA();
        int neighborBondNumB = mcGregorHelper.getNeighborBondNumB();
        do {
            if (++yIndex != neighborBondNumB) continue;
            yIndex = 0;
            ++xIndex;
        } while (xIndex < neighborBondNumA && TEMPMARCS.get(xIndex * neighborBondNumB + yIndex) != 1);
        if (xIndex < neighborBondNumA) {
            this.partsearch(xIndex, yIndex, TEMPMARCS, mcGregorHelper);
            TEMPMARCS.set(xIndex * neighborBondNumB + yIndex, 0);
            this.partsearch(xIndex, yIndex, TEMPMARCS, mcGregorHelper);
        } else {
            this.popBestArcs(arcsleft);
            if (this.checkMARCS(TEMPMARCS, neighborBondNumA, neighborBondNumB)) {
                this.bestARCS.push(TEMPMARCS);
            }
        }
    }

    private void popBestArcs(int arcsleft) {
        if (arcsleft > this.bestarcsleft) {
            McGregorChecks.removeTreeStructure(this.first);
            this.first = this.last = new BinaryTree(-1);
            this.last.setEqual(null);
            this.last.setNotEqual(null);
            while (!this.bestARCS.empty()) {
                this.bestARCS.pop();
            }
        }
        this.bestarcsleft = arcsleft;
    }

    private void extendMapping(int xIndex, int yIndex, McgregorHelper mcGregorHelper, List<Integer> additional_mapping, List<Integer> currentMapping) {
        IAtom P2_B;
        IAtom P1_B;
        IBond productBond;
        IAtom R2_A;
        int Atom1_moleculeA = mcGregorHelper.getiBondNeighborAtomsA().get(xIndex * 3 + 0);
        int Atom2_moleculeA = mcGregorHelper.getiBondNeighborAtomsA().get(xIndex * 3 + 1);
        int Atom1_moleculeB = mcGregorHelper.getiBondNeighborAtomsB().get(yIndex * 3 + 0);
        int Atom2_moleculeB = mcGregorHelper.getiBondNeighborAtomsB().get(yIndex * 3 + 1);
        IAtom R1_A = this.source.getAtom(Atom1_moleculeA);
        IBond reactantBond = this.source.getBond(R1_A, R2_A = this.source.getAtom(Atom2_moleculeA));
        if (McGregorChecks.isMatchFeasible(this.source, reactantBond, this.target, productBond = this.target.getBond(P1_B = this.target.getAtom(Atom1_moleculeB), P2_B = this.target.getAtom(Atom2_moleculeB)), this.isBondMatch())) {
            for (int indexZ = 0; indexZ < mcGregorHelper.getMappedAtomCount(); ++indexZ) {
                int Mapped_Atom_1 = currentMapping.get(indexZ * 2 + 0);
                int Mapped_Atom_2 = currentMapping.get(indexZ * 2 + 1);
                if (Mapped_Atom_1 == Atom1_moleculeA && Mapped_Atom_2 == Atom1_moleculeB) {
                    additional_mapping.add(Atom2_moleculeA);
                    additional_mapping.add(Atom2_moleculeB);
                    continue;
                }
                if (Mapped_Atom_1 == Atom1_moleculeA && Mapped_Atom_2 == Atom2_moleculeB) {
                    additional_mapping.add(Atom2_moleculeA);
                    additional_mapping.add(Atom1_moleculeB);
                    continue;
                }
                if (Mapped_Atom_1 == Atom2_moleculeA && Mapped_Atom_2 == Atom1_moleculeB) {
                    additional_mapping.add(Atom1_moleculeA);
                    additional_mapping.add(Atom2_moleculeB);
                    continue;
                }
                if (Mapped_Atom_1 != Atom2_moleculeA || Mapped_Atom_2 != Atom2_moleculeB) continue;
                additional_mapping.add(Atom1_moleculeA);
                additional_mapping.add(Atom1_moleculeB);
            }
        }
    }

    private boolean matchGAtoms(String G1A, String G2A, String G1B, String G2B) {
        return G1A.compareToIgnoreCase(G1B) == 0 && G2A.compareToIgnoreCase(G2B) == 0 || G1A.compareToIgnoreCase(G2B) == 0 && G2A.compareToIgnoreCase(G1B) == 0;
    }

    public boolean isNewMatrix() {
        return this.newMatrix;
    }

    public void setNewMatrix(boolean newMatrix) {
        this.newMatrix = newMatrix;
    }

    private boolean isBondMatch() {
        return this.bondMatch;
    }

    private void setBondMatch(boolean bondMatch) {
        this.bondMatch = bondMatch;
    }
}

