/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IBond;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IPseudoAtom;
import org.openscience.cdk.io.DefaultChemObjectReader;
import org.openscience.cdk.io.IChemObjectReader;
import org.openscience.cdk.io.MDLV2000Reader;
import org.openscience.cdk.io.formats.IResourceFormat;
import org.openscience.cdk.io.formats.RGroupQueryFormat;
import org.openscience.cdk.isomorphism.matchers.IRGroupQuery;
import org.openscience.cdk.isomorphism.matchers.RGroup;
import org.openscience.cdk.isomorphism.matchers.RGroupList;
import org.openscience.cdk.isomorphism.matchers.RGroupQuery;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@TestClass(value="org.openscience.cdk.io.RGroupQueryReaderTest")
public class RGroupQueryReader
extends DefaultChemObjectReader {
    BufferedReader input = null;
    private static ILoggingTool logger = LoggingToolFactory.createLoggingTool(RGroupQueryReader.class);

    public RGroupQueryReader() {
        this(new StringReader(""));
    }

    public RGroupQueryReader(InputStream in) {
        this(new InputStreamReader(in));
    }

    public RGroupQueryReader(Reader in) {
        this.input = new BufferedReader(in);
    }

    @Override
    @TestMethod(value="testSetReader_Reader")
    public void setReader(Reader input) throws CDKException {
        this.input = input instanceof BufferedReader ? (BufferedReader)input : new BufferedReader(input);
    }

    @Override
    @TestMethod(value="testSetReader_InputStream")
    public void setReader(InputStream input) throws CDKException {
        this.setReader(new InputStreamReader(input));
    }

    @Override
    @TestMethod(value="testGetFormat")
    public IResourceFormat getFormat() {
        return RGroupQueryFormat.getInstance();
    }

    @TestMethod(value="testAccepts")
    public boolean accepts(Class classObject) {
        Class<?>[] interfaces;
        for (Class<?> anInterface : interfaces = classObject.getInterfaces()) {
            if (!IRGroupQuery.class.equals(anInterface)) continue;
            return true;
        }
        Class superClass = classObject.getSuperclass();
        if (superClass != null) {
            return this.accepts(superClass);
        }
        return false;
    }

    @Override
    @TestMethod(value="testClose")
    public void close() throws IOException {
        this.input.close();
    }

    @Override
    public <T extends IChemObject> T read(T object) throws CDKException {
        if (object instanceof RGroupQuery) {
            return (T)this.parseRGFile((RGroupQuery)object);
        }
        throw new CDKException("Reader only supports " + RGroupQuery.class.getName() + " objects");
    }

    private RGroupQuery parseRGFile(RGroupQuery rGroupQuery) throws CDKException {
        IChemObjectBuilder defaultChemObjectBuilder = rGroupQuery.getBuilder();
        String line = "";
        int lineCount = 0;
        String eol = System.getProperty("line.separator");
        StringTokenizer strTk = null;
        HashMap<Integer, RGroupLogic> logicDefinitions = new HashMap<Integer, RGroupLogic>();
        HashMap<IAtom, Map<Integer, IBond>> attachmentPoints = new HashMap<IAtom, Map<Integer, IBond>>();
        try {
            IAtom rGroup;
            logger.info("Process the Header block");
            this.checkLineBeginsWith(this.input.readLine(), "$MDL", ++lineCount);
            this.checkLineBeginsWith(this.input.readLine(), "$MOL", ++lineCount);
            this.checkLineBeginsWith(this.input.readLine(), "$HDR", ++lineCount);
            for (int i = 1; i <= 3; ++i) {
                ++lineCount;
                if (this.input.readLine() != null) continue;
                throw new CDKException("RGFile invalid, empty/null header line at #" + lineCount);
            }
            this.checkLineBeginsWith(this.input.readLine(), "$END HDR", ++lineCount);
            logger.info("Process the root structure (scaffold)");
            this.checkLineBeginsWith(this.input.readLine(), "$CTAB", ++lineCount);
            StringBuilder sb = new StringBuilder("Root structure\n\n\n");
            line = this.input.readLine();
            ++lineCount;
            while (line != null && !line.equals("$END CTAB")) {
                sb.append(line + eol);
                if (line.startsWith("M  LOG")) {
                    strTk = new StringTokenizer(line);
                    strTk.nextToken();
                    strTk.nextToken();
                    strTk.nextToken();
                    RGroupLogic log = null;
                    log = new RGroupLogic();
                    int rgroupNumber = new Integer(strTk.nextToken());
                    String tok = strTk.nextToken();
                    log.rgoupNumberRequired = tok.equals("0") ? 0 : new Integer(tok);
                    log.restH = strTk.nextToken().equals("1");
                    tok = "";
                    while (strTk.hasMoreTokens()) {
                        tok = tok + strTk.nextToken();
                    }
                    log.occurence = tok;
                    logicDefinitions.put(rgroupNumber, log);
                }
                line = this.input.readLine();
                ++lineCount;
            }
            String rootStr = sb.toString();
            MDLV2000Reader reader = new MDLV2000Reader(new StringReader(rootStr), IChemObjectReader.Mode.STRICT);
            IMolecule root = (IMolecule)reader.read((IChemObject)defaultChemObjectBuilder.newInstance(IMolecule.class, new Object[0]));
            rGroupQuery.setRootStructure(root);
            List<IAtom> atomsByLinePosition = reader.getAtomsByLinePosition();
            strTk = new StringTokenizer(rootStr, eol);
            while (strTk.hasMoreTokens()) {
                line = strTk.nextToken();
                if (!line.startsWith("M  AAL")) continue;
                StringTokenizer stAAL = new StringTokenizer(line);
                stAAL.nextToken();
                stAAL.nextToken();
                int pos = new Integer(stAAL.nextToken());
                rGroup = atomsByLinePosition.get(pos);
                stAAL.nextToken();
                HashMap<Integer, IBond> bondMap = new HashMap<Integer, IBond>();
                while (stAAL.hasMoreTokens()) {
                    pos = new Integer(stAAL.nextToken());
                    IAtom partner = atomsByLinePosition.get(pos);
                    IBond bond = root.getBond(rGroup, partner);
                    int order = new Integer(stAAL.nextToken());
                    bondMap.put(order, bond);
                    logger.info("AAL " + order + " " + rGroup.getLabel() + "-" + partner.getSymbol());
                }
                if (bondMap.size() == 0) continue;
                attachmentPoints.put(rGroup, bondMap);
            }
            for (IAtom atom : root.atoms()) {
                if (!(atom instanceof IPseudoAtom) || !(rGroup = (IPseudoAtom)atom).getLabel().startsWith("R") || rGroup.getLabel().equals("R") || attachmentPoints.containsKey(rGroup)) continue;
                int order = 0;
                HashMap<Integer, IBond> bondMap = new HashMap<Integer, IBond>();
                block14: for (IAtom atom2 : atomsByLinePosition) {
                    if (atom.equals(atom2)) continue;
                    for (IBond bond : root.bonds()) {
                        if (!bond.contains(atom) || !bond.contains(atom2)) continue;
                        bondMap.put(++order, bond);
                        logger.info("Def " + order + " " + rGroup.getLabel() + "-" + atom2.getSymbol());
                        continue block14;
                    }
                }
                if (bondMap.size() == 0) continue;
                attachmentPoints.put(rGroup, bondMap);
            }
            rGroupQuery.setRootAttachmentPoints(attachmentPoints);
            logger.info("Attachm.points defined for " + attachmentPoints.size() + " R# atoms");
            HashMap<Integer, RGroupList> rGroupDefinitions = new HashMap<Integer, RGroupList>();
            for (IAtom atom : root.atoms()) {
                IPseudoAtom rGroup2;
                if (!(atom instanceof IPseudoAtom) || !RGroupQuery.isValidRgroupQueryLabel((rGroup2 = (IPseudoAtom)atom).getLabel())) continue;
                int rgroupNum = new Integer(rGroup2.getLabel().substring(1));
                RGroupList rgroupList = new RGroupList(rgroupNum);
                if (rGroupDefinitions.containsKey(rgroupNum)) continue;
                logger.info("Define Rgroup R" + rgroupNum);
                RGroupLogic logic = (RGroupLogic)logicDefinitions.get(rgroupNum);
                if (logic != null) {
                    rgroupList.setRestH(logic.restH);
                    rgroupList.setOccurrence(logic.occurence);
                    rgroupList.setRequiredRGroupNumber(logic.rgoupNumberRequired);
                } else {
                    rgroupList.setRestH(false);
                    rgroupList.setOccurrence(">0");
                    rgroupList.setRequiredRGroupNumber(0);
                }
                rgroupList.setRGroups(new ArrayList<RGroup>());
                rGroupDefinitions.put(rgroupNum, rgroupList);
            }
            line = this.input.readLine();
            ++lineCount;
            boolean hasMoreRGP = true;
            while (hasMoreRGP) {
                this.checkLineBeginsWith(line, "$RGP", lineCount);
                line = this.input.readLine();
                ++lineCount;
                logger.info("line for num is " + line);
                int rgroupNum = new Integer(line.trim());
                line = this.input.readLine();
                ++lineCount;
                boolean hasMoreCTAB = true;
                while (hasMoreCTAB) {
                    this.checkLineBeginsWith(line, "$CTAB", lineCount);
                    sb = new StringBuilder(RGroup.makeLabel(rgroupNum) + "\n\n\n");
                    line = this.input.readLine();
                    while (line != null && !line.startsWith("$END CTAB")) {
                        sb.append(line + eol);
                        line = this.input.readLine();
                        ++lineCount;
                    }
                    String groupStr = sb.toString();
                    reader = new MDLV2000Reader(new StringReader(groupStr), IChemObjectReader.Mode.STRICT);
                    IMolecule group = (IMolecule)reader.read((IChemObject)defaultChemObjectBuilder.newInstance(IMolecule.class, new Object[0]));
                    atomsByLinePosition = reader.getAtomsByLinePosition();
                    RGroup rGroup3 = new RGroup();
                    rGroup3.setGroup(group);
                    strTk = new StringTokenizer(groupStr, eol);
                    while (strTk.hasMoreTokens()) {
                        line = strTk.nextToken();
                        if (!line.startsWith("M  APO")) continue;
                        StringTokenizer stAPO = new StringTokenizer(line);
                        stAPO.nextToken();
                        stAPO.nextToken();
                        stAPO.nextToken();
                        while (stAPO.hasMoreTokens()) {
                            int pos = new Integer(stAPO.nextToken());
                            int apo = new Integer(stAPO.nextToken());
                            IAtom at = atomsByLinePosition.get(pos);
                            switch (apo) {
                                case 1: {
                                    rGroup3.setFirstAttachmentPoint(at);
                                    break;
                                }
                                case 2: {
                                    rGroup3.setSecondAttachmentPoint(at);
                                    break;
                                }
                                case 3: {
                                    rGroup3.setFirstAttachmentPoint(at);
                                    rGroup3.setSecondAttachmentPoint(at);
                                }
                            }
                        }
                    }
                    RGroupList rList = (RGroupList)rGroupDefinitions.get(rgroupNum);
                    if (rList == null) {
                        throw new CDKException("R" + rgroupNum + " not defined but referenced in $RGP.");
                    }
                    rList.getRGroups().add(rGroup3);
                    line = this.input.readLine();
                    ++lineCount;
                    if (!line.startsWith("$END RGP")) continue;
                    logger.info("end of RGP block");
                    hasMoreCTAB = false;
                }
                line = this.input.readLine();
                ++lineCount;
                if (!line.startsWith("$END MOL")) continue;
                hasMoreRGP = false;
            }
            rGroupQuery.setRGroupDefinitions(rGroupDefinitions);
            logger.info("Number of lines was " + lineCount);
            return rGroupQuery;
        }
        catch (CDKException exception) {
            String error = "CDK Error while parsing line " + lineCount + ": " + line + " -> " + exception.getMessage();
            logger.error(error);
            logger.debug(exception);
            throw exception;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String error = exception.getClass() + "Error while parsing line " + lineCount + ": " + line + " -> " + exception.getMessage();
            logger.error(error);
            logger.debug(exception);
            throw new CDKException(error, exception);
        }
    }

    private void checkLineBeginsWith(String line, String expect, int lineCount) throws CDKException {
        if (line == null) {
            throw new CDKException("RGFile invalid, empty/null line at #" + lineCount);
        }
        if (!line.startsWith(expect)) {
            throw new CDKException("RGFile invalid, line #" + lineCount + " should start with:" + expect + ".");
        }
    }

    private class RGroupLogic {
        int rgoupNumberRequired;
        boolean restH;
        String occurence;

        private RGroupLogic() {
        }
    }
}

