/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.renderer.generators;

import java.io.IOException;
import org.openscience.cdk.config.IsotopeFactory;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObjectBuilder;
import org.openscience.cdk.renderer.RendererModel;
import org.openscience.cdk.renderer.elements.AtomMassSymbolElement;
import org.openscience.cdk.renderer.elements.IRenderingElement;
import org.openscience.cdk.renderer.generators.BasicAtomGenerator;
import org.openscience.cdk.tools.ILoggingTool;
import org.openscience.cdk.tools.LoggingToolFactory;

public class AtomMassGenerator
extends BasicAtomGenerator {
    private ILoggingTool logger = LoggingToolFactory.createLoggingTool(AtomMassGenerator.class);

    @Override
    public IRenderingElement generateElements(IAtom atom, int alignment, RendererModel model) {
        return new AtomMassSymbolElement(atom.getPoint2d().x, atom.getPoint2d().y, atom.getSymbol(), atom.getFormalCharge(), atom.getImplicitHydrogenCount(), alignment, atom.getMassNumber(), super.getAtomColor(atom));
    }

    @Override
    public boolean showCarbon(IAtom atom, IAtomContainer ac, RendererModel model) {
        Integer massNumber = atom.getMassNumber();
        if (massNumber != null) {
            try {
                Integer expectedMassNumber = IsotopeFactory.getInstance((IChemObjectBuilder)ac.getBuilder()).getMajorIsotope(atom.getSymbol()).getMassNumber();
                if (massNumber != expectedMassNumber) {
                    return true;
                }
            }
            catch (IOException e) {
                this.logger.warn((Object)e);
            }
        }
        return super.showCarbon(atom, ac, model);
    }
}

