/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.qsar.descriptors.molecular;

import java.util.List;
import org.openscience.cdk.AminoAcid;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.exception.CDKException;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IAtomContainerSet;
import org.openscience.cdk.isomorphism.UniversalIsomorphismTester;
import org.openscience.cdk.isomorphism.mcss.RMap;
import org.openscience.cdk.qsar.DescriptorSpecification;
import org.openscience.cdk.qsar.DescriptorValue;
import org.openscience.cdk.qsar.IMolecularDescriptor;
import org.openscience.cdk.qsar.result.IDescriptorResult;
import org.openscience.cdk.qsar.result.IntegerArrayResult;
import org.openscience.cdk.templates.AminoAcids;

@TestClass(value="org.openscience.cdk.qsar.descriptors.molecular.AminoAcidCountDescriptorTest")
public class AminoAcidCountDescriptor
implements IMolecularDescriptor {
    private IAtomContainerSet substructureSet;
    private static String[] names;

    public AminoAcidCountDescriptor() {
        AminoAcid[] aas = AminoAcids.createAAs();
        this.substructureSet = aas[0].getBuilder().newInstance(IAtomContainerSet.class, new Object[0]);
        for (AminoAcid aa : aas) {
            this.substructureSet.addAtomContainer(aa);
        }
        names = new String[this.substructureSet.getAtomContainerCount()];
        for (int i = 0; i < aas.length; ++i) {
            AminoAcidCountDescriptor.names[i] = "n" + aas[i].getProperty("residueNameShort");
        }
    }

    @Override
    @TestMethod(value="testGetSpecification")
    public DescriptorSpecification getSpecification() {
        return new DescriptorSpecification("http://www.blueobelisk.org/ontologies/chemoinformatics-algorithms/#aminoAcidsCount", this.getClass().getName(), "$Id$", "The Chemistry Development Kit");
    }

    @Override
    @TestMethod(value="testSetParameters_arrayObject")
    public void setParameters(Object[] params) throws CDKException {
    }

    @Override
    @TestMethod(value="testGetParameters")
    public Object[] getParameters() {
        return null;
    }

    @Override
    @TestMethod(value="testNamesConsistency")
    public String[] getDescriptorNames() {
        return names;
    }

    @Override
    @TestMethod(value="testCalculate_IAtomContainer")
    public DescriptorValue calculate(IAtomContainer ac) {
        int resultLength = this.substructureSet.getAtomContainerCount();
        IntegerArrayResult results = new IntegerArrayResult(resultLength);
        for (int i = 0; i < resultLength; ++i) {
            List<List<RMap>> maps;
            IAtomContainer substructure = this.substructureSet.getAtomContainer(i);
            try {
                maps = UniversalIsomorphismTester.getSubgraphMaps(ac, substructure);
            }
            catch (CDKException e) {
                for (int j = 0; j < resultLength; ++j) {
                    results.add(0);
                }
                return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), results, this.getDescriptorNames(), new CDKException("Error in substructure search: " + e.getMessage()));
            }
            if (maps == null) continue;
            results.add(maps.size());
        }
        return new DescriptorValue(this.getSpecification(), this.getParameterNames(), this.getParameters(), results, this.getDescriptorNames());
    }

    @Override
    @TestMethod(value="testGetDescriptorResultType")
    public IDescriptorResult getDescriptorResultType() {
        return new IntegerArrayResult(20);
    }

    @Override
    @TestMethod(value="testGetParameterNames")
    public String[] getParameterNames() {
        return new String[0];
    }

    @Override
    @TestMethod(value="testGetParameterType_String")
    public Object getParameterType(String name) {
        return null;
    }
}

