/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.cdk.smsd.tools;

import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.annotations.TestClass;
import org.openscience.cdk.annotations.TestMethod;
import org.openscience.cdk.aromaticity.CDKHueckelAromaticityDetector;
import org.openscience.cdk.graph.ConnectivityChecker;
import org.openscience.cdk.interfaces.IAtom;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.interfaces.IRing;
import org.openscience.cdk.interfaces.IRingSet;
import org.openscience.cdk.ringsearch.AllRingsFinder;
import org.openscience.cdk.smsd.tools.ExtAtomContainerManipulator;
import org.openscience.cdk.tools.CDKHydrogenAdder;
import org.openscience.cdk.tools.manipulator.RingSetManipulator;

@TestClass(value="org.openscience.cdk.smsd.tools.MoleculeSanityCheckTest")
public class MoleculeSanityCheck {
    @TestMethod(value="testCheckAndCleanMolecule")
    public static IAtomContainer checkAndCleanMolecule(IAtomContainer molecule) {
        boolean isMarkush = false;
        for (IAtom atom : molecule.atoms()) {
            if (!atom.getSymbol().equals("R")) continue;
            isMarkush = true;
            break;
        }
        if (isMarkush) {
            System.err.println("Skipping Markush structure for sanity check");
        }
        if (!ConnectivityChecker.isConnected(molecule)) {
            IMoleculeSet fragments = ConnectivityChecker.partitionIntoMolecules(molecule);
            if (fragments.getMoleculeCount() > 2) {
                System.err.println("More than 2 components. Skipped");
            } else {
                IMolecule frag1 = fragments.getMolecule(0);
                IMolecule frag2 = fragments.getMolecule(1);
                molecule = frag1.getAtomCount() > frag2.getAtomCount() ? frag1 : frag2;
            }
        }
        MoleculeSanityCheck.configure(molecule);
        return molecule;
    }

    @TestMethod(value="testFixAromaticity")
    public static void configure(IAtomContainer mol) {
        IRingSet ringSet = null;
        try {
            AllRingsFinder arf = new AllRingsFinder();
            ringSet = arf.findAllRings(mol);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            CDKHydrogenAdder cdk = CDKHydrogenAdder.getInstance(DefaultChemObjectBuilder.getInstance());
            cdk.addImplicitHydrogens(mol);
            ExtAtomContainerManipulator.percieveAtomTypesAndConfigureAtoms(mol);
            CDKHueckelAromaticityDetector.detectAromaticity(mol);
            RingSetManipulator.markAromaticRings(ringSet);
            for (int i = 0; i < mol.getAtomCount(); ++i) {
                mol.getAtom(i).setFlag(5, false);
                for (int j = 0; j < ringSet.getAtomContainerCount(); ++j) {
                    boolean haveatom;
                    IRing ring = (IRing)ringSet.getAtomContainer(j);
                    if (!ring.getFlag(5) || !(haveatom = ring.contains(mol.getAtom(i))) || ring.getAtomCount() != 6) continue;
                    mol.getAtom(i).setFlag(5, true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

