/*
 * Decompiled with CFR 0.152.
 */
package org.guha.rcdk.view.panels;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.openscience.cdk.DefaultChemObjectBuilder;
import org.openscience.cdk.controller.ControllerHub;
import org.openscience.cdk.controller.ControllerModel;
import org.openscience.cdk.controller.IControllerModel;
import org.openscience.cdk.controller.IViewEventRelay;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemModel;
import org.openscience.cdk.interfaces.IMolecule;
import org.openscience.cdk.interfaces.IMoleculeSet;
import org.openscience.cdk.renderer.IJava2DRenderer;
import org.openscience.cdk.renderer.IntermediateRenderer;

public class Render2DPanel
extends JPanel
implements IViewEventRelay {
    private IntermediateRenderer renderer;
    private boolean isNewChemModel;
    private ControllerHub hub;
    private ControllerModel controllerModel;
    private boolean shouldPaintFromCache;
    IMolecule molecule;
    boolean fitToScreen = true;

    public Render2DPanel() {
    }

    public Render2DPanel(IAtomContainer mol, int x, int y) {
        this(mol, null, x, y, false);
    }

    public Render2DPanel(IAtomContainer mol, IAtomContainer needle, int x, int y, boolean withHydrogen) {
        this.molecule = (IMolecule)mol;
        this.setPreferredSize(new Dimension(x, y));
        this.setBackground(Color.WHITE);
        IMoleculeSet moleculeSet = DefaultChemObjectBuilder.getInstance().newMoleculeSet();
        moleculeSet.addMolecule(this.molecule);
        IChemModel chemModel = DefaultChemObjectBuilder.getInstance().newChemModel();
        chemModel.setMoleculeSet(moleculeSet);
        this.renderer = new IntermediateRenderer();
        this.renderer.setFitToScreen(true);
        this.controllerModel = new ControllerModel();
        this.hub = new ControllerHub((IControllerModel)this.controllerModel, (IJava2DRenderer)this.renderer, chemModel, (IViewEventRelay)this);
        this.hub.getIJava2DRenderer().getRenderer2DModel().setShowAromaticity(true);
        this.hub.getIJava2DRenderer().getRenderer2DModel().setUseAntiAliasing(true);
        this.hub.getIJava2DRenderer().getRenderer2DModel().setIsCompact(false);
        this.isNewChemModel = true;
    }

    public Image takeSnapshot() {
        return this.takeSnapshot(this.getBounds());
    }

    public Image takeSnapshot(Rectangle bounds) {
        BufferedImage image = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[0].getDefaultConfiguration().createCompatibleImage(bounds.width, bounds.height);
        Graphics2D g = (Graphics2D)((Image)image).getGraphics();
        super.paint(g);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.paintChemModel(g, bounds);
        return image;
    }

    public void paintChemModel(Graphics2D g, Rectangle screenBounds) {
        IChemModel chemModel = this.hub.getIChemModel();
        if (chemModel != null && chemModel.getMoleculeSet() != null) {
            Rectangle diagramBounds = this.renderer.calculateScreenBounds(chemModel);
            if (this.overlaps(screenBounds, diagramBounds)) {
                Rectangle union = screenBounds.union(diagramBounds);
                this.setPreferredSize(union.getSize());
                this.revalidate();
            }
            this.paintChemModel(chemModel, g, screenBounds);
        }
    }

    private boolean overlaps(Rectangle screenBounds, Rectangle diagramBounds) {
        return screenBounds.getMinX() > diagramBounds.getMinX() || screenBounds.getMinY() > diagramBounds.getMinY() || screenBounds.getMaxX() < diagramBounds.getMaxX() || screenBounds.getMaxY() < diagramBounds.getMaxY();
    }

    private void paintChemModel(IChemModel chemModel, Graphics2D g, Rectangle bounds) {
        this.renderer.paintChemModel(chemModel, g, (Rectangle2D)bounds, this.isNewChemModel);
        this.isNewChemModel = false;
        this.shouldPaintFromCache = false;
    }

    public void setIsNewChemModel(boolean isNewChemModel) {
        this.isNewChemModel = isNewChemModel;
    }

    public void paint(Graphics g) {
        assert (this.molecule != null);
        this.setBackground(this.renderer.getRenderer2DModel().getBackColor());
        super.paint(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.shouldPaintFromCache) {
            this.paintFromCache(g2);
        } else {
            this.paintChemModel(g2, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
        }
    }

    private void paintFromCache(Graphics2D g) {
        this.renderer.repaint(g);
    }

    public void updateView() {
        this.shouldPaintFromCache = false;
        this.repaint();
    }

    public void setFitToScreen(boolean fitToScreen) {
        this.renderer.setFitToScreen(fitToScreen);
    }
}

