\name{view.table}
\alias{view.table}
\title{
  View 2D Structures With Data
}
\description{
  The CDK is capable of generating 2D structure diagrams. This function
  can be used to view a set of molecules along with some associated
  data. The format of the output is a table, where the first column are
  the 2D images of the molecules, followed by the data columns.
}
\usage{
view.table(molecules, dat, cellx = 200, celly = 200)
}
\arguments{
  \item{molecules}{A list of \code{jobRef} objects that represent
    \code{IAtomContainer}}
  \item{dat}{A data.frame containing numeric or character columns. If
    columns are named they will be used in the data table. If not, names
    are autogenerated. The number of rows of the data.frame should be
    equal to the number of molecules}
  \item{cellx}{Initial width of the table cells}
  \item{celly}{Initial height of the table cells}
}
\value{
  Nothing
}
\details{
  Due to event handling issues, the depiction will show on OS X, but
  the window will be unresponsive. The depictions will work fine on
  Linux and Windows.
}
\examples{
sp <- get.smiles.parser()
smiles <- c('CCC', 'CCN', 'CCN(C)(C)',
            'c1ccccc1Cc1ccccc1',
            'C1CCC1CC(CN(C)(C))CC(=O)CC')
mols <- sapply(smiles, parse.smiles, parser=sp)
dframe <- data.frame(x = runif(4),
                     toxicity = factor(c('Toxic', 'Toxic', 'Nontoxic', 'Nontoxic')),
                     solubility = c('yes', 'yes', 'no', 'yes'))
\dontrun{view.table(mols[1:4], dframe)}
}

\seealso{
  \code{\link{view.molecule.2d}}
}
\keyword{programming}

\author{Rajarshi Guha (\email{rajarshi.guha@gmail.com})}
