/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import javax.vecmath.Point3i;

class Translation {
    char translationCode = '\u0000';
    int rotationOrder;
    int rotationShift12ths;
    Point3i vectorShift12ths = new Point3i();
    static final String[] latticeTranslationData = new String[]{"\u0000", "unknown", "", "P", "primitive", "", "I", "body-centered", " 1n", "R", "rhombohedral", " 1r 1r", "F", "face-centered", " 1ab 1bc 1ac", "A", "A-centered", " 1bc", "B", "B-centered", " 1ac", "C", "C-centered", " 1ab", "S", "rhombohedral(S)", " 1s 1s", "T", "rhombohedral(T)", " 1t 1t"};
    static final int nLatticeTypes = latticeTranslationData.length / 3 - 1;
    static final Translation[] hallTranslationTerms = new Translation[]{new Translation('a', 0, new Point3i(6, 0, 0)), new Translation('b', 0, new Point3i(0, 6, 0)), new Translation('c', 0, new Point3i(0, 0, 6)), new Translation('n', 0, new Point3i(6, 6, 6)), new Translation('u', 0, new Point3i(3, 0, 0)), new Translation('v', 0, new Point3i(0, 3, 0)), new Translation('w', 0, new Point3i(0, 0, 3)), new Translation('d', 0, new Point3i(3, 3, 3)), new Translation('1', 2, 6), new Translation('1', 3, 4), new Translation('2', 3, 8), new Translation('1', 4, 3), new Translation('3', 4, 9), new Translation('1', 6, 2), new Translation('2', 6, 4), new Translation('4', 6, 8), new Translation('5', 6, 10), new Translation('r', 0, new Point3i(4, 8, 8)), new Translation('s', 0, new Point3i(8, 8, 4)), new Translation('t', 0, new Point3i(8, 4, 8))};

    Translation() {
    }

    Translation(char translationCode, int order) {
        for (int i = 0; i < hallTranslationTerms.length; ++i) {
            Translation h = hallTranslationTerms[i];
            if (h.translationCode != translationCode || h.rotationOrder != 0 && h.rotationOrder != order) continue;
            this.translationCode = translationCode;
            this.rotationShift12ths = h.rotationShift12ths;
            this.vectorShift12ths = h.vectorShift12ths;
            return;
        }
    }

    private Translation(char translationCode, int order, Point3i vectorShift12ths) {
        this.translationCode = translationCode;
        this.rotationOrder = 0;
        this.rotationShift12ths = 0;
        this.vectorShift12ths = vectorShift12ths;
    }

    private Translation(char translationCode, int order, int rotationShift12ths) {
        this.translationCode = translationCode;
        this.rotationOrder = order;
        this.rotationShift12ths = rotationShift12ths;
        this.vectorShift12ths = new Point3i();
    }

    static final String getHallLatticeEquivalent(int latticeParameter) {
        char latticeCode = Translation.getLatticeCode(latticeParameter);
        boolean isCentrosymmetric = latticeParameter > 0;
        return (isCentrosymmetric ? "-" : "") + latticeCode + " 1";
    }

    static final int getLatticeIndex(char latt) {
        int i = 1;
        int ipt = 3;
        while (i <= nLatticeTypes) {
            if (latticeTranslationData[ipt].charAt(0) == latt) {
                return i;
            }
            ++i;
            ipt += 3;
        }
        return 0;
    }

    static final char getLatticeCode(int latt) {
        if (latt < 0) {
            latt = -latt;
        }
        if (latt == 0 || latt > nLatticeTypes) {
            return '\u0000';
        }
        return latticeTranslationData[latt * 3].charAt(0);
    }

    static final String getLatticeDesignation(int latt) {
        String str;
        boolean isCentrosymmetric = latt > 0;
        String string = str = isCentrosymmetric ? "-" : "";
        if (latt < 0) {
            latt = -latt;
        }
        if (latt == 0 || latt > nLatticeTypes) {
            return "";
        }
        return str + Translation.getLatticeCode(latt) + ": " + (isCentrosymmetric ? "centrosymmetric " : "") + latticeTranslationData[latt * 3 + 1];
    }

    static final String getLatticeDesignation(char latticeCode, boolean isCentrosymmetric) {
        int latt = Translation.getLatticeIndex(latticeCode);
        if (!isCentrosymmetric) {
            latt = -latt;
        }
        return Translation.getLatticeDesignation(latt);
    }

    static final String getLatticeExtension(char latt, boolean isCentrosymmetric) {
        int i = 1;
        int ipt = 3;
        while (i <= nLatticeTypes) {
            if (latticeTranslationData[ipt].charAt(0) == latt) {
                return latticeTranslationData[ipt + 2] + (isCentrosymmetric ? " -1" : "");
            }
            ++i;
            ipt += 3;
        }
        return "";
    }
}

