% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_rcdf_as.R
\name{write_rcdf_sav}
\alias{write_rcdf_sav}
\title{Write RCDF data to SPSS `.sav` files}
\usage{
write_rcdf_sav(data, path, ..., parent_dir = NULL)
}
\arguments{
\item{data}{A valid RCDF object.}

\item{path}{Output directory for files.}

\item{...}{Additional arguments passed to `haven::write_sav()`.}

\item{parent_dir}{Optional subdirectory under `path` to group SPSS files.}
}
\value{
Invisibly returns `NULL`. Files are written to disk.
}
\description{
Writes each table in the RCDF object to a `.sav` file using the `haven` package for compatibility with SPSS.
}
\examples{
dir <- system.file("extdata", package = "rcdf")
rcdf_path <- file.path(dir, 'mtcars.rcdf')
private_key <- file.path(dir, 'sample-private-key.pem')

rcdf_data <- read_rcdf(path = rcdf_path, decryption_key = private_key)
temp_dir <- tempdir()

write_rcdf_sav(data = rcdf_data, path = temp_dir)

unlink(temp_dir, force = TRUE)
}
\seealso{
\link[rcdf]{write_rcdf_as}
}
