% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{mixCurves}
\alias{mixCurves}
\title{Creates mixed terrestrial/marine calibration curves.}
\usage{
mixCurves(calCurve = "intcal13", p = 1, resOffsets = 0,
  resErrors = 0)
}
\arguments{
\item{calCurve}{Name of the terrestrial curve, either 'intcal13' or 'shcal13'. Default is 'intcal13'.}

\item{p}{Proportion of terrestrial contribution. Deafult is 1.}

\item{resOffsets}{Offset value for the marine reservoir effect. Default is 0.}

\item{resErrors}{Error of the marine reservoir effect offset. Default is 0.}
}
\value{
A three-column matrix containing calibrated year BP, uncalibrated age bp, and standard deviation. To be used as custom calibration curve for the \code{\link{calibrate}} function.
}
\description{
Function for generating a vector median calibrated dates from a \code{CalDates} class object.
}
\details{
The function is based on the \code{mix.calibrationcurves} function of the \code{clam} package.
}
\examples{
myCurve <- mixCurves('intcal13',p=0.7,resOffsets=300,resErrors=20)
x <- calibrate(4000,30,calCurves=myCurve)
}
\references{
Blaauw, M. and Christen, J.A.. 2011. Flexible paleoclimate age-depth models using an autorgressive gamma process. \emph{Bayesian Analysis}, 6, 457-474.
Blaaw, M. 2018. clam: Classical Age-Depth Modelling of Cores from Deposits. R package version 2.3.1. https://CRAN.R-project.org/packacge=clam
}
\seealso{
\code{\link{calibrate}}
}
