% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/thr_isodata.R
\name{thr_isodata}
\alias{thr_isodata}
\title{Threshold calculated with the isodata method}
\usage{
thr_isodata(x)
}
\arguments{
\item{x}{Numeric vector or a single-column \emph{matrix} or \emph{data.frame}
able to be coerced to numeric.}
}
\value{
Numeric vector of length one.
}
\description{
Threshold calculated with the algorithm by
\insertCite{isodata;textual}{rcaiman}, which was recommended by
\insertCite{Jonckheere2005;textual}{rcaiman}.
}
\details{
The implementation is based on
\href{https://imagej.net/plugins/auto-threshold#IsoData}{the IsoData method
of Auto Threshold ImageJ plugin by Gabriel Landini}, which is now available
in the 'autothresholdr' package (\code{\link[autothresholdr]{auto_thresh}}).
However, I found this implementarion more versatile since it is not
restricted to an 8-bit input.
}
\examples{
caim <- read_caim()
r <- gbc(caim$Blue)
thr <- thr_isodata(values(r))
bin <- apply_thr(r, thr)
plot(bin)
}
\references{
\insertAllCited{}
}
\seealso{
Other Binarization Functions: 
\code{\link{apply_thr}()},
\code{\link{find_sky_pixels_nonnull}()},
\code{\link{find_sky_pixels}()},
\code{\link{obia}()},
\code{\link{ootb_mblt}()},
\code{\link{ootb_obia}()},
\code{\link{regional_thresholding}()},
\code{\link{thr_image}()}
}
\concept{Binarization Functions}
