% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute.R
\name{convert_to_imputation_list_df}
\alias{convert_to_imputation_list_df}
\title{Convert list of \code{\link[=imputation_list_single]{imputation_list_single()}} objects to an \code{\link[=imputation_list_df]{imputation_list_df()}} object
(i.e. a list of \code{\link[=imputation_df]{imputation_df()}} objects's)}
\usage{
convert_to_imputation_list_df(imputes, sample_ids)
}
\arguments{
\item{imputes}{a list of \code{\link[=imputation_list_single]{imputation_list_single()}} objects}

\item{sample_ids}{A list with 1 element per required imputation_df. Each element
must contain a vector of "ID"'s which correspond to the \code{\link[=imputation_single]{imputation_single()}} ID's
that are required for that dataset. The total number of ID's must by equal to the
total number of rows within all of \code{imputes$imputations}

To accommodate for \code{method_bmlmi()} the \code{\link[=impute_data_individual]{impute_data_individual()}} function returns
a list of \code{\link[=imputation_list_single]{imputation_list_single()}} objects with 1 object per each subject.

\code{\link[=imputation_list_single]{imputation_list_single()}} stores the subjects imputations as a matrix where the columns
of the matrix correspond to the D of \code{\link[=method_bmlmi]{method_bmlmi()}}. Note that all other methods
(i.e. \verb{methods_*()}) are a special case of this with D = 1. The number of rows in the
matrix varies for each subject and is equal to the number of times the patient was selected
for imputation (for non-conditional mean methods this should be 1 per subject per imputed
dataset).

This function is best illustrated by an example:\preformatted{imputes = list(
    imputation_list_single(
        id = "Tom",
        imputations = matrix(
             imputation_single_t_1_1,  imputation_single_t_1_2,
             imputation_single_t_2_1,  imputation_single_t_2_2,
             imputation_single_t_3_1,  imputation_single_t_3_2
        )
    ),
    imputation_list_single(
        id = "Tom",
        imputations = matrix(
             imputation_single_h_1_1,  imputation_single_h_1_2,
        )
    )
)

sample_ids <- list(
    c("Tom", "Harry", "Tom"),
    c("Tom")
)
}

Then \code{convert_to_imputation_df(imputes, sample_ids)} would result in:\preformatted{imputation_list_df(
    imputation_df(
        imputation_single_t_1_1,
        imputation_single_h_1_1,
        imputation_single_t_2_1
    ),
    imputation_df(
        imputation_single_t_1_2,
        imputation_single_h_1_2,
        imputation_single_t_2_2
    ),
    imputation_df(
        imputation_single_t_3_1
    ),
    imputation_df(
        imputation_single_t_3_2
    )
)
}

Note that the different repetitions (i.e. the value set for D) are grouped together
sequentially.}
}
\description{
Convert list of \code{\link[=imputation_list_single]{imputation_list_single()}} objects to an \code{\link[=imputation_list_df]{imputation_list_df()}} object
(i.e. a list of \code{\link[=imputation_df]{imputation_df()}} objects's)
}
