% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_rbiom.r
\name{as_rbiom}
\alias{as_rbiom}
\title{Convert a variety of data types to an rbiom object.}
\usage{
as_rbiom(biom, ...)
}
\arguments{
\item{biom}{Object which can be coerced to an rbiom-class object.
For example:
\describe{
\item{\emph{file} - }{ Filepath or URL to a biom file. }
\item{\emph{matrix} - }{ An abundance matrix with OTUs in rows and samples in columns. }
\item{\code{phyloseq}-class object - }{ From the phyloseq Bioconductor R package. }
\item{\emph{list} - }{ With \code{counts} and optionally \code{metadata}, \code{taxonomy}, \code{tree}, etc (see details). }
}}

\item{...}{Properties to overwrite in biom: \code{metadata}, \code{taxonomy},
\code{tree}, etc (see details). Setting \code{underscores} here will pass it to
\code{read_tree()}.}
}
\value{
An \link[=rbiom_objects]{rbiom object}.
}
\description{
Construct an rbiom object. The returned object is an R6 reference class.
Use \code{b <- a$clone()} to create copies, not \code{b <- a}.
}
\examples{
    library(rbiom)
    
    # create a simple matrix ------------------------
    mtx <- matrix(
      data     = floor(runif(24) * 1000), 
      nrow     = 6, 
      dimnames = list(paste0("OTU", 1:6), paste0("Sample", 1:4)) )
    mtx
    
    # and some sample metadata ----------------------
    df <- data.frame(
      .sample   = paste0("Sample", 1:4),
      treatment = c("A", "B", "A", "B"),
      days      = c(12, 3, 7, 8) )
    
    # convert data set to rbiom ---------------------
    biom <- as_rbiom(mtx, metadata = df, id = "My BIOM")
    biom

}
