// Generated by rstantools.  Do not edit by hand.

/*
    rbioacc is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    rbioacc is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with rbioacc.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.21.0
#include <stan/model/model_header.hpp>
namespace model_TK_predict_namespace {
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;
static int current_statement_begin__;
stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_TK_predict");
    reader.add_event(2, 2, "include", "/include/linear_interpolation.stan");
    reader.add_event(2, 0, "start", "/include/linear_interpolation.stan");
    reader.add_event(125, 123, "end", "/include/linear_interpolation.stan");
    reader.add_event(125, 3, "restart", "model_TK_predict");
    reader.add_event(274, 150, "end", "model_TK_predict");
    return reader;
}
template <typename T0__, typename T1__>
int
findfirst(const T0__& t,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& xt, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__>::type local_scalar_t__;
    typedef int fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 5;
        int i(0);
        (void) i;  // dummy to suppress unused var warning
        stan::math::fill(i, std::numeric_limits<int>::min());
        stan::math::assign(i,0);
        current_statement_begin__ = 6;
        if (as_bool(logical_eq(t, max(xt)))) {
            current_statement_begin__ = 7;
            stan::math::assign(i, (num_elements(xt) - 1));
            current_statement_begin__ = 8;
            return stan::math::promote_scalar<fun_return_scalar_t__>(i);
        } else if (as_bool((primitive_value(logical_lt(t, min(xt))) || primitive_value(logical_gt(t, max(xt)))))) {
            current_statement_begin__ = 10;
            return stan::math::promote_scalar<fun_return_scalar_t__>(i);
        } else {
            current_statement_begin__ = 12;
            while (as_bool(logical_gte(t, get_base1(xt, (i + 1), "xt", 1)))) {
                current_statement_begin__ = 13;
                stan::math::assign(i, (i + 1));
            }
            current_statement_begin__ = 15;
            return stan::math::promote_scalar<fun_return_scalar_t__>(i);
        }
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct findfirst_functor__ {
    template <typename T0__, typename T1__>
        int
    operator()(const T0__& t,
              const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& xt, std::ostream* pstream__) const {
        return findfirst(t, xt, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__>
typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
interpolate(const T0__& x,
                const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& xpt,
                const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& ypt, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        current_statement_begin__ = 20;
        if (as_bool((primitive_value(logical_gte(x, min(xpt))) && primitive_value(logical_lte(x, max(xpt)))))) {
            {
            current_statement_begin__ = 21;
            int idx(0);
            (void) idx;  // dummy to suppress unused var warning
            stan::math::fill(idx, std::numeric_limits<int>::min());
            stan::math::assign(idx,findfirst(x, xpt, pstream__));
            current_statement_begin__ = 22;
            return stan::math::promote_scalar<fun_return_scalar_t__>((get_base1(ypt, idx, "ypt", 1) + (((x - get_base1(xpt, idx, "xpt", 1)) * (get_base1(ypt, (idx + 1), "ypt", 1) - get_base1(ypt, idx, "ypt", 1))) / (get_base1(xpt, (idx + 1), "xpt", 1) - get_base1(xpt, idx, "xpt", 1)))));
            }
        } else {
            current_statement_begin__ = 24;
            return stan::math::promote_scalar<fun_return_scalar_t__>(0.0);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct interpolate_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        typename boost::math::tools::promote_args<T0__, T1__, T2__>::type
    operator()(const T0__& x,
                const Eigen::Matrix<T1__, Eigen::Dynamic, 1>& xpt,
                const Eigen::Matrix<T2__, Eigen::Dynamic, 1>& ypt, std::ostream* pstream__) const {
        return interpolate(x, xpt, ypt, pstream__);
    }
};
template <typename T0__, typename T1__, typename T2__, typename T3__>
std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type>
odeTK(const T0__& t,
          const std::vector<T1__>& y,
          const std::vector<T2__>& theta,
          const std::vector<T3__>& x_r,
          const std::vector<int>& x_i, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type local_scalar_t__;
    typedef local_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 37;
        int lentp_rmNA(0);
        (void) lentp_rmNA;  // dummy to suppress unused var warning
        stan::math::fill(lentp_rmNA, std::numeric_limits<int>::min());
        stan::math::assign(lentp_rmNA,get_base1(x_i, 1, "x_i", 1));
        current_statement_begin__ = 38;
        int lentp(0);
        (void) lentp;  // dummy to suppress unused var warning
        stan::math::fill(lentp, std::numeric_limits<int>::min());
        stan::math::assign(lentp,get_base1(x_i, 2, "x_i", 1));
        current_statement_begin__ = 39;
        int n_exp(0);
        (void) n_exp;  // dummy to suppress unused var warning
        stan::math::fill(n_exp, std::numeric_limits<int>::min());
        stan::math::assign(n_exp,get_base1(x_i, 3, "x_i", 1));
        current_statement_begin__ = 40;
        int n_out(0);
        (void) n_out;  // dummy to suppress unused var warning
        stan::math::fill(n_out, std::numeric_limits<int>::min());
        stan::math::assign(n_out,get_base1(x_i, 4, "x_i", 1));
        current_statement_begin__ = 41;
        int n_met(0);
        (void) n_met;  // dummy to suppress unused var warning
        stan::math::fill(n_met, std::numeric_limits<int>::min());
        stan::math::assign(n_met,get_base1(x_i, 5, "x_i", 1));
        current_statement_begin__ = 43;
        validate_non_negative_index("ku", "n_exp", n_exp);
        std::vector<local_scalar_t__  > ku(n_exp, local_scalar_t__(DUMMY_VAR__));
        stan::math::initialize(ku, DUMMY_VAR__);
        stan::math::fill(ku, DUMMY_VAR__);
        stan::math::assign(ku,stan::model::rvalue(theta, stan::model::cons_list(stan::model::index_min_max(1, n_exp), stan::model::nil_index_list()), "theta"));
        current_statement_begin__ = 44;
        validate_non_negative_index("ke", "n_out", n_out);
        std::vector<local_scalar_t__  > ke(n_out, local_scalar_t__(DUMMY_VAR__));
        stan::math::initialize(ke, DUMMY_VAR__);
        stan::math::fill(ke, DUMMY_VAR__);
        stan::math::assign(ke,stan::model::rvalue(theta, stan::model::cons_list(stan::model::index_min_max((n_exp + 1), (n_exp + n_out)), stan::model::nil_index_list()), "theta"));
        current_statement_begin__ = 45;
        validate_non_negative_index("km", "n_met", n_met);
        std::vector<local_scalar_t__  > km(n_met, local_scalar_t__(DUMMY_VAR__));
        stan::math::initialize(km, DUMMY_VAR__);
        stan::math::fill(km, DUMMY_VAR__);
        stan::math::assign(km,stan::model::rvalue(theta, stan::model::cons_list(stan::model::index_min_max(((n_exp + n_out) + 1), ((n_exp + n_out) + n_met)), stan::model::nil_index_list()), "theta"));
        current_statement_begin__ = 46;
        validate_non_negative_index("kem", "n_met", n_met);
        std::vector<local_scalar_t__  > kem(n_met, local_scalar_t__(DUMMY_VAR__));
        stan::math::initialize(kem, DUMMY_VAR__);
        stan::math::fill(kem, DUMMY_VAR__);
        stan::math::assign(kem,stan::model::rvalue(theta, stan::model::cons_list(stan::model::index_min_max((((n_exp + n_out) + n_met) + 1), (((n_exp + n_out) + n_met) + n_met)), stan::model::nil_index_list()), "theta"));
        current_statement_begin__ = 49;
        validate_non_negative_index("dydt", "(1 + n_met)", (1 + n_met));
        std::vector<local_scalar_t__  > dydt((1 + n_met), local_scalar_t__(DUMMY_VAR__));
        stan::math::initialize(dydt, DUMMY_VAR__);
        stan::math::fill(dydt, DUMMY_VAR__);
        current_statement_begin__ = 51;
        local_scalar_t__ tacc(DUMMY_VAR__);
        (void) tacc;  // dummy to suppress unused var warning
        stan::math::initialize(tacc, DUMMY_VAR__);
        stan::math::fill(tacc, DUMMY_VAR__);
        stan::math::assign(tacc,get_base1(x_r, 1, "x_r", 1));
        current_statement_begin__ = 53;
        validate_non_negative_index("tp_rmNA", "lentp_rmNA", lentp_rmNA);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> tp_rmNA(lentp_rmNA);
        stan::math::initialize(tp_rmNA, DUMMY_VAR__);
        stan::math::fill(tp_rmNA, DUMMY_VAR__);
        stan::math::assign(tp_rmNA,to_vector(stan::model::rvalue(x_r, stan::model::cons_list(stan::model::index_min_max(2, (lentp_rmNA + 1)), stan::model::nil_index_list()), "x_r")));
        current_statement_begin__ = 57;
        validate_non_negative_index("Cexp_rmNA", "lentp_rmNA", lentp_rmNA);
        Eigen::Matrix<local_scalar_t__, Eigen::Dynamic, 1> Cexp_rmNA(lentp_rmNA);
        stan::math::initialize(Cexp_rmNA, DUMMY_VAR__);
        stan::math::fill(Cexp_rmNA, DUMMY_VAR__);
        stan::math::assign(Cexp_rmNA,to_vector(stan::model::rvalue(x_r, stan::model::cons_list(stan::model::index_min_max((lentp_rmNA + 2), ((lentp_rmNA + 1) + lentp_rmNA)), stan::model::nil_index_list()), "x_r")));
        current_statement_begin__ = 60;
        local_scalar_t__ U(DUMMY_VAR__);
        (void) U;  // dummy to suppress unused var warning
        stan::math::initialize(U, DUMMY_VAR__);
        stan::math::fill(U, DUMMY_VAR__);
        current_statement_begin__ = 61;
        local_scalar_t__ M(DUMMY_VAR__);
        (void) M;  // dummy to suppress unused var warning
        stan::math::initialize(M, DUMMY_VAR__);
        stan::math::fill(M, DUMMY_VAR__);
        current_statement_begin__ = 62;
        local_scalar_t__ E(DUMMY_VAR__);
        (void) E;  // dummy to suppress unused var warning
        stan::math::initialize(E, DUMMY_VAR__);
        stan::math::fill(E, DUMMY_VAR__);
        current_statement_begin__ = 64;
        if (as_bool(logical_eq(n_met, 0))) {
            current_statement_begin__ = 65;
            stan::math::assign(M, 0);
        } else {
            current_statement_begin__ = 67;
            stan::math::assign(M, sum(km));
        }
        current_statement_begin__ = 69;
        stan::math::assign(E, sum(ke));
        current_statement_begin__ = 73;
        stan::math::assign(U, (get_base1(ku, 1, "ku", 1) * interpolate(t, tp_rmNA, Cexp_rmNA, pstream__)));
        current_statement_begin__ = 79;
        if (as_bool(logical_lte(t, tacc))) {
            current_statement_begin__ = 81;
            stan::model::assign(dydt, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        (U - ((E + M) * get_base1(y, 1, "y", 1))), 
                        "assigning variable dydt");
        } else {
            current_statement_begin__ = 84;
            stan::model::assign(dydt, 
                        stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list()), 
                        (-((E + M)) * get_base1(y, 1, "y", 1)), 
                        "assigning variable dydt");
        }
        current_statement_begin__ = 86;
        if (as_bool(logical_gt(n_met, 0))) {
            current_statement_begin__ = 87;
            for (int i = 2; i <= (n_met + 1); ++i) {
                current_statement_begin__ = 88;
                stan::model::assign(dydt, 
                            stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                            ((get_base1(km, i, "km", 1) * get_base1(y, 1, "y", 1)) - (get_base1(kem, i, "kem", 1) * get_base1(y, i, "y", 1))), 
                            "assigning variable dydt");
            }
        }
        current_statement_begin__ = 91;
        return stan::math::promote_scalar<fun_return_scalar_t__>(dydt);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}
struct odeTK_functor__ {
    template <typename T0__, typename T1__, typename T2__, typename T3__>
        std::vector<typename boost::math::tools::promote_args<T0__, T1__, T2__, T3__>::type>
    operator()(const T0__& t,
          const std::vector<T1__>& y,
          const std::vector<T2__>& theta,
          const std::vector<T3__>& x_r,
          const std::vector<int>& x_i, std::ostream* pstream__) const {
        return odeTK(t, y, theta, x_r, x_i, pstream__);
    }
};
#include <stan_meta_header.hpp>
class model_TK_predict
  : public stan::model::model_base_crtp<model_TK_predict> {
private:
        int lentp;
        vector_d tp;
        int len_vt;
        vector_d vt;
        int n_exp;
        matrix_d Cexp;
        int rankacc;
        double tacc;
        double C0;
        double elim_rate;
        int n_out;
        int n_met;
        int N_samples;
        matrix_d log10ku;
        matrix_d log10ke;
        matrix_d log10km;
        matrix_d log10kem;
        std::vector<double> M;
        std::vector<double> E;
        std::vector<std::vector<double> > sigmaCGpred;
        matrix_d sigmaCmetpred;
        std::vector<std::vector<double> > gmax;
        std::vector<std::vector<double> > G0;
public:
    model_TK_predict(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, 0, pstream__);
    }
    model_TK_predict(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : model_base_crtp(0) {
        ctor_body(context__, random_seed__, pstream__);
    }
    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        typedef double local_scalar_t__;
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning
        current_statement_begin__ = -1;
        static const char* function__ = "model_TK_predict_namespace::model_TK_predict";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        try {
            // initialize data block variables from context__
            current_statement_begin__ = 130;
            context__.validate_dims("data initialization", "lentp", "int", context__.to_vec());
            lentp = int(0);
            vals_i__ = context__.vals_i("lentp");
            pos__ = 0;
            lentp = vals_i__[pos__++];
            check_greater_or_equal(function__, "lentp", lentp, 0);
            current_statement_begin__ = 131;
            validate_non_negative_index("tp", "lentp", lentp);
            context__.validate_dims("data initialization", "tp", "vector_d", context__.to_vec(lentp));
            tp = Eigen::Matrix<double, Eigen::Dynamic, 1>(lentp);
            vals_r__ = context__.vals_r("tp");
            pos__ = 0;
            size_t tp_j_1_max__ = lentp;
            for (size_t j_1__ = 0; j_1__ < tp_j_1_max__; ++j_1__) {
                tp(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 133;
            context__.validate_dims("data initialization", "len_vt", "int", context__.to_vec());
            len_vt = int(0);
            vals_i__ = context__.vals_i("len_vt");
            pos__ = 0;
            len_vt = vals_i__[pos__++];
            check_greater_or_equal(function__, "len_vt", len_vt, 0);
            current_statement_begin__ = 134;
            validate_non_negative_index("vt", "len_vt", len_vt);
            context__.validate_dims("data initialization", "vt", "vector_d", context__.to_vec(len_vt));
            vt = Eigen::Matrix<double, Eigen::Dynamic, 1>(len_vt);
            vals_r__ = context__.vals_r("vt");
            pos__ = 0;
            size_t vt_j_1_max__ = len_vt;
            for (size_t j_1__ = 0; j_1__ < vt_j_1_max__; ++j_1__) {
                vt(j_1__) = vals_r__[pos__++];
            }
            current_statement_begin__ = 136;
            context__.validate_dims("data initialization", "n_exp", "int", context__.to_vec());
            n_exp = int(0);
            vals_i__ = context__.vals_i("n_exp");
            pos__ = 0;
            n_exp = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_exp", n_exp, 0);
            current_statement_begin__ = 137;
            validate_non_negative_index("Cexp", "len_vt", len_vt);
            validate_non_negative_index("Cexp", "n_exp", n_exp);
            context__.validate_dims("data initialization", "Cexp", "matrix_d", context__.to_vec(len_vt,n_exp));
            Cexp = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(len_vt, n_exp);
            vals_r__ = context__.vals_r("Cexp");
            pos__ = 0;
            size_t Cexp_j_2_max__ = n_exp;
            size_t Cexp_j_1_max__ = len_vt;
            for (size_t j_2__ = 0; j_2__ < Cexp_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Cexp_j_1_max__; ++j_1__) {
                    Cexp(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 140;
            context__.validate_dims("data initialization", "rankacc", "int", context__.to_vec());
            rankacc = int(0);
            vals_i__ = context__.vals_i("rankacc");
            pos__ = 0;
            rankacc = vals_i__[pos__++];
            check_greater_or_equal(function__, "rankacc", rankacc, 0);
            current_statement_begin__ = 141;
            context__.validate_dims("data initialization", "tacc", "double", context__.to_vec());
            tacc = double(0);
            vals_r__ = context__.vals_r("tacc");
            pos__ = 0;
            tacc = vals_r__[pos__++];
            check_greater_or_equal(function__, "tacc", tacc, 0);
            current_statement_begin__ = 142;
            context__.validate_dims("data initialization", "C0", "double", context__.to_vec());
            C0 = double(0);
            vals_r__ = context__.vals_r("C0");
            pos__ = 0;
            C0 = vals_r__[pos__++];
            check_greater_or_equal(function__, "C0", C0, 0);
            current_statement_begin__ = 144;
            context__.validate_dims("data initialization", "elim_rate", "double", context__.to_vec());
            elim_rate = double(0);
            vals_r__ = context__.vals_r("elim_rate");
            pos__ = 0;
            elim_rate = vals_r__[pos__++];
            current_statement_begin__ = 147;
            context__.validate_dims("data initialization", "n_out", "int", context__.to_vec());
            n_out = int(0);
            vals_i__ = context__.vals_i("n_out");
            pos__ = 0;
            n_out = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_out", n_out, 0);
            current_statement_begin__ = 148;
            context__.validate_dims("data initialization", "n_met", "int", context__.to_vec());
            n_met = int(0);
            vals_i__ = context__.vals_i("n_met");
            pos__ = 0;
            n_met = vals_i__[pos__++];
            check_greater_or_equal(function__, "n_met", n_met, 0);
            current_statement_begin__ = 149;
            context__.validate_dims("data initialization", "N_samples", "int", context__.to_vec());
            N_samples = int(0);
            vals_i__ = context__.vals_i("N_samples");
            pos__ = 0;
            N_samples = vals_i__[pos__++];
            current_statement_begin__ = 150;
            validate_non_negative_index("log10ku", "N_samples", N_samples);
            validate_non_negative_index("log10ku", "n_exp", n_exp);
            context__.validate_dims("data initialization", "log10ku", "matrix_d", context__.to_vec(N_samples,n_exp));
            log10ku = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N_samples, n_exp);
            vals_r__ = context__.vals_r("log10ku");
            pos__ = 0;
            size_t log10ku_j_2_max__ = n_exp;
            size_t log10ku_j_1_max__ = N_samples;
            for (size_t j_2__ = 0; j_2__ < log10ku_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < log10ku_j_1_max__; ++j_1__) {
                    log10ku(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 151;
            validate_non_negative_index("log10ke", "N_samples", N_samples);
            validate_non_negative_index("log10ke", "n_out", n_out);
            context__.validate_dims("data initialization", "log10ke", "matrix_d", context__.to_vec(N_samples,n_out));
            log10ke = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N_samples, n_out);
            vals_r__ = context__.vals_r("log10ke");
            pos__ = 0;
            size_t log10ke_j_2_max__ = n_out;
            size_t log10ke_j_1_max__ = N_samples;
            for (size_t j_2__ = 0; j_2__ < log10ke_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < log10ke_j_1_max__; ++j_1__) {
                    log10ke(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 152;
            validate_non_negative_index("log10km", "N_samples", N_samples);
            validate_non_negative_index("log10km", "n_met", n_met);
            context__.validate_dims("data initialization", "log10km", "matrix_d", context__.to_vec(N_samples,n_met));
            log10km = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N_samples, n_met);
            vals_r__ = context__.vals_r("log10km");
            pos__ = 0;
            size_t log10km_j_2_max__ = n_met;
            size_t log10km_j_1_max__ = N_samples;
            for (size_t j_2__ = 0; j_2__ < log10km_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < log10km_j_1_max__; ++j_1__) {
                    log10km(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 153;
            validate_non_negative_index("log10kem", "N_samples", N_samples);
            validate_non_negative_index("log10kem", "n_met", n_met);
            context__.validate_dims("data initialization", "log10kem", "matrix_d", context__.to_vec(N_samples,n_met));
            log10kem = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N_samples, n_met);
            vals_r__ = context__.vals_r("log10kem");
            pos__ = 0;
            size_t log10kem_j_2_max__ = n_met;
            size_t log10kem_j_1_max__ = N_samples;
            for (size_t j_2__ = 0; j_2__ < log10kem_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < log10kem_j_1_max__; ++j_1__) {
                    log10kem(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 155;
            validate_non_negative_index("M", "N_samples", N_samples);
            context__.validate_dims("data initialization", "M", "double", context__.to_vec(N_samples));
            M = std::vector<double>(N_samples, double(0));
            vals_r__ = context__.vals_r("M");
            pos__ = 0;
            size_t M_k_0_max__ = N_samples;
            for (size_t k_0__ = 0; k_0__ < M_k_0_max__; ++k_0__) {
                M[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 156;
            validate_non_negative_index("E", "N_samples", N_samples);
            context__.validate_dims("data initialization", "E", "double", context__.to_vec(N_samples));
            E = std::vector<double>(N_samples, double(0));
            vals_r__ = context__.vals_r("E");
            pos__ = 0;
            size_t E_k_0_max__ = N_samples;
            for (size_t k_0__ = 0; k_0__ < E_k_0_max__; ++k_0__) {
                E[k_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 158;
            validate_non_negative_index("sigmaCGpred", "N_samples", N_samples);
            validate_non_negative_index("sigmaCGpred", "n_out", n_out);
            context__.validate_dims("data initialization", "sigmaCGpred", "double", context__.to_vec(N_samples,n_out));
            sigmaCGpred = std::vector<std::vector<double> >(N_samples, std::vector<double>(n_out, double(0)));
            vals_r__ = context__.vals_r("sigmaCGpred");
            pos__ = 0;
            size_t sigmaCGpred_k_0_max__ = N_samples;
            size_t sigmaCGpred_k_1_max__ = n_out;
            for (size_t k_1__ = 0; k_1__ < sigmaCGpred_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < sigmaCGpred_k_0_max__; ++k_0__) {
                    sigmaCGpred[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            size_t sigmaCGpred_i_0_max__ = N_samples;
            size_t sigmaCGpred_i_1_max__ = n_out;
            for (size_t i_0__ = 0; i_0__ < sigmaCGpred_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < sigmaCGpred_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "sigmaCGpred[i_0__][i_1__]", sigmaCGpred[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 159;
            validate_non_negative_index("sigmaCmetpred", "N_samples", N_samples);
            validate_non_negative_index("sigmaCmetpred", "n_met", n_met);
            context__.validate_dims("data initialization", "sigmaCmetpred", "matrix_d", context__.to_vec(N_samples,n_met));
            sigmaCmetpred = Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic>(N_samples, n_met);
            vals_r__ = context__.vals_r("sigmaCmetpred");
            pos__ = 0;
            size_t sigmaCmetpred_j_2_max__ = n_met;
            size_t sigmaCmetpred_j_1_max__ = N_samples;
            for (size_t j_2__ = 0; j_2__ < sigmaCmetpred_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < sigmaCmetpred_j_1_max__; ++j_1__) {
                    sigmaCmetpred(j_1__, j_2__) = vals_r__[pos__++];
                }
            }
            check_greater_or_equal(function__, "sigmaCmetpred", sigmaCmetpred, 0);
            current_statement_begin__ = 161;
            validate_non_negative_index("gmax", "N_samples", N_samples);
            validate_non_negative_index("gmax", "(n_out - 1)", (n_out - 1));
            context__.validate_dims("data initialization", "gmax", "double", context__.to_vec(N_samples,(n_out - 1)));
            gmax = std::vector<std::vector<double> >(N_samples, std::vector<double>((n_out - 1), double(0)));
            vals_r__ = context__.vals_r("gmax");
            pos__ = 0;
            size_t gmax_k_0_max__ = N_samples;
            size_t gmax_k_1_max__ = (n_out - 1);
            for (size_t k_1__ = 0; k_1__ < gmax_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < gmax_k_0_max__; ++k_0__) {
                    gmax[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            size_t gmax_i_0_max__ = N_samples;
            size_t gmax_i_1_max__ = (n_out - 1);
            for (size_t i_0__ = 0; i_0__ < gmax_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < gmax_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "gmax[i_0__][i_1__]", gmax[i_0__][i_1__], 0);
                }
            }
            current_statement_begin__ = 162;
            validate_non_negative_index("G0", "N_samples", N_samples);
            validate_non_negative_index("G0", "(n_out - 1)", (n_out - 1));
            context__.validate_dims("data initialization", "G0", "double", context__.to_vec(N_samples,(n_out - 1)));
            G0 = std::vector<std::vector<double> >(N_samples, std::vector<double>((n_out - 1), double(0)));
            vals_r__ = context__.vals_r("G0");
            pos__ = 0;
            size_t G0_k_0_max__ = N_samples;
            size_t G0_k_1_max__ = (n_out - 1);
            for (size_t k_1__ = 0; k_1__ < G0_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < G0_k_0_max__; ++k_0__) {
                    G0[k_0__][k_1__] = vals_r__[pos__++];
                }
            }
            size_t G0_i_0_max__ = N_samples;
            size_t G0_i_1_max__ = (n_out - 1);
            for (size_t i_0__ = 0; i_0__ < G0_i_0_max__; ++i_0__) {
                for (size_t i_1__ = 0; i_1__ < G0_i_1_max__; ++i_1__) {
                    check_greater_or_equal(function__, "G0[i_0__][i_1__]", G0[i_0__][i_1__], 0);
                }
            }
            // initialize transformed data variables
            // execute transformed data statements
            // validate transformed data
            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    ~model_TK_predict() { }
    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        typedef double local_scalar_t__;
        stan::io::writer<double> writer__(params_r__, params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;
        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }
    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }
    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(std::vector<T__>& params_r__,
                 std::vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {
        typedef T__ local_scalar_t__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // dummy to suppress unused var warning
        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;
        try {
            stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
            // model parameters
            // model body
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
        lp_accum__.add(lp__);
        return lp_accum__.sum();
    } // log_prob()
    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }
    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("CGobs_out");
        names__.push_back("Cmet_out");
        names__.push_back("Cexp_interpol");
        names__.push_back("ku");
        names__.push_back("ke");
        names__.push_back("km");
        names__.push_back("kem");
        names__.push_back("U");
        names__.push_back("R");
        names__.push_back("D");
        names__.push_back("CGpred");
        names__.push_back("Cmetpred");
    }
    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(lentp);
        dims__.push_back(n_out);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(lentp);
        dims__.push_back(n_met);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(lentp);
        dims__.push_back(n_exp);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_exp);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_out);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_met);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_met);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(lentp);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(lentp);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(n_met);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(lentp);
        dims__.push_back(n_out);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(lentp);
        dims__.push_back(n_met);
        dimss__.push_back(dims__);
    }
    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        typedef double local_scalar_t__;
        vars__.resize(0);
        stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
        static const char* function__ = "model_TK_predict_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;
        local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning
        if (!include_tparams__ && !include_gqs__) return;
        try {
            if (!include_gqs__ && !include_tparams__) return;
            if (!include_gqs__) return;
            // declare and define generated quantities
            current_statement_begin__ = 173;
            validate_non_negative_index("CGobs_out", "lentp", lentp);
            validate_non_negative_index("CGobs_out", "n_out", n_out);
            std::vector<std::vector<double> > CGobs_out(lentp, std::vector<double>(n_out, double(0)));
            stan::math::initialize(CGobs_out, DUMMY_VAR__);
            stan::math::fill(CGobs_out, DUMMY_VAR__);
            current_statement_begin__ = 174;
            validate_non_negative_index("Cmet_out", "lentp", lentp);
            validate_non_negative_index("Cmet_out", "n_met", n_met);
            std::vector<std::vector<double> > Cmet_out(lentp, std::vector<double>(n_met, double(0)));
            stan::math::initialize(Cmet_out, DUMMY_VAR__);
            stan::math::fill(Cmet_out, DUMMY_VAR__);
            current_statement_begin__ = 176;
            validate_non_negative_index("Cexp_interpol", "lentp", lentp);
            validate_non_negative_index("Cexp_interpol", "n_exp", n_exp);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Cexp_interpol(lentp, n_exp);
            stan::math::initialize(Cexp_interpol, DUMMY_VAR__);
            stan::math::fill(Cexp_interpol, DUMMY_VAR__);
            current_statement_begin__ = 179;
            validate_non_negative_index("ku", "n_exp", n_exp);
            Eigen::Matrix<double, Eigen::Dynamic, 1> ku(n_exp);
            stan::math::initialize(ku, DUMMY_VAR__);
            stan::math::fill(ku, DUMMY_VAR__);
            current_statement_begin__ = 180;
            validate_non_negative_index("ke", "n_out", n_out);
            Eigen::Matrix<double, Eigen::Dynamic, 1> ke(n_out);
            stan::math::initialize(ke, DUMMY_VAR__);
            stan::math::fill(ke, DUMMY_VAR__);
            current_statement_begin__ = 181;
            validate_non_negative_index("km", "n_met", n_met);
            Eigen::Matrix<double, Eigen::Dynamic, 1> km(n_met);
            stan::math::initialize(km, DUMMY_VAR__);
            stan::math::fill(km, DUMMY_VAR__);
            current_statement_begin__ = 182;
            validate_non_negative_index("kem", "n_met", n_met);
            Eigen::Matrix<double, Eigen::Dynamic, 1> kem(n_met);
            stan::math::initialize(kem, DUMMY_VAR__);
            stan::math::fill(kem, DUMMY_VAR__);
            current_statement_begin__ = 184;
            validate_non_negative_index("U", "lentp", lentp);
            Eigen::Matrix<double, Eigen::Dynamic, 1> U(lentp);
            stan::math::initialize(U, DUMMY_VAR__);
            stan::math::fill(U, DUMMY_VAR__);
            current_statement_begin__ = 185;
            validate_non_negative_index("R", "lentp", lentp);
            Eigen::Matrix<double, Eigen::Dynamic, 1> R(lentp);
            stan::math::initialize(R, DUMMY_VAR__);
            stan::math::fill(R, DUMMY_VAR__);
            current_statement_begin__ = 186;
            validate_non_negative_index("D", "n_met", n_met);
            Eigen::Matrix<double, Eigen::Dynamic, 1> D(n_met);
            stan::math::initialize(D, DUMMY_VAR__);
            stan::math::fill(D, DUMMY_VAR__);
            current_statement_begin__ = 188;
            validate_non_negative_index("CGpred", "lentp", lentp);
            validate_non_negative_index("CGpred", "n_out", n_out);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> CGpred(lentp, n_out);
            stan::math::initialize(CGpred, DUMMY_VAR__);
            stan::math::fill(CGpred, DUMMY_VAR__);
            current_statement_begin__ = 189;
            validate_non_negative_index("Cmetpred", "lentp", lentp);
            validate_non_negative_index("Cmetpred", "n_met", n_met);
            Eigen::Matrix<double, Eigen::Dynamic, Eigen::Dynamic> Cmetpred(lentp, n_met);
            stan::math::initialize(Cmetpred, DUMMY_VAR__);
            stan::math::fill(Cmetpred, DUMMY_VAR__);
            // generated quantities statements
            current_statement_begin__ = 192;
            for (int i = 1; i <= n_exp; ++i) {
                current_statement_begin__ = 193;
                for (int t = 1; t <= lentp; ++t) {
                    current_statement_begin__ = 194;
                    stan::model::assign(Cexp_interpol, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                interpolate(get_base1(tp, t, "tp", 1), vt, stan::model::rvalue(Cexp, stan::model::cons_list(stan::model::index_min_max(1, len_vt), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), "Cexp"), pstream__), 
                                "assigning variable Cexp_interpol");
                }
            }
            current_statement_begin__ = 199;
            for (int s = 1; s <= N_samples; ++s) {
                current_statement_begin__ = 200;
                for (int i = 1; i <= n_exp; ++i) {
                    current_statement_begin__ = 201;
                    stan::model::assign(ku, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                pow(10, get_base1(log10ku, s, i, "log10ku", 1)), 
                                "assigning variable ku");
                }
                current_statement_begin__ = 203;
                for (int i = 1; i <= n_out; ++i) {
                    current_statement_begin__ = 204;
                    if (as_bool(logical_negation(is_inf(elim_rate)))) {
                        current_statement_begin__ = 205;
                        stan::model::assign(ke, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    0, 
                                    "assigning variable ke");
                    } else {
                        current_statement_begin__ = 207;
                        stan::model::assign(ke, 
                                    stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                    pow(10, get_base1(log10ke, s, i, "log10ke", 1)), 
                                    "assigning variable ke");
                    }
                }
                current_statement_begin__ = 210;
                for (int i = 1; i <= n_met; ++i) {
                    current_statement_begin__ = 211;
                    stan::model::assign(km, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                pow(10, get_base1(log10km, s, i, "log10km", 1)), 
                                "assigning variable km");
                    current_statement_begin__ = 212;
                    stan::model::assign(kem, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                pow(10, get_base1(log10kem, s, i, "log10kem", 1)), 
                                "assigning variable kem");
                }
                current_statement_begin__ = 214;
                for (int t = 1; t <= lentp; ++t) {
                    current_statement_begin__ = 216;
                    stan::model::assign(U, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                multiply(stan::model::rvalue(Cexp_interpol, stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_min_max(1, n_exp), stan::model::nil_index_list())), "Cexp_interpol"), ku), 
                                "assigning variable U");
                    current_statement_begin__ = 217;
                    stan::model::assign(R, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::nil_index_list()), 
                                (get_base1(U, t, "U", 1) / (get_base1(E, s, "E", 1) + get_base1(M, s, "M", 1))), 
                                "assigning variable R");
                }
                current_statement_begin__ = 219;
                for (int i = 1; i <= n_met; ++i) {
                    current_statement_begin__ = 220;
                    stan::model::assign(D, 
                                stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list()), 
                                (get_base1(kem, i, "kem", 1) - (get_base1(E, s, "E", 1) + get_base1(M, s, "M", 1))), 
                                "assigning variable D");
                }
                current_statement_begin__ = 223;
                for (int t = 1; t <= rankacc; ++t) {
                    current_statement_begin__ = 225;
                    stan::model::assign(CGpred, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                                (((C0 - get_base1(R, t, "R", 1)) * stan::math::exp((-((get_base1(E, s, "E", 1) + get_base1(M, s, "M", 1))) * get_base1(tp, t, "tp", 1)))) + get_base1(R, t, "R", 1)), 
                                "assigning variable CGpred");
                    current_statement_begin__ = 227;
                    if (as_bool(logical_gt(n_met, 0))) {
                        current_statement_begin__ = 228;
                        for (int i = 1; i <= n_met; ++i) {
                            current_statement_begin__ = 229;
                            stan::model::assign(Cmetpred, 
                                        stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                        (get_base1(km, i, "km", 1) * ((((C0 - get_base1(R, t, "R", 1)) / get_base1(D, i, "D", 1)) * (stan::math::exp((-((get_base1(E, s, "E", 1) + get_base1(M, s, "M", 1))) * get_base1(tp, t, "tp", 1))) - stan::math::exp((-(get_base1(kem, i, "kem", 1)) * get_base1(tp, t, "tp", 1))))) + ((get_base1(R, t, "R", 1) / get_base1(kem, i, "kem", 1)) * (1 - stan::math::exp(-((get_base1(kem, i, "kem", 1) * get_base1(tp, t, "tp", 1)))))))), 
                                        "assigning variable Cmetpred");
                        }
                    }
                }
                current_statement_begin__ = 236;
                for (int t = (rankacc + 1); t <= lentp; ++t) {
                    current_statement_begin__ = 238;
                    stan::model::assign(CGpred, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                                ((C0 - (get_base1(R, t, "R", 1) * (1 - stan::math::exp(((get_base1(E, s, "E", 1) + get_base1(M, s, "M", 1)) * tacc))))) * stan::math::exp((-((get_base1(E, s, "E", 1) + get_base1(M, s, "M", 1))) * get_base1(tp, t, "tp", 1)))), 
                                "assigning variable CGpred");
                    current_statement_begin__ = 240;
                    if (as_bool(logical_gt(n_met, 0))) {
                        current_statement_begin__ = 241;
                        for (int i = 1; i <= n_met; ++i) {
                            current_statement_begin__ = 242;
                            stan::model::assign(Cmetpred, 
                                        stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                        (get_base1(km, i, "km", 1) * (((((C0 - get_base1(R, t, "R", 1)) / get_base1(D, i, "D", 1)) * (stan::math::exp((-((get_base1(E, s, "E", 1) + get_base1(M, s, "M", 1))) * get_base1(tp, t, "tp", 1))) - stan::math::exp((-(get_base1(kem, i, "kem", 1)) * get_base1(tp, t, "tp", 1))))) + ((get_base1(R, t, "R", 1) / get_base1(kem, i, "kem", 1)) * (stan::math::exp((-(get_base1(kem, i, "kem", 1)) * (get_base1(tp, t, "tp", 1) - tacc))) - stan::math::exp((-(get_base1(kem, i, "kem", 1)) * get_base1(tp, t, "tp", 1)))))) + ((get_base1(R, t, "R", 1) / get_base1(D, i, "D", 1)) * (stan::math::exp((-((get_base1(E, s, "E", 1) + get_base1(M, s, "M", 1))) * (get_base1(tp, t, "tp", 1) - tacc))) - stan::math::exp((-(get_base1(kem, i, "kem", 1)) * (get_base1(tp, t, "tp", 1) - tacc))))))), 
                                        "assigning variable Cmetpred");
                        }
                    }
                }
                current_statement_begin__ = 251;
                if (as_bool(logical_eq(n_out, 2))) {
                    current_statement_begin__ = 252;
                    for (int t = 1; t <= lentp; ++t) {
                        current_statement_begin__ = 253;
                        stan::model::assign(CGpred, 
                                    stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                                    (((get_base1(get_base1(G0, s, "G0", 1), 1, "G0", 2) - get_base1(get_base1(gmax, s, "gmax", 1), 1, "gmax", 2)) * stan::math::exp((-(get_base1(ke, 2, "ke", 1)) * get_base1(tp, t, "tp", 1)))) + get_base1(get_base1(gmax, s, "gmax", 1), 1, "gmax", 2)), 
                                    "assigning variable CGpred");
                    }
                }
                current_statement_begin__ = 258;
                for (int t = 1; t <= lentp; ++t) {
                    current_statement_begin__ = 260;
                    stan::model::assign(CGobs_out, 
                                stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(1), stan::model::nil_index_list())), 
                                normal_rng(get_base1(CGpred, t, 1, "CGpred", 1), get_base1(get_base1(sigmaCGpred, s, "sigmaCGpred", 1), 1, "sigmaCGpred", 2), base_rng__), 
                                "assigning variable CGobs_out");
                    current_statement_begin__ = 262;
                    for (int i = 1; i <= n_met; ++i) {
                        current_statement_begin__ = 263;
                        stan::model::assign(Cmet_out, 
                                    stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(i), stan::model::nil_index_list())), 
                                    normal_rng(get_base1(Cmetpred, t, i, "Cmetpred", 1), get_base1(sigmaCmetpred, s, i, "sigmaCmetpred", 1), base_rng__), 
                                    "assigning variable Cmet_out");
                    }
                }
                current_statement_begin__ = 266;
                if (as_bool(logical_eq(n_out, 2))) {
                    current_statement_begin__ = 267;
                    for (int t = 1; t <= lentp; ++t) {
                        current_statement_begin__ = 268;
                        stan::model::assign(CGobs_out, 
                                    stan::model::cons_list(stan::model::index_uni(t), stan::model::cons_list(stan::model::index_uni(2), stan::model::nil_index_list())), 
                                    normal_rng(get_base1(CGpred, t, 2, "CGpred", 1), get_base1(get_base1(sigmaCGpred, s, "sigmaCGpred", 1), 2, "sigmaCGpred", 2), base_rng__), 
                                    "assigning variable CGobs_out");
                    }
                }
            }
            // validate, write generated quantities
            current_statement_begin__ = 173;
            size_t CGobs_out_k_0_max__ = lentp;
            size_t CGobs_out_k_1_max__ = n_out;
            for (size_t k_1__ = 0; k_1__ < CGobs_out_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < CGobs_out_k_0_max__; ++k_0__) {
                    vars__.push_back(CGobs_out[k_0__][k_1__]);
                }
            }
            current_statement_begin__ = 174;
            size_t Cmet_out_k_0_max__ = lentp;
            size_t Cmet_out_k_1_max__ = n_met;
            for (size_t k_1__ = 0; k_1__ < Cmet_out_k_1_max__; ++k_1__) {
                for (size_t k_0__ = 0; k_0__ < Cmet_out_k_0_max__; ++k_0__) {
                    vars__.push_back(Cmet_out[k_0__][k_1__]);
                }
            }
            current_statement_begin__ = 176;
            size_t Cexp_interpol_j_2_max__ = n_exp;
            size_t Cexp_interpol_j_1_max__ = lentp;
            for (size_t j_2__ = 0; j_2__ < Cexp_interpol_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Cexp_interpol_j_1_max__; ++j_1__) {
                    vars__.push_back(Cexp_interpol(j_1__, j_2__));
                }
            }
            current_statement_begin__ = 179;
            check_greater_or_equal(function__, "ku", ku, 0);
            size_t ku_j_1_max__ = n_exp;
            for (size_t j_1__ = 0; j_1__ < ku_j_1_max__; ++j_1__) {
                vars__.push_back(ku(j_1__));
            }
            current_statement_begin__ = 180;
            check_greater_or_equal(function__, "ke", ke, 0);
            size_t ke_j_1_max__ = n_out;
            for (size_t j_1__ = 0; j_1__ < ke_j_1_max__; ++j_1__) {
                vars__.push_back(ke(j_1__));
            }
            current_statement_begin__ = 181;
            check_greater_or_equal(function__, "km", km, 0);
            size_t km_j_1_max__ = n_met;
            for (size_t j_1__ = 0; j_1__ < km_j_1_max__; ++j_1__) {
                vars__.push_back(km(j_1__));
            }
            current_statement_begin__ = 182;
            check_greater_or_equal(function__, "kem", kem, 0);
            size_t kem_j_1_max__ = n_met;
            for (size_t j_1__ = 0; j_1__ < kem_j_1_max__; ++j_1__) {
                vars__.push_back(kem(j_1__));
            }
            current_statement_begin__ = 184;
            size_t U_j_1_max__ = lentp;
            for (size_t j_1__ = 0; j_1__ < U_j_1_max__; ++j_1__) {
                vars__.push_back(U(j_1__));
            }
            current_statement_begin__ = 185;
            size_t R_j_1_max__ = lentp;
            for (size_t j_1__ = 0; j_1__ < R_j_1_max__; ++j_1__) {
                vars__.push_back(R(j_1__));
            }
            current_statement_begin__ = 186;
            size_t D_j_1_max__ = n_met;
            for (size_t j_1__ = 0; j_1__ < D_j_1_max__; ++j_1__) {
                vars__.push_back(D(j_1__));
            }
            current_statement_begin__ = 188;
            size_t CGpred_j_2_max__ = n_out;
            size_t CGpred_j_1_max__ = lentp;
            for (size_t j_2__ = 0; j_2__ < CGpred_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < CGpred_j_1_max__; ++j_1__) {
                    vars__.push_back(CGpred(j_1__, j_2__));
                }
            }
            current_statement_begin__ = 189;
            size_t Cmetpred_j_2_max__ = n_met;
            size_t Cmetpred_j_1_max__ = lentp;
            for (size_t j_2__ = 0; j_2__ < Cmetpred_j_2_max__; ++j_2__) {
                for (size_t j_1__ = 0; j_1__ < Cmetpred_j_1_max__; ++j_1__) {
                    vars__.push_back(Cmetpred(j_1__, j_2__));
                }
            }
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }
    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng, params_r_vec, params_i_vec, vars_vec, include_tparams, include_gqs, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }
    std::string model_name() const {
        return "model_TK_predict";
    }
    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
        size_t CGobs_out_k_0_max__ = lentp;
        size_t CGobs_out_k_1_max__ = n_out;
        for (size_t k_1__ = 0; k_1__ < CGobs_out_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < CGobs_out_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "CGobs_out" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t Cmet_out_k_0_max__ = lentp;
        size_t Cmet_out_k_1_max__ = n_met;
        for (size_t k_1__ = 0; k_1__ < Cmet_out_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < Cmet_out_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Cmet_out" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t Cexp_interpol_j_2_max__ = n_exp;
        size_t Cexp_interpol_j_1_max__ = lentp;
        for (size_t j_2__ = 0; j_2__ < Cexp_interpol_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Cexp_interpol_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Cexp_interpol" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t ku_j_1_max__ = n_exp;
        for (size_t j_1__ = 0; j_1__ < ku_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ku" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ke_j_1_max__ = n_out;
        for (size_t j_1__ = 0; j_1__ < ke_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ke" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t km_j_1_max__ = n_met;
        for (size_t j_1__ = 0; j_1__ < km_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "km" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t kem_j_1_max__ = n_met;
        for (size_t j_1__ = 0; j_1__ < kem_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "kem" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t U_j_1_max__ = lentp;
        for (size_t j_1__ = 0; j_1__ < U_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "U" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t R_j_1_max__ = lentp;
        for (size_t j_1__ = 0; j_1__ < R_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "R" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t D_j_1_max__ = n_met;
        for (size_t j_1__ = 0; j_1__ < D_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "D" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t CGpred_j_2_max__ = n_out;
        size_t CGpred_j_1_max__ = lentp;
        for (size_t j_2__ = 0; j_2__ < CGpred_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < CGpred_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "CGpred" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t Cmetpred_j_2_max__ = n_met;
        size_t Cmetpred_j_1_max__ = lentp;
        for (size_t j_2__ = 0; j_2__ < Cmetpred_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Cmetpred_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Cmetpred" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        if (!include_gqs__ && !include_tparams__) return;
        if (include_tparams__) {
        }
        if (!include_gqs__) return;
        size_t CGobs_out_k_0_max__ = lentp;
        size_t CGobs_out_k_1_max__ = n_out;
        for (size_t k_1__ = 0; k_1__ < CGobs_out_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < CGobs_out_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "CGobs_out" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t Cmet_out_k_0_max__ = lentp;
        size_t Cmet_out_k_1_max__ = n_met;
        for (size_t k_1__ = 0; k_1__ < Cmet_out_k_1_max__; ++k_1__) {
            for (size_t k_0__ = 0; k_0__ < Cmet_out_k_0_max__; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Cmet_out" << '.' << k_0__ + 1 << '.' << k_1__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t Cexp_interpol_j_2_max__ = n_exp;
        size_t Cexp_interpol_j_1_max__ = lentp;
        for (size_t j_2__ = 0; j_2__ < Cexp_interpol_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Cexp_interpol_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Cexp_interpol" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t ku_j_1_max__ = n_exp;
        for (size_t j_1__ = 0; j_1__ < ku_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ku" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t ke_j_1_max__ = n_out;
        for (size_t j_1__ = 0; j_1__ < ke_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ke" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t km_j_1_max__ = n_met;
        for (size_t j_1__ = 0; j_1__ < km_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "km" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t kem_j_1_max__ = n_met;
        for (size_t j_1__ = 0; j_1__ < kem_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "kem" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t U_j_1_max__ = lentp;
        for (size_t j_1__ = 0; j_1__ < U_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "U" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t R_j_1_max__ = lentp;
        for (size_t j_1__ = 0; j_1__ < R_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "R" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t D_j_1_max__ = n_met;
        for (size_t j_1__ = 0; j_1__ < D_j_1_max__; ++j_1__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "D" << '.' << j_1__ + 1;
            param_names__.push_back(param_name_stream__.str());
        }
        size_t CGpred_j_2_max__ = n_out;
        size_t CGpred_j_1_max__ = lentp;
        for (size_t j_2__ = 0; j_2__ < CGpred_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < CGpred_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "CGpred" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
        size_t Cmetpred_j_2_max__ = n_met;
        size_t Cmetpred_j_1_max__ = lentp;
        for (size_t j_2__ = 0; j_2__ < Cmetpred_j_2_max__; ++j_2__) {
            for (size_t j_1__ = 0; j_1__ < Cmetpred_j_1_max__; ++j_1__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "Cmetpred" << '.' << j_1__ + 1 << '.' << j_2__ + 1;
                param_names__.push_back(param_name_stream__.str());
            }
        }
    }
}; // model
}  // namespace
typedef model_TK_predict_namespace::model_TK_predict stan_model;
#ifndef USING_R
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
#endif
#endif
