% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bhl_partsearch.R
\name{bhl_partsearch}
\alias{bhl_partsearch}
\title{Search for parts of books in BHL, such as articles, chapters, or treatments.
Search criteria includes title, container (journal or book title), author,
date of publication, volume, series, and issue.}
\usage{
bhl_partsearch(title = NULL, containerTitle = NULL, author = NULL,
  date = NULL, volume = NULL, series = NULL, issue = NULL,
  as = "table", key = NULL, ...)
}
\arguments{
\item{title}{Title of the work}

\item{containerTitle}{Container title of the work}

\item{author}{Author of the work}

\item{date}{Date of the work}

\item{volume}{Volume of the work}

\item{series}{Series of the work}

\item{issue}{Issue of the work}

\item{as}{(character) Return a list ("list"), json ("json"), xml ("xml"), or parsed table
("table", default). Note that \code{as="table"} can give different data format back
depending on the function - for example, sometimes a data.frame and sometimes a
character vector.}

\item{key}{Your BHL API key, either enter, or loads from your \code{.Renviron} as \code{BHL_KEY}
or from \code{.Rprofile} as \code{bhl_key}.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\description{
To execute a search, you must supply at least a title or author.
}
\details{
The metadata returned by this method includes Part Identifier, Part URL, Item ID,
Page ID for the start page, Genre, Title, Container Title, Publication Details,
Volume, Series, Issue, Date, Page Range, Language, rights information, authors,
keywords, identifiers, pages, and related parts. For more information, see the
"Data Elements" section of this documentation.
}
\examples{
\dontrun{
bhl_partsearch(title='Critical approach to the definition of Darwinian units')
bhl_partsearch(author='Charles Darwin')
}
}

