% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/bhl_titlesearchsimple.R
\name{bhl_titlesearchsimple}
\alias{bhl_titlesearchsimple}
\title{Perform a simple title search.}
\usage{
bhl_titlesearchsimple(title = NA, as = "table", key = NULL, ...)
}
\arguments{
\item{title}{full or partial title for which to search (character)}

\item{as}{(character) Return a list ("list"), json ("json"), xml ("xml"), or parsed table
("table", default). Note that \code{as="table"} can give different data format back
depending on the function - for example, sometimes a data.frame and sometimes a
character vector.}

\item{key}{Your BHL API key, either enter, or loads from your \code{.Renviron} as \code{BHL_KEY}
or from \code{.Rprofile} as \code{bhl_key}.}

\item{...}{Curl options passed on to \code{\link[httr]{GET}}}
}
\description{
The full title (as specified in MARC 245a and MARC 245b library records)
   is searched for the specified string. Basic metadata for all full and
   partial matches is returned.
}
\examples{
\dontrun{
bhl_titlesearchsimple('nematocerous')
bhl_titlesearchsimple('husbandry')
}
}

