% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/legacy-chunk_version.R
\name{LegacyChunkVersion}
\alias{LegacyChunkVersion}
\alias{get_legacy_chunk_version_value}
\alias{get_legacy_chunk_version_data}
\alias{put_legacy_chunk_version_value}
\alias{put_legacy_chunk_version_data}
\title{Read and write legacy chunk version data}
\usage{
get_legacy_chunk_version_value(x, z, dimension, db = default_db())

get_legacy_chunk_version_data(x, z, dimension, db = default_db())

put_legacy_chunk_version_value(value, x, z, dimension, db = default_db())

put_legacy_chunk_version_data(values, x, z, dimension, db = default_db())
}
\arguments{
\item{x, z, dimension}{Chunk coordinates to extract data from.
\code{x} can also be a character vector of db keys.}

\item{db}{A bedrockdb object.}

\item{value}{An integer}

\item{values}{A (named) vector of LegacyChunkVersion values. If \code{x} is
missing, the names of \code{values} will be taken as the keys.}
}
\value{
\code{get_legacy_chunk_version_value()} returns a LegacyChunkVersion data
value. \code{get_legacy_chunk_version_data()} returns a named vector of
LegacyChunkVersion data values.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#superseded}{\figure{lifecycle-superseded.svg}{options: alt='[Superseded]'}}}{\strong{[Superseded]}}

LegacyChunkVersion data (tag 118) stores the chunk version number for a
chunk. In Minecraft version 1.16.100, chunk version data was moved from tag
118 to tag 44.
\itemize{
\item \code{get_legacy_chunk_version_value()} and \code{get_legacy_chunk_version_data()}
load LegacyChunkVersion data from \code{db}. \code{get_legacy_chunk_version_value()}
loads data for a single chunk, and \code{get_legacy_chunk_version_data()} loads
data for multiple chunks.
\item \code{put_legacy_chunk_version_value()} and \code{put_legacy_chunk_version_data()}
store LegacyChunkVersion data into \code{db}.
}
}
\seealso{
ChunkVersion
}
\keyword{internal}
