% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rbcb_get_market_expectations.R
\name{get_top5s_monthly_market_expectations}
\alias{get_top5s_monthly_market_expectations}
\title{Get monthly market expectations from top 5 providers}
\usage{
get_top5s_monthly_market_expectations(
  indic = NULL,
  start_date = NULL,
  end_date = NULL,
  ...
)
}
\arguments{
\item{indic}{a character vector with economic indicators names.
They are case sensitive and don't forget the accents.}

\item{start_date}{series initial date.
Accepts ISO character formated date and \code{Date}.}

\item{end_date}{series final date.
Accepts ISO character formated date and \code{Date}.}

\item{...}{additional parameters to be passed to the API

\code{indic} argument must be one of indicators listed in Details.
Respecting the case, blank spaces and accents.

The \code{...} is to be used with API's parameters. \code{$top} to specify
the maximum number of rows to be returned, this returns the \code{$top} rows,
in chronological order. There is also \code{$skip} to ignore the first rows.}
}
\value{
A \code{data.frame} with the requested data.
}
\description{
Statistics of monthly expectations for top 5 indicators.
All statistics are computed based on expectations provided by many financial
institutions in Brazil: banks, funds, risk managers, so on and so forth.
These expections and its statistics are used to build the FOCUS Report weekly
released by the Brazilian Central Bank.
}
\details{
There are inflation's expectations available for the following indicators:

\itemize{
\item Câmbio
\item IGP-DI
\item IGP-M
\item IPCA
\item Selic
}

Check <https://olinda.bcb.gov.br/olinda/servico/Expectativas/versao/v1/documentacao#ExpectativasMercadoTop5Mensais>
for more details
}
\examples{
\dontrun{
indic <- "IPCA"
end_date <- "2018-06-22"
x <- get_top5s_monthly_market_expectations(indic, end_date = end_date, `$top` = 10)

# return all indicators for the specified date range
start_date <- "2021-01-01"
x <- get_top5s_monthly_market_expectations(start_date = start_date, `$top` = 20)
}

}
