% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{biasBound_condExpectation}
\alias{biasBound_condExpectation}
\title{Bias bound approach for conditional expectation estimation}
\usage{
biasBound_condExpectation(
  Y,
  X,
  x = NULL,
  h = 0.09,
  alpha = 0.05,
  est_Ar = NULL,
  resol = 100,
  xi_lb = NULL,
  xi_ub = NULL,
  methods_get_xi = "Schennach",
  if_plot_ft = FALSE,
  ora_Ar = NULL,
  if_plot_conditional_mean = TRUE,
  kernel.fun = "Schennach2004",
  if_approx_kernel = TRUE,
  kernel.resol = 1000
)
}
\arguments{
\item{Y}{A numerical vector of sample data.}

\item{X}{A numerical vector of sample data.}

\item{x}{Optional. A scalar or range of points where the density is estimated. If NULL, a range is automatically generated.}

\item{h}{A scalar bandwidth parameter.}

\item{alpha}{Confidence level for intervals. Default is 0.05.}

\item{est_Ar}{Optional list of estimates for A and r. If NULL, they are computed using \code{get_est_Ar()}.}

\item{resol}{Resolution for the estimation range. Default is 100.}

\item{xi_lb}{Optional. Lower bound for the interval of Fourier Transform frequency xi. Used for determining the range over which A and r is estimated. If NULL, it is automatically determined based on the methods_get_xi.}

\item{xi_ub}{Optional. Upper bound for the interval of Fourier Transform frequency xi. Similar to xi_lb, it defines the upper range for A and r estimation. If NULL, the upper bound is determined based on the methods_get_xi.}

\item{methods_get_xi}{A string specifying the method to automatically determine the xi interval if xi_lb and xi_ub are NULL. Options are "Schennach" and "Schennach_loose". If "Schennach" the range is selected based on the Theorem 2 in Schennach2020, if "Schennach_loose", it is defined by the initial interval given in Theorem 2 without selecting the xi_n.}

\item{if_plot_ft}{Logical. If TRUE, plots the Fourier transform.}

\item{ora_Ar}{Optional list of oracle values for A and r.}

\item{if_plot_conditional_mean}{Logical. If TRUE, plots the conditional mean estimation.}

\item{kernel.fun}{A string specifying the kernel function to be used. Options are "Schennach2004", "sinc", "normal", "epanechnikov".}

\item{if_approx_kernel}{Logical. If TRUE, uses approximations for the kernel function.}

\item{kernel.resol}{The resolution for kernel function approximation. See \code{\link{fun_approx}}.}
}
\value{
A list containing various outputs including estimated values, plots, and intervals.
}
\description{
Estimates the density at a given point or across a range, and provides visualization options for density,
bias, and confidence intervals.
}
\examples{
\donttest{
# Example 1: point estimation of conditional expectation of Y on X
biasBound_condExpectation(
 Y = sample_data$Y,
 X = sample_data$X,
 x = 1,
 h = 0.09,
 kernel.fun = "Schennach2004"
)

# Example 2: conditional expectation of Y on X with manually selected range of xi
# biasBound_condExpectation(
# Y = sample_data$Y,
#  X = sample_data$X,
#  h = 0.09,
#  xi_lb = 1,
#  xi_ub = 12,
#  kernel.fun = "Schennach2004"
# )
}
}
