% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scraper-company.R
\name{company_info_get}
\alias{company_info_get}
\title{Gets information about the company}
\usage{
company_info_get(code, cache_folder = cachedir(), do_cache = TRUE)
}
\arguments{
\item{code}{Represents the company, can be the stock symbol, like \code{PETR4} or
the first four characters \code{PETR}}

\item{cache_folder}{Location of cache folder (default = cachedir())}

\item{do_cache}{Whether to use cache or not (default = TRUE)}
}
\value{
data.frame with company information
}
\description{
Gets informations like sector, subsector, segment, total number of shares
and many more.
}
\details{
The \code{code} parameter can be the stock symbol, but the returned data refers
to the company, always.
}
\examples{
\dontrun{
company_info_get(c("PETR", "VALE", "MGLU"))
}

}
