% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_png.R
\name{save_png}
\alias{save_png}
\title{Save PNG}
\usage{
save_png(hillshade, filename, rotate = 0, asp = 1)
}
\arguments{
\item{hillshade}{Array (or matrix) of hillshade to be written.}

\item{filename}{String with the filename. If `.png` is not at the end of the string, it will be appended automatically.}

\item{rotate}{Default 0. Rotates the output. Possible values: 0, 90, 180, 270.}

\item{asp}{Default `1`. Aspect ratio of the resulting plot. Use `asp = 1/cospi(mean_latitude/180)` to rescale
lat/long at higher latitudes to the correct the aspect ratio.}
}
\description{
Writes the hillshaded map to file.
}
\examples{
filename_map = tempfile()

#Save the map into `filename_map`
montereybay \%>\%
 sphere_shade() \%>\%
 save_png(filename_map)
 
#Rotate the map 180 degrees:

montereybay \%>\%
 sphere_shade() \%>\%
 save_png(filename_map,rotate=180)
}
