% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/abs-cat-functions.R
\name{abs_cat_stats}
\alias{abs_cat_stats}
\title{Get ABS catalogue series data}
\usage{
abs_cat_stats(cat_no, tables = "All", releases = "Latest",
  types = "tss")
}
\arguments{
\item{cat_no}{Character vector specifying one or more ABS collections or catalogue numbers to
download.}

\item{tables}{A character vector of regular expressions denoting tables to download. The default
('All') downloads all time series spreadsheet tables for each specified catalogue. Use a list
to specify different table sets for each specified ABS catalogue number.}

\item{releases}{Date or character string object specifying the month and year denoting which
release to download. Default is "Latest", which downloads the latest available data. See
examples for further details.}

\item{types}{One of either 'tss' -- ABS time series spreadsheet (the default) or 'css' -- ABS
data cube (cross-section spreadsheet).}
}
\value{
data frame in long format
}
\description{
TBC
}
\examples{
  \donttest{
    ## Download quarterly Australian National Accounts, Tables 1 & 2 
    ana_q <- abs_cat_stats("5206.0", tables=c("Table 1\\\\W+", "Table 2\\\\W+"));

    ## Download December 2017 Australian National Accounts, Table 1
    ana_q_2017q4 <- abs_cat_stats("5206.0", tables="Table 1\\\\W+", release="Dec 2017");
  }
}
\author{
David Mitchell <david.pk.mitchell@gmail.com>
}
