% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computeESS.R
\name{computeESS}
\alias{computeESS}
\title{Compute the ESS for the MCMC samples}
\usage{
computeESS(mcmc, p)
}
\arguments{
\item{mcmc}{Posterior distribution object. Same as output from 'readMCMC' function.}

\item{p}{Number of evolutionary rate matrix regimes fitted to the phylogenetic tree.}
}
\value{
A list object with the ESS value for the root, evolutionary rates, and evolutionary correlations among the traits.
}
\description{
Computes the Effective Sample Size (ESS) for the parameters of the model from the MCMC samples.
}
\details{
Function uses 'coda' function 'effectiveSize' to compute the ESS for each of the parameters of the model separatelly. Values for the ESS is too low indicates poor mixing for the parameter of the model.
}
\examples{
\donttest{
library( ratematrix )
data( centrarchidae )
## Run multiple MCMC chains.
handle.list <- lapply(1:4, function(x) ratematrixMCMC(data=centrarchidae$data
                      , phy=centrarchidae$phy.map, gen=10000, dir=tempdir()) )
## Read all to a list
posterior.list <- lapply(handle.list, function(x) readMCMC(handle = x, burn = 0.5))
## Merge all posteriors.
merged.four <- mergePosterior(posterior.list)
## Compute the ESS for the merged posterior:
ess <- computeESS(mcmc=merged.four, p=2)
}
}
\author{
Daniel Caetano and Luke Harmon
}
