# Author: Robert J. Hijmans, r.hijmans@gmail.com
# Date : June 2008
# Version 0.9
# Licence GPL v3


.rasterFromGDAL <- function(filename, band, type, fixGeoref=FALSE, silent=TRUE) {	
	if (! .requireRgdal() ) { stop('package rgdal is not available') }

	# suppressing the geoTransform warning...
	w <- getOption('warn')
	on.exit(options('warn'= w))
	options('warn'=-1) 
	
	if (packageVersion('rgdal') > '0.6-28') {
		gdalinfo <- do.call(GDALinfo, list(filename, silent=silent, returnRAT=TRUE))
	} else {
		gdalinfo <- do.call(GDALinfo, list(filename, silent=silent))
	}
		
	options('warn'= w) 

	nc <- as.integer(gdalinfo[["columns"]])
	nr <- as.integer(gdalinfo[["rows"]])
	
	xn <- gdalinfo[["ll.x"]]
	xn <- round(xn, digits=9)

	xx <- xn + gdalinfo[["res.x"]] * nc
	xx <- round(xx, digits=9)
	
	yn <- gdalinfo[["ll.y"]]
	yn <- round(yn, digits=9)
	yx <- yn + gdalinfo[["res.y"]] * nr
	yx <- round(yx, digits=9)

	#fixGeo <- FALSE
	#3v <- attr(gdalinfo, 'mdata')
	#if (! is.null(v) ) {
	#	for (i in 1:length(v)) {
	#		if (v[i] == "AREA_OR_POINT=Area") {
	#			break
	#		} else if (v[i] == "AREA_OR_POINT=Point") {
	#			fixGeo <- TRUE
	#			break
	#		}
	#	}
	#}
	
	if (type == 'RasterBrick') {
		x <- brick(ncols=nc, nrows=nr, xmn=xn, ymn=yn, xmx=xx, ymx=yx, crs="")
		x@data@nlayers <- as.integer(gdalinfo[["bands"]])
		x@file@nbands <- as.integer(gdalinfo[["bands"]])
	} else {
		x <- raster(ncols=nc, nrows=nr, xmn=xn, ymn=yn, xmx=xx, ymx=yx, crs="")
		x@file@nbands <- as.integer(gdalinfo[["bands"]])
		band <- as.integer(band)
		if ( band > nbands(x) ) {
			warning("band too high. Set to nbands")
			band <- nbands(x) 
		}
		if ( band < 1) { 
			warning("band too low. Set to 1")
			band <- 1 
		}
		x@data@band <- as.integer(band)
		
		gd <- GDAL.open(filename)
		ct <- getColorTable( gd )
		if (! is.null(ct)) { x@legend@colortable <- ct }
		GDAL.close(gd)
	}

	
	if (fixGeoref) {
		xx <- x
		nrow(xx) <- nrow(xx) - 1
		ncol(xx) <- ncol(xx) - 1
		rs <- res(xx)
		xmin(x) <- xmin(x) - 0.5 * rs[1]
		xmax(x) <- xmax(x) + 0.5 * rs[1]
		ymin(x) <- ymin(x) - 0.5 * rs[2]
		ymax(x) <- ymax(x) + 0.5 * rs[2]
	}
	
	shortname <- gsub(" ", "_", ext(basename(filename), ""))
	x <- .enforceGoodLayerNames(x, shortname)
	x@file@name <- filename
	
	x@file@driver <- 'gdal' 
	projection(x) <- attr(gdalinfo, "projection")
	x@data@fromdisk <- TRUE
	
	
	datatype <- "FLT4S"
	minv = 	rep(Inf, nlayers(x))
	maxv = 	rep(-Inf, nlayers(x))
	if (type == 'RasterBrick') {
		try ( datatype <- .getRasterDType ( as.character( attr(gdalinfo, 'df')[1, 1]) ), silent=TRUE )
		try ( minv <- as.numeric( attr(gdalinfo, 'df')[, 2] ) , silent=TRUE ) 
		try ( maxv <- as.numeric( attr(gdalinfo, 'df')[, 3] ) , silent=TRUE ) 
		minv[minv == -4294967295] <- Inf
		maxv[maxv == 4294967295] <- -Inf
		minv <- as.vector(as.matrix(minv))
		maxv <- as.vector(as.matrix(maxv))
		if ( is.finite(minv) && is.finite(maxv) ) x@data@haveminmax <- TRUE 
		
	} else {
		try ( datatype <- .getRasterDType ( as.character( attr(gdalinfo, 'df')[band, 1]) ), silent=TRUE )
		minmax <- c(Inf, -Inf)
		try( minmax <- attr(gdalinfo, 'df')[band, 2:3] , silent=TRUE )
		if (all( minmax == c(-4294967295, 4294967295))) {
			minmax <- c(Inf, -Inf)
		}
		minv <- as.vector(as.matrix(minmax[1]))
		maxv <- as.vector(as.matrix(minmax[2]))
		if ( is.finite(minv) & is.finite(maxv) ) x@data@haveminmax <- TRUE 
	
	}
	dataType(x) <- datatype
	x@data@min <- minv
	x@data@max <- maxv

	RAT <- attr(gdalinfo, 'RATlist')
	if (! is.null(RAT)) {
		att <- vector(length=nlayers(x), mode='list')
		for (i in 1:length(RAT)) {
			if (! is.null(RAT[[i]])) {
				att[[i]] <- data.frame(RAT[[i]], stringsAsFactors=FALSE)
				
				if (! silent) {
					usage <- attr(RAT[[i]], 'GFT_usage')
					if (! isTRUE(usage[1] == "GFU_MinMax")) {
						warning('usage[1] != GFU_MinMax')
						# process min/max
					} else {
						if (! isTRUE(usage[2] == "GFU_PixelCount")) {
							warning('usage[2] != GFU_PixelCount')
						}
					}
				}
				x@data@isfactor[i] <- TRUE 
			}
		}
		x@data@attributes <- att
	}
	
#oblique.x   0  #oblique.y   0 
	return(x)
}

