% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aqs_user.R
\name{set_aqs_user}
\alias{set_aqs_user}
\alias{get_aqs_user}
\alias{get_aqs_email}
\alias{get_aqs_key}
\title{Set your AQS API credentials}
\usage{
set_aqs_user(email, key)

get_aqs_user()

get_aqs_email()

get_aqs_key()
}
\arguments{
\item{email}{A string specifying your registered email address}

\item{key}{A string specifying your API key}
}
\value{
No return value, called to set environmental variables
}
\description{
Set your registered email and key as environmental variables for the current
session. Please sign up first using \link{aqs_signup} if you haven't set up an
account on the AQS API. If you want to set your email and key permanently,
please add the following lines in your .Renviron file (see
\link[usethis:edit]{usethis::edit_r_environ}):
\itemize{
\item AQS_EMAIL = YOUR REGISTERED EMAIL
\item AQS_KEY = YOUR API KEY
}
}
\details{
\link{set_aqs_user} sets your API credentials for the current session.
\link{get_aqs_user}, \link{get_aqs_email}, and \link{get_aqs_key} are helper functions to
display saved user values.
}
\examples{
## Please use your registered email and key
set_aqs_user(email = "your@registered.email", key = "your_api_key")

## Show your API credentials
get_aqs_user() # return list(email, key)
get_aqs_email() # return email
get_aqs_key() # return key

}
\seealso{
See \link{aqs_signup} to create an account for the AQS API
}
