% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isCompatible.R
\name{isCompatible}
\alias{isCompatible}
\title{Test whether a ranking is compatible with a set of intervals}
\usage{
isCompatible(intervals, ranking)
}
\arguments{
\item{intervals}{data frame (see \link{generateIntervals} for
the required format)}

\item{ranking}{permutation of \code{1:nrow(intervals)}}
}
\value{
TRUE if the ranking is compatible and FALSE otherwise
}
\description{
A ranking is compatible with a set of intervals if we can pick a point from
each interval such that the ranking of those points is the ranking in
question.
}
\details{
See section 4.1 of Rising (2021).
}
\examples{
left <- 0:2 * 0.5 + 1
right <- left + 0.75
intervals <- data.frame(left = left, right = right)
isCompatible(intervals, 1:3)
isCompatible(intervals, c(3, 2, 1))
}
\references{
Rising, Justin (2021).  \emph{Uncertainty in Ranking}.  arXiv:2107.03459.
}
