% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rangemap_explore.R
\name{rangemap_explore}
\alias{rangemap_explore}
\title{Exploring occurrences before creating range maps}
\usage{
rangemap_explore(occurrences, show_countries = FALSE, graphic_device = FALSE,
                 xlim = NULL, ylim = NULL)
}
\arguments{
\item{occurrences}{a data.frame containing geographic coordinates of species
occurrences, columns must be: Species, Longitude, and Latitude. Geographic
coordinates must be in decimal degrees  (WGS84).}

\item{show_countries}{(logical) if \code{TRUE}, ISO 3 country codes will label
country polygons. Default = \code{FALSE}.}

\item{graphic_device}{(logical) if \code{TRUE}, a new graphic device is opened
to plot the figure. Default = \code{FALSE}.}

\item{xlim}{(numeric) vector of length = 2 with the limits in longitude for
the plot. The default, NULL, uses the limits of countries with
\code{occurrences}.}

\item{ylim}{(numeric) vector of length = 2 with the limits in latitude for
the plot. The default, NULL, uses the limits of countries with
\code{occurrences}.}
}
\value{
A simple figure of species occurrences in a geographical context.
}
\description{
rangemap_explore generates simple figures to visualize species
occurrence data in the geography.
}
\details{
Base map of countries of the world is a SpatialPolygonsDataFrame downloaded from
the Natural Earth database (scale = 50).
}
\examples{
# getting the data
data("occ_f", package = "rangemap")

# simple figure of the species occurrence data
rangemap_explore(occurrences = occ_f, show_countries = TRUE)
}
