test_that("printing with and without resolved packages", {
    rang_mixture <- readRDS("../testdata/rang_mixture.RDS")
    rang_ok <- readRDS("../testdata/rang_ok.RDS")
    rang_unresolved <- readRDS("../testdata/rang_unresolved.RDS")
    rang_output <- capture_output(print(rang_ok$ranglets[[1]]))
    expect_equal(rang_output, "The latest version of `LDAvis` [cran] at 2023-01-01 was 0.3.2, which has 2 unique dependencies (2 with no dependencies.)")
    rang_ok_output <- capture_output(print(rang_ok))
    expect_true(grepl("^resolved: 1 package\\(s\\). Unresolved package\\(s\\): 0", rang_ok_output))
    rang_mixture_output <- capture_output(print(rang_mixture))
    expect_true(grepl("^resolved: 1 package\\(s\\). Unresolved package\\(s\\): 1", rang_mixture_output))
    rang_unresolved_output <- capture_output(print(rang_unresolved))
    expect_true(grepl("^resolved: 0 package\\(s\\). Unresolved package\\(s\\): 1", rang_unresolved_output))
    expect_false(grepl("The latest version", rang_unresolved_output))
})

test_that("all_pkgs", {
    rang_mixture <- readRDS("../testdata/rang_mixture.RDS")
    output1 <- capture_output(print(rang_mixture, all_pkgs = FALSE))
    output2 <- capture_output(print(rang_mixture, all_pkgs = TRUE))
    expect_true(output1 == output2)
    rang_6 <- readRDS("../testdata/rang_6.RDS")
    output1 <- capture_output(print(rang_6, all_pkgs = FALSE))
    output2 <- capture_output(print(rang_6, all_pkgs = TRUE))
    expect_false(output1 == output2)
    expect_true(grepl("First 5 packages", output1))
    expect_false(grepl("First 5 packages", output2))
})
