% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/rand_names.R
\name{rand_names}
\alias{rand_names}
\title{Random name generator}
\usage{
rand_names(n = 1, seed = NULL, gender = NULL, nationality = NULL,
  key = NULL)
}
\arguments{
\item{n}{Number of names required. Free users get 100 max and registered RandomAPI users get 500 max.
Register for a free API key here: \url{https://randomapi.com}}

\item{seed}{A random string to ensure same results}

\item{gender}{male or female}

\item{nationality}{Currently only takes \code{US} or \code{GB}}

\item{key}{An API key for more results per request (500 max for registered RandomAPI users).}
}
\description{
This function grabs a list of random names from the random user generator
}
\details{
The return object contains the following fields: seed,  user.password,
user.sha256, user.cell, user.name.title, user.location.city,
user.picture.medium, user.gender, user.salt, user.registered, user.SSN,
user.name.first, user.location.state, user.picture.thumbnail,  user.email,
user.md5, user.dob, user.version, user.name.last, user.location.zip,
user.NINO,  user.username, user.sha1, user.phone, user.nationality,
user.location.street,  user.picture.large.
}
\examples{
library(dplyr)
5 \%>\%
rand_names \%>\%
select(first = user.name.first, last = user.name.last)

 # x <- 5 \%>\%
 #   rand_names \%>\%
 # filter(user.gender == "female") \%>\%
 #  select(user.name.first, user.name.last)
}

