/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.dynamic.utils;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Sets;
import eu.amidst.core.datastream.Attribute;
import eu.amidst.core.datastream.Attributes;
import eu.amidst.core.datastream.DataStream;
import eu.amidst.core.io.DataStreamWriter;
import eu.amidst.core.utils.LocalRandomGenerator;
import eu.amidst.core.variables.HashMapAssignment;
import eu.amidst.core.variables.StateSpaceType;
import eu.amidst.core.variables.Variable;
import eu.amidst.core.variables.stateSpaceTypes.RealStateSpace;
import eu.amidst.dynamic.datastream.DynamicDataInstance;
import eu.amidst.dynamic.models.DynamicBayesianNetwork;
import eu.amidst.dynamic.utils.DynamicBayesianNetworkGenerator;
import eu.amidst.dynamic.utils.Utils;
import eu.amidst.dynamic.variables.DynamicAssignment;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class DynamicBayesianNetworkSampler {
    private DynamicBayesianNetwork network;
    private List<Variable> causalOrderTime0;
    private List<Variable> causalOrderTimeT;
    private int seed = 0;
    private Map<Variable, Boolean> hiddenVars = new HashMap<Variable, Boolean>();
    private Random random = new Random(this.seed);
    private Map<Variable, Double> marNoise = new HashMap<Variable, Double>();

    public DynamicBayesianNetworkSampler(DynamicBayesianNetwork network1) {
        this.network = network1;
        this.causalOrderTime0 = Utils.getCausalOrderTime0(this.network.getDynamicDAG());
        this.causalOrderTimeT = Utils.getCausalOrderTimeT(this.network.getDynamicDAG());
    }

    public void setHiddenVar(Variable var) {
        if (var.isInterfaceVariable()) {
            throw new IllegalArgumentException();
        }
        this.hiddenVars.put(var, true);
    }

    public void setMARVar(Variable var, double noiseProb) {
        if (var.isInterfaceVariable()) {
            throw new IllegalArgumentException();
        }
        this.marNoise.put(var, noiseProb);
    }

    private HashMapAssignment filter(HashMapAssignment assignment) {
        this.hiddenVars.keySet().stream().forEach(var -> assignment.setValue((Variable)var, eu.amidst.core.utils.Utils.missingValue()));
        this.marNoise.entrySet().forEach(e -> {
            if (this.random.nextDouble() < (Double)e.getValue()) {
                assignment.setValue((Variable)e.getKey(), eu.amidst.core.utils.Utils.missingValue());
            }
        });
        return assignment;
    }

    private Stream<DynamicAssignment> getSampleStream(int nSequences, int sequenceLength) {
        LocalRandomGenerator randomGenerator = new LocalRandomGenerator(this.seed);
        return IntStream.range(0, nSequences).mapToObj(Integer::new).flatMap(i -> this.sample(this.network, this.causalOrderTime0, this.causalOrderTimeT, randomGenerator.current(), (int)i, sequenceLength));
    }

    public void setSeed(int seed) {
        this.seed = seed;
        this.random = new Random(seed);
    }

    public DataStream<DynamicDataInstance> sampleToDataBase(int nSequences, int sequenceLength) {
        this.random = new Random(this.seed);
        return new TemporalDataStream(this, nSequences, sequenceLength);
    }

    private Stream<DynamicDataInstance> sample(DynamicBayesianNetwork network, List<Variable> causalOrderTime0, List<Variable> causalOrderTimeT, Random random, int sequenceID, int sequenceLength) {
        HashMapAssignment[] data = new HashMapAssignment[2];
        return IntStream.range(0, sequenceLength).mapToObj(k -> {
            if (k == 0) {
                HashMapAssignment dataPresent = new HashMapAssignment(network.getNumberOfVars());
                for (Variable var : causalOrderTime0) {
                    double sampledValue = network.getConditionalDistributionsTime0().get(var.getVarID()).getUnivariateDistribution(dataPresent).sample(random);
                    dataPresent.setValue(var, sampledValue);
                }
                data[0] = this.replicateOnPast(dataPresent);
                data[1] = this.filter(dataPresent);
                return new DynamicDataInstanceImpl(network, null, data[1], sequenceID, 0);
            }
            HashMapAssignment dataPresent = new HashMapAssignment(network.getNumberOfVars());
            DynamicDataInstanceImpl d = new DynamicDataInstanceImpl(network, data[0], dataPresent, sequenceID, k);
            for (Variable var : causalOrderTimeT) {
                double sampledValue = network.getConditionalDistributionsTimeT().get(var.getVarID()).getUnivariateDistribution(d).sample(random);
                dataPresent.setValue(var, sampledValue);
            }
            data[0] = this.replicateOnPast(dataPresent);
            dataPresent = this.filter(dataPresent);
            d = new DynamicDataInstanceImpl(network, this.replicateOnPast(data[1]), dataPresent, sequenceID, k);
            data[1] = this.filter(dataPresent);
            return d;
        });
    }

    private HashMapAssignment replicateOnPast(HashMapAssignment dataPresent) {
        HashMapAssignment dataPast = new HashMapAssignment(this.network.getNumberOfVars());
        for (Variable var : this.network.getDynamicVariables().getListOfDynamicVariables()) {
            dataPast.setValue(this.network.getDynamicVariables().getInterfaceVariable(var), dataPresent.getValue(var));
        }
        return dataPast;
    }

    public static void main(String[] args) throws Exception {
        Stopwatch watch = Stopwatch.createStarted();
        DynamicBayesianNetworkGenerator dbnGenerator = new DynamicBayesianNetworkGenerator();
        DynamicBayesianNetworkGenerator.setNumberOfContinuousVars(0);
        DynamicBayesianNetworkGenerator.setNumberOfDiscreteVars(3);
        DynamicBayesianNetworkGenerator.setNumberOfStates(2);
        DynamicBayesianNetwork network = DynamicBayesianNetworkGenerator.generateDynamicNaiveBayes(new Random(0L), 2, true);
        DynamicBayesianNetworkSampler sampler = new DynamicBayesianNetworkSampler(network);
        sampler.setSeed(0);
        DataStream<DynamicDataInstance> dataStream = sampler.sampleToDataBase(3, 2);
        DataStreamWriter.writeDataToFile(dataStream, "./datasets/simulated/dnb-samples.arff");
        System.out.println(watch.stop());
        for (DynamicAssignment dynamicAssignment : sampler.sampleToDataBase(3, 2)) {
            System.out.println("\n Sequence ID" + dynamicAssignment.getSequenceID());
            System.out.println("\n Time ID" + dynamicAssignment.getTimeID());
            System.out.println(dynamicAssignment.outputString());
        }
    }

    static class DynamicDataInstanceImpl
    implements DynamicDataInstance,
    Serializable {
        DynamicBayesianNetwork dbn;
        private HashMapAssignment dataPresent;
        private HashMapAssignment dataPast;
        private long sequenceID;
        private long timeID;

        public DynamicDataInstanceImpl(DynamicBayesianNetwork dbn_, HashMapAssignment dataPast1, HashMapAssignment dataPresent1, int sequenceID1, int timeID1) {
            this.dbn = dbn_;
            this.dataPresent = dataPresent1;
            this.dataPast = dataPast1;
            this.sequenceID = sequenceID1;
            this.timeID = timeID1;
        }

        @Override
        public long getSequenceID() {
            return this.sequenceID;
        }

        @Override
        public long getTimeID() {
            return this.timeID;
        }

        @Override
        public double getValue(Variable var) {
            if (var.isInterfaceVariable()) {
                return this.dataPast.getValue(var);
            }
            return this.dataPresent.getValue(var);
        }

        @Override
        public void setValue(Variable var, double val) {
            if (var.isInterfaceVariable()) {
                this.dataPast.setValue(var, val);
            } else {
                this.dataPresent.setValue(var, val);
            }
        }

        @Override
        public Attributes getAttributes() {
            return null;
        }

        @Override
        public double[] toArray() {
            throw new UnsupportedOperationException("Method not currently supported for (HashMap)Assigment objects");
        }

        @Override
        public Set<Variable> getVariables() {
            return Sets.union(this.dataPresent.getVariables(), this.dataPast.getVariables());
        }

        @Override
        public double getValue(Attribute att, boolean present) {
            if (att.getIndex() == 0) {
                return this.sequenceID;
            }
            if (att.getIndex() == 1) {
                return this.timeID;
            }
            return this.getValue(this.dbn.getDynamicVariables().getVariableById(att.getIndex() - 2));
        }

        @Override
        public void setValue(Attribute att, double val, boolean present) {
            if (att.getIndex() == 0) {
                this.sequenceID = (int)val;
            } else if (att.getIndex() == 1) {
                this.timeID = (int)val;
            } else {
                this.setValue(this.dbn.getDynamicVariables().getVariableById(att.getIndex() - 2), val);
            }
        }
    }

    static class TemporalDataStream
    implements DataStream {
        Attributes atts;
        DynamicBayesianNetworkSampler sampler;
        int sequenceLength;
        int nSequences;

        TemporalDataStream(DynamicBayesianNetworkSampler sampler1, int nSequences1, int sequenceLength1) {
            this.sampler = sampler1;
            this.nSequences = nSequences1;
            this.sequenceLength = sequenceLength1;
            ArrayList<Attribute> list = new ArrayList<Attribute>();
            list.add(new Attribute(0, "SEQUENCE_ID", new RealStateSpace()));
            list.add(new Attribute(1, "TIME_ID", new RealStateSpace()));
            list.addAll(this.sampler.network.getDynamicVariables().getListOfDynamicVariables().stream().map((? super T var) -> new Attribute(var.getVarID() + 2, var.getName(), (StateSpaceType)var.getStateSpaceType())).collect(Collectors.toList()));
            this.atts = new Attributes(list);
        }

        @Override
        public Attributes getAttributes() {
            return this.atts;
        }

        public Stream<DynamicDataInstance> stream() {
            return this.sampler.getSampleStream(this.nSequences, this.sequenceLength).map((? super T e) -> (DynamicDataInstanceImpl)e);
        }

        @Override
        public void close() {
        }

        @Override
        public boolean isRestartable() {
            return false;
        }

        @Override
        public void restart() {
        }
    }
}

