/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.variables;

import eu.amidst.core.datastream.Attribute;
import eu.amidst.core.distribution.ConditionalDistribution;
import eu.amidst.core.distribution.UnivariateDistribution;
import eu.amidst.core.variables.DistributionType;
import eu.amidst.core.variables.DistributionTypeEnum;
import eu.amidst.core.variables.StateSpaceType;
import eu.amidst.core.variables.StateSpaceTypeEnum;
import eu.amidst.core.variables.VariableBuilder;
import java.util.List;

public interface Variable {
    public String getName();

    public int getVarID();

    public boolean isObservable();

    public <E extends StateSpaceType> E getStateSpaceType();

    default public StateSpaceTypeEnum getStateSpaceTypeEnum() {
        return ((StateSpaceType)this.getStateSpaceType()).getStateSpaceTypeEnum();
    }

    public int getNumberOfStates();

    public <E extends DistributionType> E getDistributionType();

    public DistributionTypeEnum getDistributionTypeEnum();

    public boolean isInterfaceVariable();

    public boolean isDynamicVariable();

    public boolean isParameterVariable();

    default public Variable getInterfaceVariable() {
        throw new UnsupportedOperationException("This type of variable cannot have an interface variable");
    }

    public Attribute getAttribute();

    default public <E extends UnivariateDistribution> E newUnivariateDistribution() {
        return ((DistributionType)this.getDistributionType()).newUnivariateDistribution();
    }

    default public <E extends ConditionalDistribution> E newConditionalDistribution(List<Variable> parents) {
        return ((DistributionType)this.getDistributionType()).newConditionalDistribution(parents);
    }

    public VariableBuilder getVariableBuilder();

    public int hashCode();

    public boolean equals(Object var1);

    default public boolean isNormal() {
        return this.getDistributionTypeEnum().compareTo(DistributionTypeEnum.NORMAL) == 0;
    }

    default public boolean isMultinomial() {
        return this.getDistributionTypeEnum().compareTo(DistributionTypeEnum.MULTINOMIAL) == 0;
    }

    default public boolean isSparseMultinomial() {
        return this.getDistributionTypeEnum().compareTo(DistributionTypeEnum.SPARSE_MULTINOMIAL) == 0;
    }

    default public boolean isMultinomialLogistic() {
        return this.getDistributionTypeEnum().compareTo(DistributionTypeEnum.MULTINOMIAL_LOGISTIC) == 0;
    }

    default public boolean isInverseGammaParameter() {
        return this.getDistributionTypeEnum().compareTo(DistributionTypeEnum.INV_GAMMA_PARAMETER) == 0;
    }

    default public boolean isGammaParameter() {
        return this.getDistributionTypeEnum().compareTo(DistributionTypeEnum.GAMMA_PARAMETER) == 0;
    }

    default public boolean isNormalGammaParameter() {
        return this.getDistributionTypeEnum().compareTo(DistributionTypeEnum.NORMAL_GAMMA_PARAMETER) == 0;
    }

    default public boolean isDirichletParameter() {
        return this.getDistributionTypeEnum().compareTo(DistributionTypeEnum.DIRICHLET_PARAMETER) == 0;
    }

    default public boolean isSparseDirichletParameter() {
        return this.getDistributionTypeEnum().compareTo(DistributionTypeEnum.SPARSE_DIRICHLET_PARAMETER) == 0;
    }

    default public boolean isNormalParameter() {
        return this.getDistributionTypeEnum().compareTo(DistributionTypeEnum.NORMAL_PARAMETER) == 0;
    }

    default public boolean isIndicator() {
        return this.getDistributionTypeEnum().compareTo(DistributionTypeEnum.INDICATOR) == 0;
    }
}

