/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.distribution;

import eu.amidst.core.distribution.BaseDistribution_MultinomialParents;
import eu.amidst.core.distribution.ConditionalDistribution;
import eu.amidst.core.distribution.Distribution;
import eu.amidst.core.distribution.Multinomial;
import eu.amidst.core.distribution.UnivariateDistribution;
import eu.amidst.core.exponentialfamily.EF_BaseDistribution_MultinomialParents;
import eu.amidst.core.exponentialfamily.EF_Multinomial;
import eu.amidst.core.utils.MultinomialIndex;
import eu.amidst.core.variables.Assignment;
import eu.amidst.core.variables.Variable;
import java.util.List;
import java.util.Random;

public class Multinomial_MultinomialParents
extends ConditionalDistribution {
    private BaseDistribution_MultinomialParents<Multinomial> base;

    public Multinomial_MultinomialParents(BaseDistribution_MultinomialParents<Multinomial> base_) {
        this.base = base_;
        this.var = this.base.getVariable();
        this.parents = this.base.getConditioningVariables();
    }

    public Multinomial_MultinomialParents(Variable var1, List<Variable> parents1) {
        this.base = new BaseDistribution_MultinomialParents(var1, parents1);
        this.var = var1;
        this.parents = parents1;
    }

    public List<Multinomial> getMultinomialDistributions() {
        return this.base.getBaseDistributions();
    }

    public Multinomial getMultinomial(int position) {
        return this.base.getBaseDistribution(position);
    }

    public Multinomial getMultinomial(Assignment parentAssignment) {
        return this.base.getBaseDistribution(parentAssignment);
    }

    public void setMultinomial(int position, Multinomial multinomialDistribution) {
        this.base.setBaseDistribution(position, multinomialDistribution);
    }

    public void setMultinomial(Assignment parentAssignment, Multinomial multinomialDistribution) {
        this.base.setBaseDistribution(parentAssignment, multinomialDistribution);
    }

    @Override
    public void setVar(Variable var) {
        this.var = var;
        this.base.setVar(var);
    }

    @Override
    public void setConditioningVariables(List<Variable> parents) {
        this.parents = parents;
        this.base.setConditioningVariables(parents);
    }

    @Override
    public double getLogConditionalProbability(Assignment parentAssignment) {
        double value = parentAssignment.getValue(this.var);
        return this.getMultinomial(parentAssignment).getLogProbability(value);
    }

    @Override
    public UnivariateDistribution getUnivariateDistribution(Assignment assignment) {
        return this.getMultinomial(assignment);
    }

    @Override
    public double[] getParameters() {
        return this.base.getParameters();
    }

    @Override
    public int getNumberOfParameters() {
        int n = 0;
        for (Multinomial dist : this.getMultinomialDistributions()) {
            n += dist.getNumberOfParameters();
        }
        return n;
    }

    @Override
    public String label() {
        if (this.getMultinomialDistributions().size() == 1) {
            return "Multinomial";
        }
        return "Multinomial|Multinomial";
    }

    @Override
    public void randomInitialization(Random random) {
        for (Multinomial multinomial : this.getMultinomialDistributions()) {
            multinomial.randomInitialization(random);
        }
    }

    public int getNumberOfParentAssignments() {
        return this.getMultinomialDistributions().size();
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("");
        for (int i = 0; i < this.getNumberOfParentAssignments(); ++i) {
            str.append(this.getMultinomial(i).toString());
            if (this.getNumberOfParentAssignments() <= 1) continue;
            Assignment parentAssignment = MultinomialIndex.getVariableAssignmentFromIndex(this.getConditioningVariables(), i);
            str.append(" | " + parentAssignment.outputString());
            if (i >= this.getNumberOfParentAssignments() - 1) continue;
            str.append("\n");
        }
        return str.toString();
    }

    @Override
    public boolean equalDist(Distribution dist, double threshold) {
        if (dist instanceof Multinomial_MultinomialParents) {
            return this.equalDist((Multinomial_MultinomialParents)dist, threshold);
        }
        return false;
    }

    public boolean equalDist(Multinomial_MultinomialParents dist, double threshold) {
        boolean equals = true;
        for (int i = 0; i < this.getNumberOfParentAssignments(); ++i) {
            equals = equals && this.getMultinomial(i).equalDist(dist.getMultinomial(i), threshold);
        }
        return equals;
    }

    public EF_BaseDistribution_MultinomialParents<EF_Multinomial> toEFConditionalDistribution() {
        return this.base.toEFConditionalDistribution();
    }
}

