/*
 * Decompiled with CFR 0.152.
 */
package eu.amidst.core.datastream;

import eu.amidst.core.datastream.Attributes;
import eu.amidst.core.datastream.BatchesSpliterator;
import eu.amidst.core.datastream.DataInstance;
import eu.amidst.core.datastream.DataOnMemory;
import eu.amidst.core.datastream.DataOnMemoryListContainer;
import eu.amidst.core.utils.FixedBatchParallelSpliteratorWrapper;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public interface DataStream<E extends DataInstance>
extends Iterable<E> {
    public Attributes getAttributes();

    public void close();

    public boolean isRestartable();

    public void restart();

    public Stream<E> stream();

    default public DataStream<E> filter(final Predicate<? super E> predicate) {
        return new DataStream<E>(){

            @Override
            public Attributes getAttributes() {
                return this.getAttributes();
            }

            @Override
            public void close() {
                this.close();
            }

            @Override
            public boolean isRestartable() {
                return this.isRestartable();
            }

            @Override
            public void restart() {
                this.restart();
            }

            @Override
            public Stream<E> stream() {
                return this.stream().filter(predicate);
            }
        };
    }

    default public <R extends DataInstance> DataStream<R> map(final Function<? super E, ? extends R> mapper) {
        return new DataStream<R>(){

            @Override
            public Attributes getAttributes() {
                return this.getAttributes();
            }

            @Override
            public void close() {
                this.close();
            }

            @Override
            public boolean isRestartable() {
                return this.isRestartable();
            }

            @Override
            public void restart() {
                this.restart();
            }

            @Override
            public Stream<R> stream() {
                return this.stream().map(mapper);
            }
        };
    }

    default public Stream<E> parallelStream(int batchSize) {
        return FixedBatchParallelSpliteratorWrapper.toFixedBatchStream(this.stream(), batchSize);
    }

    @Override
    default public Iterator<E> iterator() {
        return this.stream().iterator();
    }

    default public Iterable<DataOnMemory<E>> iterableOverBatches(int batchSize) {
        return BatchesSpliterator.toFixedBatchIterable(this, batchSize);
    }

    default public Stream<DataOnMemory<E>> streamOfBatches(int batchSize) {
        return (Stream)BatchesSpliterator.toFixedBatchStream(this, batchSize).sequential();
    }

    default public Stream<DataOnMemory<E>> parallelStreamOfBatches(int batchSize) {
        return FixedBatchParallelSpliteratorWrapper.toFixedBatchStream(this.streamOfBatches(batchSize), 1);
    }

    default public DataOnMemory<E> toDataOnMemory() {
        return new DataOnMemoryListContainer(this.getAttributes(), this.stream().collect(Collectors.toList()));
    }
}

