% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hier_clus.R
\name{plot.hier_clus}
\alias{plot.hier_clus}
\title{Plot method for the hier_clus function}
\usage{
\method{plot}{hier_clus}(x, plots = c("scree", "change"), cutoff = 0.05,
  shiny = FALSE, ...)
}
\arguments{
\item{x}{Return value from \code{\link{hier_clus}}}

\item{plots}{Plots to return. "change" shows the percentage change in within-cluster heterogeneity as respondents are grouped into different number of clusters, "dendro" shows the dendrogram, "scree" shows a scree plot of within-cluster heterogeneity}

\item{cutoff}{For large datasets plots can take time to render and become hard to interpret. By selection a cutoff point (e.g., 0.05 percent) the initial steps in hierachical cluster analysis are removed from the plot}

\item{shiny}{Did the function call originate inside a shiny app}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot method for the hier_clus function
}
\details{
See \url{https://radiant-rstats.github.io/docs/multivariate/hier_clus.html} for an example in Radiant
}
\examples{
result <- hier_clus("shopping", vars = c("v1:v6"))
plot(result, plots = c("change", "scree"), cutoff = .05)
plot(result, plots = "dendro", cutoff = 0)
shopping \%>\% hier_clus(vars = c("v1:v6")) \%>\% plot

}
\seealso{
\code{\link{hier_clus}} to generate results

\code{\link{summary.hier_clus}} to summarize results
}

