% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conjoint.R
\name{conjoint}
\alias{conjoint}
\title{Conjoint analysis}
\usage{
conjoint(dataset, rvar, evar, reverse = FALSE, data_filter = "")
}
\arguments{
\item{dataset}{Dataset name (string). This can be a dataframe in the global environment or an element in an r_data list from Radiant}

\item{rvar}{The response variable (e.g., profile ratings)}

\item{evar}{Explanatory variables in the regression}

\item{reverse}{Reverse the values of the response variable (`rvar`)}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}
}
\value{
A list with all variables defined in the function as an object of class conjoint
}
\description{
Conjoint analysis
}
\details{
See \url{https://radiant-rstats.github.io/docs/multivariate/conjoint.html} for an example in Radiant
}
\examples{
result <- conjoint("mp3", rvar = "Rating", evar = "Memory:Shape")
result <- mp3 \%>\% conjoint(rvar = "Rating", evar = "Memory:Shape")

}
\seealso{
\code{\link{summary.conjoint}} to summarize results

\code{\link{plot.conjoint}} to plot results
}

