% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logistic.R
\name{predict.logistic}
\alias{predict.logistic}
\title{Predict method for the logistic function}
\usage{
\method{predict}{logistic}(
  object,
  pred_data = NULL,
  pred_cmd = "",
  conf_lev = 0.95,
  se = TRUE,
  interval = "confidence",
  dec = 3,
  envir = parent.frame(),
  ...
)
}
\arguments{
\item{object}{Return value from \code{\link{logistic}}}

\item{pred_data}{Provide the dataframe to generate predictions (e.g., titanic). The dataset must contain all columns used in the estimation}

\item{pred_cmd}{Generate predictions using a command. For example, `pclass = levels(pclass)` would produce predictions for the different levels of factor `pclass`. To add another variable, create a vector of prediction strings, (e.g., c('pclass = levels(pclass)', 'age = seq(0,100,20)')}

\item{conf_lev}{Confidence level used to estimate confidence intervals (.95 is the default)}

\item{se}{Logical that indicates if prediction standard errors should be calculated (default = FALSE)}

\item{interval}{Type of interval calculation ("confidence" or "none"). Set to "none" if se is FALSE}

\item{dec}{Number of decimals to show}

\item{envir}{Environment to extract data from}

\item{...}{further arguments passed to or from other methods}
}
\description{
Predict method for the logistic function
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/logistic.html} for an example in Radiant
}
\examples{
result <- logistic(titanic, "survived", c("pclass", "sex"), lev = "Yes")
predict(result, pred_cmd = "pclass = levels(pclass)")
logistic(titanic, "survived", c("pclass", "sex"), lev = "Yes") \%>\%
  predict(pred_cmd = "sex = c('male','female')")
logistic(titanic, "survived", c("pclass", "sex"), lev = "Yes") \%>\%
  predict(pred_data = titanic)
}
\seealso{
\code{\link{logistic}} to generate the result

\code{\link{summary.logistic}} to summarize results

\code{\link{plot.logistic}} to plot results

\code{\link{plot.model.predict}} to plot prediction output
}
