% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gbt.R
\name{predict.gbt}
\alias{predict.gbt}
\title{Predict method for the gbt function}
\usage{
\method{predict}{gbt}(
  object,
  pred_data = NULL,
  pred_cmd = "",
  dec = 3,
  envir = parent.frame(),
  ...
)
}
\arguments{
\item{object}{Return value from \code{\link{gbt}}}

\item{pred_data}{Provide the dataframe to generate predictions (e.g., diamonds). The dataset must contain all columns used in the estimation}

\item{pred_cmd}{Generate predictions using a command. For example, `pclass = levels(pclass)` would produce predictions for the different levels of factor `pclass`. To add another variable, create a vector of prediction strings, (e.g., c('pclass = levels(pclass)', 'age = seq(0,100,20)')}

\item{dec}{Number of decimals to show}

\item{envir}{Environment to extract data from}

\item{...}{further arguments passed to or from other methods}
}
\description{
Predict method for the gbt function
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/gbt.html} for an example in Radiant
}
\examples{
result <- gbt(titanic, "survived", c("pclass", "sex"), early_stopping_rounds = 0)
predict(result, pred_cmd = "pclass = levels(pclass)")
result <- gbt(diamonds, "price", "carat:color", type = "regression")
predict(result, pred_cmd = "carat = 1:3")
predict(result, pred_data = diamonds) \%>\% head()
}
\seealso{
\code{\link{gbt}} to generate the result

\code{\link{summary.gbt}} to summarize results
}
