% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rforest.R
\name{plot.rforest}
\alias{plot.rforest}
\title{Plot method for the rforest function}
\usage{
\method{plot}{rforest}(
  x,
  plots = "",
  nrobs = Inf,
  qtiles = FALSE,
  shiny = FALSE,
  custom = FALSE,
  ...
)
}
\arguments{
\item{x}{Return value from \code{\link{rforest}}}

\item{plots}{Plots to produce for the specified Random Forest model. Use "" to avoid showing any plots (default). Options are ...}

\item{nrobs}{Number of data points to show in dashboard scatter plots (-1 for all)}

\item{qtiles}{Show 25th and 75th percentiles in partial-dependence plots}

\item{shiny}{Did the function call originate inside a shiny app}

\item{custom}{Logical (TRUE, FALSE) to indicate if ggplot object (or list of ggplot objects) should be returned.
This option can be used to customize plots (e.g., add a title, change x and y labels, etc.). See examples
and \url{https://ggplot2.tidyverse.org} for options.}

\item{...}{further arguments passed to or from other methods}
}
\description{
Plot method for the rforest function
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/rforest.html} for an example in Radiant
}
\examples{
result <- rforest(titanic, "survived", c("pclass", "sex"), lev = "Yes")

}
\seealso{
\code{\link{rforest}} to generate results

\code{\link{summary.rforest}} to summarize results

\code{\link{predict.rforest}} for prediction
}
