% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crtree.R
\name{crtree}
\alias{crtree}
\title{Classification and regression trees}
\usage{
crtree(dataset, rvar, evar, type = "", lev = "", wts = "None",
  cp = 0.001, nodes = NA, K = 10, seed = 1234, split = "gini",
  prior = NA, cost = NA, margin = NA, check = "", data_filter = "")
}
\arguments{
\item{dataset}{Dataset name (string). This can be a dataframe in the global environment or an element in an r_data list from Radiant}

\item{rvar}{The response variable in the model}

\item{evar}{Explanatory variables in the model}

\item{type}{Model type (i.e., "classification" or "regression")}

\item{lev}{The level in the response variable defined as _success_}

\item{wts}{Weights to use in estimation}

\item{cp}{Minimum proportion of root node deviance required for split (default = 0.00001)}

\item{nodes}{Maxiumum size of tree in number of nodes to return. If equal to NA no pruning is done}

\item{K}{Number of folds use in cross-validation}

\item{seed}{Random seed used for cross-validation}

\item{split}{Splitting criterium to use (i.e., "gini" or "information")}

\item{prior}{Adjust the initial probabily for the selected level (e.g., set to .5 in unbalanced samples)}

\item{cost}{Cost for each connection (e.g., email or mailing)}

\item{margin}{Margin on each customer purchase}

\item{check}{Optional estimation parameters ("standardize" is the default)}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}
}
\value{
A list with all variables defined in crtree as an object of class tree
}
\description{
Classification and regression trees
}
\details{
See \url{https://radiant-rstats.github.io/docs/model/crtree.html} for an example in Radiant
}
\examples{
result <- crtree("titanic", "survived", c("pclass","sex"), lev = "Yes")
result <- crtree("titanic", "survived", c("pclass","sex"))
result <- crtree("diamonds", "price", c("carat","clarity"), type = "regression")

}
\seealso{
\code{\link{summary.crtree}} to summarize results

\code{\link{plot.crtree}} to plot results

\code{\link{predict.crtree}} for prediction
}
