% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation.R
\name{correlation}
\alias{correlation}
\title{Calculate correlations for two or more variables}
\usage{
correlation(
  dataset,
  vars = "",
  method = "pearson",
  hcor = FALSE,
  hcor_se = FALSE,
  data_filter = "",
  envir = parent.frame()
)
}
\arguments{
\item{dataset}{Dataset}

\item{vars}{Variables to include in the analysis. Default is all but character and factor variables with more than two unique values are removed}

\item{method}{Type of correlations to calculate. Options are "pearson", "spearman", and "kendall". "pearson" is the default}

\item{hcor}{Use polycor::hetcor to calculate the correlation matrix}

\item{hcor_se}{Calculate standard errors when using polycor::hetcor}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}

\item{envir}{Environment to extract data from}
}
\value{
A list with all variables defined in the function as an object of class compare_means
}
\description{
Calculate correlations for two or more variables
}
\details{
See \url{https://radiant-rstats.github.io/docs/basics/correlation.html} for an example in Radiant
}
\examples{
correlation(diamonds, c("price", "carat")) \%>\% str()
correlation(diamonds, "x:z") \%>\% str()

}
\seealso{
\code{\link{summary.correlation}} to summarize results

\code{\link{plot.correlation}} to plot results
}
