% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/single_mean.R
\name{single_mean}
\alias{single_mean}
\title{Compare a sample mean to a population mean}
\usage{
single_mean(dataset, var, comp_value = 0, alternative = "two.sided",
  conf_lev = 0.95, data_filter = "")
}
\arguments{
\item{dataset}{Dataset name (string). This can be a dataframe in the global environment or an element in an r_data list from Radiant}

\item{var}{The variable selected for the mean comparison}

\item{comp_value}{Population value to compare to the sample mean}

\item{alternative}{The alternative hypothesis ("two.sided", "greater", or "less")}

\item{conf_lev}{Span for the confidence interval}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}
}
\value{
A list of variables defined in single_mean as an object of class single_mean
}
\description{
Compare a sample mean to a population mean
}
\details{
See \url{https://radiant-rstats.github.io/docs/basics/single_mean.html} for an example in Radiant
}
\examples{
single_mean("diamonds","price")

}
\seealso{
\code{\link{summary.single_mean}} to summarize results

\code{\link{plot.single_mean}} to plot results
}

