% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{deletionsByBinom}
\alias{deletionsByBinom}
\title{Double chromosome deletion by relative gene usage}
\usage{
deletionsByBinom(
  clip_db,
  chain = c("IGH", "IGK", "IGL"),
  nonReliable_Vgenes = c(),
  genes_order = NULL
)
}
\arguments{
\item{clip_db}{a \code{data.frame} in AIRR format. See details.}

\item{chain}{the IG/TR chain: IGH,IGK,IGL,TRB. Default is IGH.}

\item{nonReliable_Vgenes}{a list of known non reliable gene assignments. A \code{list} created by \code{nonReliableVGenes}.}

\item{genes_order}{A vector of the genes by the desired order. Default is by GENE.loc}
}
\value{
A \code{data.frame}, in which each row is the double chomosome deletion inference of a gene.

The output containes the following columns:
\itemize{
 \item \code{subject}:       the subject name.
 \item \code{gene}:          the gene call
 \item \code{frac}:          the relative gene usage of the gene
 \item \code{cutoff}:        the the cutoff of for the binomial test
 \item \code{pval}:          the p-value of the binomial test
 \item \code{deletion}:      if a double chromosome deletion event of a gene occured.
}
}
\description{
The \code{deletionsByBinom} function inferes double chromosome deletion events by relative gene usage.
}
\details{
The function accepts a \code{data.frame} in AIRR format (\url{https://changeo.readthedocs.io/en/stable/standard.html}) containing the following columns:
\itemize{
  \item \code{'subject'}: The subject name
  \item \code{'v_call'}: V allele call(s) (in an IMGT format)
  \item \code{'d_call'}: D allele call(s) (in an IMGT format, only for heavy chains)
  \item \code{'j_call'}: J allele call(s) (in an IMGT format)
}
}
\examples{
# Load example data and germlines
data(samples_db)

# Selecting a single individual
clip_db = samples_db[samples_db$subject=='I5', ]
# Infering haplotype
del_binom_df = deletionsByBinom(clip_db)
head(del_binom_df)

}
