/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import antlr.Token;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.analysis.DFA;
import org.antlr.analysis.DecisionProbe;
import org.antlr.codegen.CodeGenerator;
import org.antlr.misc.BitSet;
import org.antlr.test.BaseTest;
import org.antlr.test.ErrorQueue;
import org.antlr.tool.ErrorManager;
import org.antlr.tool.FASerializer;
import org.antlr.tool.Grammar;
import org.antlr.tool.GrammarInsufficientPredicatesMessage;
import org.antlr.tool.GrammarNonDeterminismMessage;
import org.antlr.tool.LeftRecursionCyclesMessage;
import org.antlr.tool.Message;

public class TestSemanticPredicates
extends BaseTest {
    public void testPredsButSyntaxResolves() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : {p1}? A | {p2}? B ;");
        String string = ".s0-A->:s1=>1\n.s0-B->:s2=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0, false);
    }

    public void testLL_1_Pred() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : {p1}? A | {p2}? A ;");
        String string = ".s0-A->.s1\n.s1-{p1}?->:s2=>1\n.s1-{p2}?->:s3=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0, false);
    }

    public void testLL_1_Pred_forced_k_1() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na options {k=1;} : {p1}? A | {p2}? A ;");
        String string = ".s0-A->.s1\n.s1-{p1}?->:s2=>1\n.s1-{p2}?->:s3=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0, false);
    }

    public void testLL_2_Pred() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : {p1}? A B | {p2}? A B ;");
        String string = ".s0-A->.s1\n.s1-B->.s2\n.s2-{p1}?->:s3=>1\n.s2-{p2}?->:s4=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0, false);
    }

    public void testPredicatedLoop() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : ( {p1}? A | {p2}? A )+;");
        String string = ".s0-A->.s2\n.s0-EOF->:s1=>3\n.s2-{p1}?->:s3=>1\n.s2-{p2}?->:s4=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0, false);
    }

    public void testPredicatedToStayInLoop() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : ( {p1}? A )+ (A)+;");
        String string = ".s0-A->.s1\n.s1-{!(p1)}?->:s2=>1\n.s1-{p1}?->:s3=>2\n";
    }

    public void testAndPredicates() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : {p1}? {p1a}? A | {p2}? A ;");
        String string = ".s0-A->.s1\n.s1-{(p1&&p1a)}?->:s2=>1\n.s1-{p2}?->:s3=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0, false);
    }

    public void testOrPredicates() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : b | {p2}? A ;\nb : {p1}? A | {p1a}? A ;");
        String string = ".s0-A->.s1\n.s1-{(p1||p1a)}?->:s2=>1\n.s1-{p2}?->:s3=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0, false);
    }

    public void testIgnoresHoistingDepthGreaterThanZero() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : A {p1}? | A {p2}?;");
        String string = ".s0-A->:s1=>1\n";
        this.checkDecision(grammar, 1, string, new int[]{2}, new int[]{1, 2}, "A", null, null, 2, false);
    }

    public void testIgnoresPredsHiddenByActions() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : {a1} {p1}? A | {a2} {p2}? A ;");
        String string = ".s0-A->:s1=>1\n";
        this.checkDecision(grammar, 1, string, new int[]{2}, new int[]{1, 2}, "A", null, null, 2, true);
    }

    public void testIgnoresPredsHiddenByActionsOneAlt() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : {p1}? A | {a2} {p2}? A ;");
        String string = ".s0-A->.s1\n.s1-{p1}?->:s2=>1\n.s1-{true}?->:s3=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0, true);
    }

    public void testHoist2() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : b | c ;\nb : {p1}? A ;\nc : {p2}? A ;\n");
        String string = ".s0-A->.s1\n.s1-{p1}?->:s2=>1\n.s1-{p2}?->:s3=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0, false);
    }

    public void testHoistCorrectContext() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : b | {p2}? ID ;\nb : {p1}? ID | INT ;\n");
        String string = ".s0-ID->.s1\n.s0-INT->:s2=>1\n.s1-{p1}?->:s2=>1\n.s1-{p2}?->:s3=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0, false);
    }

    public void testDefaultPredNakedAltIsLast() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : b | ID ;\nb : {p1}? ID | INT ;\n");
        String string = ".s0-ID->.s1\n.s0-INT->:s2=>1\n.s1-{p1}?->:s2=>1\n.s1-{true}?->:s3=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0, false);
    }

    public void testDefaultPredNakedAltNotLast() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : ID | b ;\nb : {p1}? ID | INT ;\n");
        String string = ".s0-ID->.s1\n.s0-INT->:s3=>2\n.s1-{!(p1)}?->:s2=>1\n.s1-{p1}?->:s3=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0, false);
    }

    public void testLeftRecursivePred() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\ns : a ;\na : {p1}? a | ID ;\n");
        String string = ".s0-ID->.s1\n.s1-{p1}?->:s2=>1\n.s1-{true}?->:s3=>2\n";
        DecisionProbe.verbose = true;
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        CodeGenerator codeGenerator = new CodeGenerator(this.newTool(), grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        if (grammar.getNumberOfDecisions() == 0) {
            grammar.buildNFA();
            grammar.createLookaheadDFAs(false);
        }
        DFA dFA = grammar.getLookaheadDFA(1);
        TestSemanticPredicates.assertEquals(null, (Object)dFA);
        TestSemanticPredicates.assertEquals((String)"unexpected number of expected problems", (int)1, (int)errorQueue.size());
        Message message = (Message)errorQueue.warnings.get(0);
        TestSemanticPredicates.assertTrue((String)"warning must be a left recursion msg", (boolean)(message instanceof LeftRecursionCyclesMessage));
    }

    public void testIgnorePredFromLL2AltLastAltIsDefaultTrue() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : {p1}? A B | A C | {p2}? A | {p3}? A | A ;\n");
        String string = ".s0-A->.s1\n.s1-B->:s2=>1\n.s1-C->:s3=>2\n.s1-{p2}?->:s4=>3\n.s1-{p3}?->:s5=>4\n.s1-{true}?->:s6=>5\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0, false);
    }

    public void testIgnorePredFromLL2AltPredUnionNeeded() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : {p1}? A B | A C | {p2}? A | A | {p3}? A ;\n");
        String string = ".s0-A->.s1\n.s1-B->:s2=>1\n.s1-C->:s3=>2\n.s1-{!((p3||p2))}?->:s5=>4\n.s1-{p2}?->:s4=>3\n.s1-{p3}?->:s6=>5\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0, false);
    }

    public void testPredGets2SymbolSyntacticContext() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : b | A B | C ;\nb : {p1}? A B ;\n");
        String string = ".s0-A->.s1\n.s0-C->:s5=>3\n.s1-B->.s2\n.s2-{p1}?->:s3=>1\n.s2-{true}?->:s4=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0, false);
    }

    public void testMatchesLongestThenTestPred() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\na : b | c ;\nb : {p}? A ;\nc : {q}? (A|B)+ ;");
        String string = ".s0-A->.s1\n.s0-B->:s3=>2\n.s1-{p}?->:s2=>1\n.s1-{q}?->:s3=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0, false);
    }

    public void testPredsUsedAfterRecursionOverflow() throws Exception {
        Grammar grammar = new Grammar("parser grammar P;\ns : {p1}? e '.' | {p2}? e ':' ;\ne : '(' e ')' | INT ;\n");
        String string = ".s0-'('->.s1\n.s0-INT->.s4\n.s1-{p1}?->:s2=>1\n.s1-{p2}?->:s3=>2\n.s4-{p1}?->:s2=>1\n.s4-{p2}?->:s3=>2\n";
        DecisionProbe.verbose = true;
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        CodeGenerator codeGenerator = new CodeGenerator(this.newTool(), grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        if (grammar.getNumberOfDecisions() == 0) {
            grammar.buildNFA();
            grammar.createLookaheadDFAs(false);
        }
        TestSemanticPredicates.assertEquals((String)"unexpected number of expected problems", (int)0, (int)errorQueue.size());
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0, false);
    }

    public void testPredsUsedAfterK2FailsNoRecursionOverflow() throws Exception {
        Grammar grammar = new Grammar("grammar P;\noptions {k=2;}\ns : {p1}? e '.' | {p2}? e ':' ;\ne : '(' e ')' | INT ;\n");
        String string = ".s0-'('->.s1\n.s0-INT->.s6\n.s1-'('->.s2\n.s1-INT->.s5\n.s2-{p1}?->:s3=>1\n.s2-{p2}?->:s4=>2\n.s5-{p1}?->:s3=>1\n.s5-{p2}?->:s4=>2\n.s6-'.'->:s3=>1\n.s6-':'->:s4=>2\n";
        DecisionProbe.verbose = true;
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        CodeGenerator codeGenerator = new CodeGenerator(this.newTool(), grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        if (grammar.getNumberOfDecisions() == 0) {
            grammar.buildNFA();
            grammar.createLookaheadDFAs(false);
        }
        TestSemanticPredicates.assertEquals((String)"unexpected number of expected problems", (int)0, (int)errorQueue.size());
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0, false);
    }

    public void testLexerMatchesLongestThenTestPred() throws Exception {
        Grammar grammar = new Grammar("lexer grammar P;\nB : {p}? 'a' ;\nC : {q}? ('a'|'b')+ ;");
        String string = ".s0-'a'->.s1\n.s0-'b'->:s4=>2\n.s1-'a'..'b'->:s4=>2\n.s1-<EOT>->.s2\n.s2-{p}?->:s3=>1\n.s2-{q}?->:s4=>2\n";
        this.checkDecision(grammar, 2, string, null, null, null, null, null, 0, false);
    }

    public void testLexerMatchesLongestMinusPred() throws Exception {
        Grammar grammar = new Grammar("lexer grammar P;\nB : 'a' ;\nC : ('a'|'b')+ ;");
        String string = ".s0-'a'->.s1\n.s0-'b'->:s3=>2\n.s1-'a'..'b'->:s3=>2\n.s1-<EOT>->:s2=>1\n";
        this.checkDecision(grammar, 2, string, null, null, null, null, null, 0, false);
    }

    public void testGatedPred() throws Exception {
        Grammar grammar = new Grammar("lexer grammar P;\nB : {p}? => 'a' ;\nC : {q}? => ('a'|'b')+ ;");
        String string = ".s0-'a'&&{(p||q)}?->.s1\n.s0-'b'&&{q}?->:s4=>2\n.s1-'a'..'b'&&{q}?->:s4=>2\n.s1-<EOT>&&{(p||q)}?->.s2\n.s2-{p}?->:s3=>1\n.s2-{q}?->:s4=>2\n";
        this.checkDecision(grammar, 2, string, null, null, null, null, null, 0, false);
    }

    public void testGatedPredHoistsAndCanBeInStopState() throws Exception {
        Grammar grammar = new Grammar("grammar u;\na : b+ ;\nb : 'x' | {p}?=> 'y' ;");
        String string = ".s0-'x'->:s2=>1\n.s0-'y'&&{p}?->:s3=>1\n.s0-EOF->:s1=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0, false);
    }

    public void testGatedPredInCyclicDFA() throws Exception {
        Grammar grammar = new Grammar("lexer grammar P;\nA : {p}?=> ('a')+ 'x' ;\nB : {q}?=> ('a'|'b')+ 'x' ;");
        String string = ".s0-'a'&&{(p||q)}?->.s1\n.s0-'b'&&{q}?->:s5=>2\n.s1-'a'&&{(p||q)}?->.s1\n.s1-'b'&&{q}?->:s5=>2\n.s1-'x'&&{(p||q)}?->.s2\n.s2-<EOT>&&{(p||q)}?->.s3\n.s3-{p}?->:s4=>1\n.s3-{q}?->:s5=>2\n";
        this.checkDecision(grammar, 3, string, null, null, null, null, null, 0, false);
    }

    public void testGatedPredNotActuallyUsedOnEdges() throws Exception {
        Grammar grammar = new Grammar("lexer grammar P;\nA : ('a' | {p}?=> 'a')\n  | 'a' 'b'\n  ;");
        String string = ".s0-'a'->.s1\n.s1-{!(p)}?->:s2=>1\n.s1-{p}?->:s3=>2\n";
        String string2 = ".s0-'a'->.s1\n.s1-'b'->:s2=>2\n.s1-<EOT>->:s3=>1\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0, false);
        this.checkDecision(grammar, 2, string2, null, null, null, null, null, 0, false);
    }

    public void testGatedPredDoesNotForceAllToBeGated() throws Exception {
        Grammar grammar = new Grammar("grammar w;\na : b | c ;\nb : {p}? B ;\nc : {q}?=> d ;\nd : {r}? C ;\n");
        String string = ".s0-B->:s1=>1\n.s0-C&&{q}?->:s2=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0, false);
    }

    public void testGatedPredDoesNotForceAllToBeGated2() throws Exception {
        Grammar grammar = new Grammar("grammar w;\na : b | c ;\nb : {p}? B ;\nc : {q}?=> d ;\nd : {r}?=> C\n  | B\n  ;\n");
        String string = ".s0-B->.s1\n.s0-C&&{(q&&r)}?->:s3=>2\n.s1-{p}?->:s2=>1\n.s1-{q}?->:s3=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0, false);
    }

    public void testORGatedPred() throws Exception {
        Grammar grammar = new Grammar("grammar w;\na : b | c ;\nb : {p}? B ;\nc : {q}?=> d ;\nd : {r}?=> C\n  | {s}?=> B\n  ;\n");
        String string = ".s0-B->.s1\n.s0-C&&{(q&&r)}?->:s3=>2\n.s1-{(q&&s)}?->:s3=>2\n.s1-{p}?->:s2=>1\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0, false);
    }

    public void testIncompleteSemanticHoistedContext() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na : b | B;\nb : {p1}? B | B ;");
        String string = ".s0-B->:s1=>1\n";
        this.checkDecision(grammar, 1, string, new int[]{2}, new int[]{1, 2}, "B", new int[]{1}, null, 3, false);
    }

    public void testIncompleteSemanticHoistedContextk2() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na : b | A B;\nb : {p1}? A B | A B ;");
        String string = ".s0-A->.s1\n.s1-B->:s2=>1\n";
        this.checkDecision(grammar, 1, string, new int[]{2}, new int[]{1, 2}, "A B", new int[]{1}, null, 3, false);
    }

    public void testIncompleteSemanticHoistedContextInFOLLOW() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\noptions {k=1;}\na : A? ;\nb : X a {p1}? A | Y a A ;");
        String string = ".s0-A->:s1=>1\n";
        this.checkDecision(grammar, 1, string, new int[]{2}, new int[]{1, 2}, "A", new int[]{2}, null, 3, false);
    }

    public void testIncompleteSemanticHoistedContextInFOLLOWk2() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na : (A B)? ;\nb : X a {p1}? A B | Y a A B | Z a ;");
        String string = ".s0-A->.s1\n.s0-EOF->:s3=>2\n.s1-B->:s2=>1\n";
        this.checkDecision(grammar, 1, string, null, new int[]{1, 2}, "A B", new int[]{2}, null, 2, false);
    }

    public void testIncompleteSemanticHoistedContextInFOLLOWDueToHiddenPred() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na : (A B)? ;\nb : X a {p1}? A B | Y a {a1} {p2}? A B | Z a ;");
        String string = ".s0-A->.s1\n.s0-EOF->:s3=>2\n.s1-B->:s2=>1\n";
        this.checkDecision(grammar, 1, string, null, new int[]{1, 2}, "A B", new int[]{2}, null, 2, true);
    }

    public void testIncompleteSemanticHoistedContext2() throws Exception {
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        Grammar grammar = new Grammar("parser grammar t;\na : b | B;\nb : {p1}? B | B D ;");
        String string = ".s0-B->:s1=>1\n";
        this.checkDecision(grammar, 1, string, new int[]{2}, new int[]{1, 2}, "B", new int[]{1}, null, 3, false);
    }

    public void testTooFewSemanticPredicates() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : {p1}? A | A | A ;");
        String string = ".s0-A->:s1=>1\n";
        this.checkDecision(grammar, 1, string, new int[]{2, 3}, new int[]{1, 2, 3}, "A", null, null, 2, false);
    }

    public void testPredWithK1() throws Exception {
        Grammar grammar = new Grammar("\tlexer grammar TLexer;\nA\noptions {\n  k=1;\n}\n  : {p1}? ('x')+ '.'\n  | {p2}? ('x')+ '.'\n  ;\n");
        String string = ".s0-'x'->.s1\n.s1-{p1}?->:s2=>1\n.s1-{p2}?->:s3=>2\n";
        int[] nArray = null;
        int[] nArray2 = null;
        String string2 = null;
        int[] nArray3 = null;
        int[] nArray4 = null;
        int n = 0;
        this.checkDecision(grammar, 3, string, nArray, nArray2, string2, nArray3, nArray4, n, false);
    }

    public void testPredWithArbitraryLookahead() throws Exception {
        Grammar grammar = new Grammar("\tlexer grammar TLexer;\nA : {p1}? ('x')+ '.'\n  | {p2}? ('x')+ '.'\n  ;\n");
        String string = ".s0-'x'->.s1\n.s1-'.'->.s2\n.s1-'x'->.s1\n.s2-{p1}?->:s3=>1\n.s2-{p2}?->:s4=>2\n";
        int[] nArray = null;
        int[] nArray2 = null;
        String string2 = null;
        int[] nArray3 = null;
        int[] nArray4 = null;
        int n = 0;
        this.checkDecision(grammar, 3, string, nArray, nArray2, string2, nArray3, nArray4, n, false);
    }

    public void testUniquePredicateOR() throws Exception {
        Grammar grammar = new Grammar("parser grammar v;\n\na : {a}? b\n  | {b}? b\n  ;\n\nb : {c}? (X)+ ;\n\nc : a\n  | b\n  ;\n");
        String string = ".s0-X->.s1\n.s1-{((b&&c)||(a&&c))}?->:s2=>1\n.s1-{c}?->:s3=>2\n";
        int[] nArray = null;
        int[] nArray2 = null;
        String string2 = null;
        int[] nArray3 = null;
        int[] nArray4 = null;
        int n = 0;
        this.checkDecision(grammar, 3, string, nArray, nArray2, string2, nArray3, nArray4, n, false);
    }

    public void testSemanticContextPreventsEarlyTerminationOfClosure() throws Exception {
        Grammar grammar = new Grammar("parser grammar T;\na : loop SEMI | ID SEMI\n  ;\nloop\n    : {while}? ID\n    | {do}? ID\n    | {for}? ID\n    ;");
        String string = ".s0-ID->.s1\n.s1-SEMI->.s2\n.s2-{(do||while||for)}?->:s3=>1\n.s2-{true}?->:s4=>2\n";
        this.checkDecision(grammar, 1, string, null, null, null, null, null, 0, false);
    }

    public void _template() throws Exception {
        Grammar grammar = new Grammar("parser grammar t;\na : A | B;");
        String string = "\n";
        int[] nArray = null;
        int[] nArray2 = new int[]{1, 2};
        String string2 = "L ID R";
        int[] nArray3 = new int[]{1};
        int[] nArray4 = null;
        int n = 1;
        this.checkDecision(grammar, 1, string, nArray, nArray2, string2, nArray3, nArray4, n, false);
    }

    protected void checkDecision(Grammar grammar, int n, String string, int[] nArray, int[] nArray2, String string2, int[] nArray3, int[] nArray4, int n2, boolean bl) throws Exception {
        Object object;
        Set<Integer> set;
        Map<Integer, Set<Token>> map;
        Object object2;
        DecisionProbe.verbose = true;
        ErrorQueue errorQueue = new ErrorQueue();
        ErrorManager.setErrorListener(errorQueue);
        CodeGenerator codeGenerator = new CodeGenerator(this.newTool(), grammar, "Java");
        grammar.setCodeGenerator(codeGenerator);
        if (grammar.getNumberOfDecisions() == 0) {
            grammar.buildNFA();
            grammar.createLookaheadDFAs(false);
        }
        if (errorQueue.size() != n2) {
            System.err.println("Warnings issued: " + errorQueue);
        }
        TestSemanticPredicates.assertEquals((String)"unexpected number of expected problems", (int)n2, (int)errorQueue.size());
        DFA dFA = grammar.getLookaheadDFA(n);
        FASerializer fASerializer = new FASerializer(grammar);
        String string3 = fASerializer.serialize(dFA.startState);
        List<Integer> list = dFA.getUnreachableAlts();
        if (nArray != null) {
            object2 = new BitSet();
            ((BitSet)object2).addAll(nArray);
            map = new BitSet();
            ((BitSet)((Object)map)).addAll(list);
            TestSemanticPredicates.assertEquals((String)"unreachable alts mismatch", (Object)object2, (Object)map);
        } else {
            TestSemanticPredicates.assertEquals((String)"unreachable alts mismatch", (int)0, (int)(list != null ? list.size() : 0));
        }
        if (string2 != null) {
            object2 = this.getNonDeterminismMessage(errorQueue.warnings);
            TestSemanticPredicates.assertNotNull((String)"no nondeterminism warning?", (Object)object2);
            TestSemanticPredicates.assertTrue((String)("expecting nondeterminism; found " + object2.getClass().getName()), (boolean)(object2 instanceof GrammarNonDeterminismMessage));
            map = this.getNonDeterminismMessage(errorQueue.warnings);
            set = ((GrammarNonDeterminismMessage)((Object)map)).probe.getSampleNonDeterministicInputSequence(((GrammarNonDeterminismMessage)((Object)map)).problemState);
            object = ((GrammarNonDeterminismMessage)((Object)map)).probe.getInputSequenceDisplay((List)((Object)set));
            TestSemanticPredicates.assertEquals((String)string2, (String)object);
        }
        if (nArray2 != null) {
            object2 = this.getNonDeterminismMessage(errorQueue.warnings);
            TestSemanticPredicates.assertNotNull((String)("found no nondet alts; expecting: " + this.str(nArray2)), (Object)object2);
            map = ((GrammarNonDeterminismMessage)object2).probe.getNonDeterministicAltsForState(((GrammarNonDeterminismMessage)object2).problemState);
            set = new BitSet();
            ((BitSet)((Object)set)).addAll(nArray2);
            object = new BitSet();
            ((BitSet)object).addAll((Iterable)((Object)map));
            TestSemanticPredicates.assertEquals((String)"nondet alts mismatch", set, (Object)object);
            TestSemanticPredicates.assertEquals((String)"mismatch between expected hasPredHiddenByAction", (boolean)bl, (boolean)((GrammarNonDeterminismMessage)object2).problemState.dfa.hasPredicateBlockedByAction);
        } else {
            object2 = this.getNonDeterminismMessage(errorQueue.warnings);
            TestSemanticPredicates.assertNull((String)"found nondet alts, but expecting none", (Object)object2);
        }
        if (nArray3 != null) {
            object2 = this.getGrammarInsufficientPredicatesMessage(errorQueue.warnings);
            TestSemanticPredicates.assertNotNull((String)("found no GrammarInsufficientPredicatesMessage alts; expecting: " + this.str(nArray2)), (Object)object2);
            map = ((GrammarInsufficientPredicatesMessage)object2).altToLocations;
            set = map.keySet();
            object = new BitSet();
            ((BitSet)object).addAll(nArray3);
            BitSet bitSet = new BitSet();
            bitSet.addAll(set);
            TestSemanticPredicates.assertEquals((String)"mismatch between insufficiently covered alts", (Object)object, (Object)bitSet);
            TestSemanticPredicates.assertEquals((String)"mismatch between expected hasPredHiddenByAction", (boolean)bl, (boolean)((GrammarInsufficientPredicatesMessage)object2).problemState.dfa.hasPredicateBlockedByAction);
        } else {
            object2 = this.getGrammarInsufficientPredicatesMessage(errorQueue.warnings);
            if (object2 != null) {
                System.out.println(errorQueue.warnings);
            }
            TestSemanticPredicates.assertNull((String)"found insufficiently covered alts, but expecting none", (Object)object2);
        }
        TestSemanticPredicates.assertEquals((String)string, (String)string3);
    }

    protected GrammarNonDeterminismMessage getNonDeterminismMessage(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Message message = (Message)list.get(i);
            if (!(message instanceof GrammarNonDeterminismMessage)) continue;
            return (GrammarNonDeterminismMessage)message;
        }
        return null;
    }

    protected GrammarInsufficientPredicatesMessage getGrammarInsufficientPredicatesMessage(List list) {
        for (int i = 0; i < list.size(); ++i) {
            Message message = (Message)list.get(i);
            if (!(message instanceof GrammarInsufficientPredicatesMessage)) continue;
            return (GrammarInsufficientPredicatesMessage)message;
        }
        return null;
    }

    protected String str(int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            int n = nArray[i];
            stringBuffer.append(n);
        }
        return stringBuffer.toString();
    }
}

