/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyTuple;
import org.python.core.PyType;
import org.python.core.PyUnicode$PyExposer;
import org.python.core.PyUnicodeDerived;
import org.python.core.StringFormatter;
import org.python.core.codecs;
import org.python.expose.ExposedNew;
import org.python.modules._codecs;
import org.python.util.Generic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyUnicode
extends PyString
implements Iterable {
    private volatile Plane plane = Plane.UNKNOWN;
    private volatile int codePointCount = -1;
    public static final PyType TYPE;

    public PyUnicode() {
        this(TYPE, "");
    }

    public PyUnicode(String string) {
        this(TYPE, string);
    }

    public PyUnicode(String string, boolean isBasic) {
        this(TYPE, string);
        this.plane = isBasic ? Plane.BASIC : Plane.UNKNOWN;
    }

    public PyUnicode(PyType subtype, String string) {
        super(subtype, string);
    }

    public PyUnicode(PyString pystring) {
        this(TYPE, pystring);
    }

    public PyUnicode(PyType subtype, PyString pystring) {
        this(subtype, pystring instanceof PyUnicode ? pystring.string : pystring.decode().toString());
    }

    public PyUnicode(char c) {
        this(TYPE, String.valueOf(c));
    }

    public PyUnicode(int codepoint) {
        this(TYPE, new String(new int[]{codepoint}, 0, 1));
    }

    public PyUnicode(int[] codepoints) {
        this(new String(codepoints, 0, codepoints.length));
    }

    PyUnicode(StringBuilder buffer) {
        this(TYPE, new String(buffer));
    }

    private static StringBuilder fromCodePoints(Iterator<Integer> iter) {
        StringBuilder buffer = new StringBuilder();
        while (iter.hasNext()) {
            buffer.appendCodePoint(iter.next());
        }
        return buffer;
    }

    PyUnicode(Iterator<Integer> iter) {
        this(PyUnicode.fromCodePoints(iter));
    }

    PyUnicode(Collection<Integer> ucs4) {
        this(ucs4.iterator());
    }

    @Override
    public int[] toCodePoints() {
        int n = this.getCodePointCount();
        int[] codePoints = new int[n];
        int i = 0;
        Iterator iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            codePoints[i] = (Integer)iter.next();
            ++i;
        }
        return codePoints;
    }

    @Override
    public String substring(int start, int end) {
        if (this.isBasicPlane()) {
            return super.substring(start, end);
        }
        return new PyUnicode((Iterator<Integer>)this.newSubsequenceIterator((int)start, (int)end, (int)1)).string;
    }

    public static PyUnicode fromInterned(String interned) {
        PyUnicode uni = new PyUnicode(TYPE, interned);
        uni.interned = true;
        return uni;
    }

    public boolean isBasicPlane() {
        if (this.plane == Plane.BASIC) {
            return true;
        }
        if (this.plane == Plane.UNKNOWN) {
            this.plane = this.string.length() == this.getCodePointCount() ? Plane.BASIC : Plane.ASTRAL;
        }
        return this.plane == Plane.BASIC;
    }

    public int getCodePointCount() {
        if (this.codePointCount >= 0) {
            return this.codePointCount;
        }
        this.codePointCount = this.string.codePointCount(0, this.string.length());
        return this.codePointCount;
    }

    @ExposedNew
    static final PyObject unicode_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("unicode", args, keywords, new String[]{"string", "encoding", "errors"}, 0);
        PyObject S = ap.getPyObject(0, null);
        String encoding = ap.getString(1, null);
        String errors = ap.getString(2, null);
        if (new_.for_type == subtype) {
            if (S == null) {
                return new PyUnicode("");
            }
            if (S instanceof PyUnicode) {
                return new PyUnicode(((PyUnicode)S).string);
            }
            if (S instanceof PyString) {
                if (S.getType() != PyString.TYPE && encoding == null && errors == null) {
                    return S.__unicode__();
                }
                PyObject decoded = codecs.decode((PyString)S, encoding, errors);
                if (decoded instanceof PyUnicode) {
                    return new PyUnicode((PyUnicode)decoded);
                }
                throw Py.TypeError("decoder did not return an unicode object (type=" + decoded.getType().fastGetName() + ")");
            }
            return S.__unicode__();
        }
        if (S == null) {
            return new PyUnicodeDerived(subtype, Py.EmptyString);
        }
        if (S instanceof PyUnicode) {
            return new PyUnicodeDerived(subtype, (PyUnicode)S);
        }
        return new PyUnicodeDerived(subtype, S.__str__());
    }

    @Override
    public PyString createInstance(String str) {
        return new PyUnicode(str);
    }

    @Override
    protected PyString createInstance(String str, boolean isBasic) {
        return new PyUnicode(str, isBasic);
    }

    @Override
    public PyObject __mod__(PyObject other) {
        return this.unicode___mod__(other);
    }

    final PyObject unicode___mod__(PyObject other) {
        StringFormatter fmt = new StringFormatter(this.string, true);
        return fmt.format(other);
    }

    final PyUnicode unicode___unicode__() {
        return this.str___unicode__();
    }

    @Override
    public PyString __str__() {
        return this.unicode___str__();
    }

    final PyString unicode___str__() {
        return new PyString(this.encode());
    }

    @Override
    public int __len__() {
        return this.unicode___len__();
    }

    final int unicode___len__() {
        return this.getCodePointCount();
    }

    @Override
    public PyString __repr__() {
        return this.unicode___repr__();
    }

    final PyString unicode___repr__() {
        return new PyString("u" + PyUnicode.encode_UnicodeEscape(this.string, true));
    }

    final PyObject unicode___getitem__(PyObject index) {
        return this.str___getitem__(index);
    }

    final PyObject unicode___getslice__(PyObject start, PyObject stop, PyObject step) {
        return this.seq___getslice__(start, stop, step);
    }

    @Override
    protected PyObject getslice(int start, int stop, int step) {
        if (this.isBasicPlane()) {
            return super.getslice(start, stop, step);
        }
        if (step > 0 && stop < start) {
            stop = start;
        }
        StringBuilder buffer = new StringBuilder(PyUnicode.sliceLength(start, stop, step));
        Iterator iter = this.newSubsequenceIterator(start, stop, step);
        while (iter.hasNext()) {
            buffer.appendCodePoint((Integer)iter.next());
        }
        return this.createInstance(new String(buffer));
    }

    final int unicode___cmp__(PyObject other) {
        return this.str___cmp__(other);
    }

    final PyObject unicode___eq__(PyObject other) {
        return this.str___eq__(other);
    }

    final PyObject unicode___ne__(PyObject other) {
        return this.str___ne__(other);
    }

    final int unicode___hash__() {
        return this.str___hash__();
    }

    @Override
    protected PyObject pyget(int i) {
        if (this.isBasicPlane()) {
            return Py.makeCharacter(this.string.charAt(i), true);
        }
        int k = 0;
        while (i > 0) {
            char W1 = this.string.charAt(k);
            k = W1 >= '\ud800' && W1 < '\udc00' ? (k += 2) : ++k;
            --i;
        }
        int codepoint = this.string.codePointAt(k);
        return Py.makeCharacter(codepoint, true);
    }

    public Iterator newSubsequenceIterator() {
        return new SubsequenceIteratorImpl();
    }

    public Iterator newSubsequenceIterator(int start, int stop, int step) {
        if (step < 0) {
            return new SteppedIterator(step * -1, new ReversedIterator(new SubsequenceIteratorImpl(stop + 1, start + 1, 1)));
        }
        return new SubsequenceIteratorImpl(start, stop, step);
    }

    private PyUnicode coerceToUnicode(PyObject o) {
        if (o == null) {
            return null;
        }
        if (o instanceof PyUnicode) {
            return (PyUnicode)o;
        }
        if (o instanceof PyString) {
            return new PyUnicode(o.toString());
        }
        if (o == Py.None) {
            return null;
        }
        throw Py.TypeError("coercing to Unicode: need string or buffer, " + o.getType().fastGetName() + "found");
    }

    final boolean unicode___contains__(PyObject o) {
        return this.str___contains__(o);
    }

    final PyObject unicode___mul__(PyObject o) {
        return this.str___mul__(o);
    }

    final PyObject unicode___rmul__(PyObject o) {
        return this.str___rmul__(o);
    }

    final PyObject unicode___add__(PyObject generic_other) {
        return this.str___add__(generic_other);
    }

    final PyObject unicode_lower() {
        return new PyUnicode(this.str_lower());
    }

    final PyObject unicode_upper() {
        return new PyUnicode(this.str_upper());
    }

    final PyObject unicode_title() {
        if (this.isBasicPlane()) {
            return new PyUnicode(this.str_title());
        }
        StringBuilder buffer = new StringBuilder(this.string.length());
        boolean previous_is_cased = false;
        Iterator iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = (Integer)iter.next();
            if (previous_is_cased) {
                buffer.appendCodePoint(Character.toLowerCase(codePoint));
            } else {
                buffer.appendCodePoint(Character.toTitleCase(codePoint));
            }
            if (Character.isLowerCase(codePoint) || Character.isUpperCase(codePoint) || Character.isTitleCase(codePoint)) {
                previous_is_cased = true;
                continue;
            }
            previous_is_cased = false;
        }
        return new PyUnicode(buffer);
    }

    final PyObject unicode_swapcase() {
        if (this.isBasicPlane()) {
            return new PyUnicode(this.str_swapcase());
        }
        StringBuilder buffer = new StringBuilder(this.string.length());
        Iterator iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = (Integer)iter.next();
            if (Character.isUpperCase(codePoint)) {
                buffer.appendCodePoint(Character.toLowerCase(codePoint));
                continue;
            }
            if (Character.isLowerCase(codePoint)) {
                buffer.appendCodePoint(Character.toUpperCase(codePoint));
                continue;
            }
            buffer.appendCodePoint(codePoint);
        }
        return new PyUnicode(buffer);
    }

    private PyUnicode coerceStripSepToUnicode(PyObject o) {
        if (o == null) {
            return null;
        }
        if (o instanceof PyUnicode) {
            return (PyUnicode)o;
        }
        if (o instanceof PyString) {
            return new PyUnicode(((PyString)o).decode().toString());
        }
        if (o == Py.None) {
            return null;
        }
        throw Py.TypeError("strip arg must be None, unicode or str");
    }

    final PyObject unicode_strip(PyObject sepObj) {
        PyUnicode sep = this.coerceStripSepToUnicode(sepObj);
        if (this.isBasicPlane() && (sep == null || sep.isBasicPlane())) {
            if (sep == null) {
                return new PyUnicode(this.str_strip(null));
            }
            return new PyUnicode(this.str_strip(sep.string));
        }
        return new PyUnicode(new ReversedIterator(new StripIterator(sep, new ReversedIterator(new StripIterator(sep, this.newSubsequenceIterator())))));
    }

    final PyObject unicode_lstrip(PyObject sepObj) {
        PyUnicode sep = this.coerceStripSepToUnicode(sepObj);
        if (this.isBasicPlane() && (sep == null || sep.isBasicPlane())) {
            if (sep == null) {
                return new PyUnicode(this.str_lstrip(null));
            }
            return new PyUnicode(this.str_lstrip(sep.string));
        }
        return new PyUnicode(new StripIterator(sep, this.newSubsequenceIterator()));
    }

    final PyObject unicode_rstrip(PyObject sepObj) {
        PyUnicode sep = this.coerceStripSepToUnicode(sepObj);
        if (this.isBasicPlane() && (sep == null || sep.isBasicPlane())) {
            if (sep == null) {
                return new PyUnicode(this.str_rstrip(null));
            }
            return new PyUnicode(this.str_rstrip(sep.string));
        }
        return new PyUnicode(new ReversedIterator(new StripIterator(sep, new ReversedIterator(this.newSubsequenceIterator()))));
    }

    final PyTuple unicode_partition(PyObject sep) {
        return this.unicodePartition(sep);
    }

    private SplitIterator newSplitIterator(PyUnicode sep, int maxsplit) {
        if (sep == null) {
            return new WhitespaceSplitIterator(maxsplit);
        }
        if (sep.getCodePointCount() == 0) {
            throw Py.ValueError("empty separator");
        }
        return new SepSplitIterator(sep, maxsplit);
    }

    final PyTuple unicode_rpartition(PyObject sep) {
        return this.unicodeRpartition(sep);
    }

    final PyList unicode_split(PyObject sepObj, int maxsplit) {
        PyUnicode sep = this.coerceToUnicode(sepObj);
        if (sep != null) {
            return this.str_split(sep.string, maxsplit);
        }
        return this.str_split(null, maxsplit);
    }

    final PyList unicode_rsplit(PyObject sepObj, int maxsplit) {
        PyUnicode sep = this.coerceToUnicode(sepObj);
        if (sep != null) {
            return this.str_rsplit(sep.string, maxsplit);
        }
        return this.str_rsplit(null, maxsplit);
    }

    final PyList unicode_splitlines(boolean keepends) {
        if (this.isBasicPlane()) {
            return this.str_splitlines(keepends);
        }
        return new PyList(new LineSplitIterator(keepends));
    }

    @Override
    protected PyString fromSubstring(int begin, int end) {
        assert (this.isBasicPlane());
        return new PyUnicode(this.string.substring(begin, end));
    }

    final int unicode_index(String sub, int start, PyObject end) {
        return this.str_index(sub, start, end);
    }

    final int unicode_rindex(String sub, int start, PyObject end) {
        return this.str_rindex(sub, start, end);
    }

    final int unicode_count(PyObject subObj, int start, PyObject end) {
        PyUnicode sub = this.coerceToUnicode(subObj);
        if (this.isBasicPlane()) {
            return this.str_count(sub.string, start, end);
        }
        int[] indices = this.translateIndices(start, end);
        int count = 0;
        Iterator mainIter = this.newSubsequenceIterator(indices[0], indices[1], 1);
        while (mainIter.hasNext()) {
            int matched = sub.getCodePointCount();
            Iterator subIter = sub.newSubsequenceIterator();
            while (mainIter.hasNext() && subIter.hasNext() && mainIter.next() == subIter.next()) {
                --matched;
            }
            if (matched != 0) continue;
            ++count;
        }
        return count;
    }

    final int unicode_find(String sub, int start, PyObject end) {
        return this.str_find(sub, start, end);
    }

    final int unicode_rfind(String sub, int start, PyObject end) {
        return this.str_rfind(sub, start, end);
    }

    private static String padding(int n, int pad) {
        StringBuilder buffer = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            buffer.appendCodePoint(pad);
        }
        return buffer.toString();
    }

    private static int parse_fillchar(String function, String fillchar) {
        if (fillchar == null) {
            return 32;
        }
        if (fillchar.codePointCount(0, fillchar.length()) != 1) {
            throw Py.TypeError(function + "() argument 2 must be char, not str");
        }
        return fillchar.codePointAt(0);
    }

    final PyObject unicode_ljust(int width, String padding) {
        int n = width - this.getCodePointCount();
        if (n <= 0) {
            return new PyUnicode(this.string);
        }
        return new PyUnicode(this.string + PyUnicode.padding(n, PyUnicode.parse_fillchar("ljust", padding)));
    }

    final PyObject unicode_rjust(int width, String padding) {
        int n = width - this.getCodePointCount();
        if (n <= 0) {
            return new PyUnicode(this.string);
        }
        return new PyUnicode(PyUnicode.padding(n, PyUnicode.parse_fillchar("ljust", padding)) + this.string);
    }

    final PyObject unicode_center(int width, String padding) {
        int n = width - this.getCodePointCount();
        if (n <= 0) {
            return new PyUnicode(this.string);
        }
        int half = n / 2;
        if (n % 2 > 0 && width % 2 > 0) {
            ++half;
        }
        int pad = PyUnicode.parse_fillchar("center", padding);
        return new PyUnicode(PyUnicode.padding(half, pad) + this.string + PyUnicode.padding(n - half, pad));
    }

    final PyObject unicode_zfill(int width) {
        int n = this.getCodePointCount();
        if (n >= width) {
            return new PyUnicode(this.string);
        }
        if (this.isBasicPlane()) {
            return new PyUnicode(this.str_zfill(width));
        }
        StringBuilder buffer = new StringBuilder(width);
        int nzeros = width - n;
        boolean first = true;
        boolean leadingSign = false;
        Iterator iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = (Integer)iter.next();
            if (first) {
                first = false;
                if (codePoint == 43 || codePoint == 45) {
                    buffer.appendCodePoint(codePoint);
                    leadingSign = true;
                }
                for (int i = 0; i < nzeros; ++i) {
                    buffer.appendCodePoint(48);
                }
                if (leadingSign) continue;
                buffer.appendCodePoint(codePoint);
                continue;
            }
            buffer.appendCodePoint(codePoint);
        }
        if (first) {
            for (int i = 0; i < nzeros; ++i) {
                buffer.appendCodePoint(48);
            }
        }
        return new PyUnicode(buffer);
    }

    final PyObject unicode_expandtabs(int tabsize) {
        return new PyUnicode(this.str_expandtabs(tabsize));
    }

    final PyObject unicode_capitalize() {
        if (this.string.length() == 0) {
            return this;
        }
        if (this.isBasicPlane()) {
            return new PyUnicode(this.str_capitalize());
        }
        StringBuilder buffer = new StringBuilder(this.string.length());
        boolean first = true;
        Iterator iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            if (first) {
                buffer.appendCodePoint(Character.toUpperCase((Integer)iter.next()));
                first = false;
                continue;
            }
            buffer.appendCodePoint(Character.toLowerCase((Integer)iter.next()));
        }
        return new PyUnicode(buffer);
    }

    final PyObject unicode_replace(PyObject oldPieceObj, PyObject newPieceObj, int maxsplit) {
        PyUnicode newPiece = this.coerceToUnicode(newPieceObj);
        PyUnicode oldPiece = this.coerceToUnicode(oldPieceObj);
        if (this.isBasicPlane() && newPiece.isBasicPlane() && oldPiece.isBasicPlane()) {
            return this.replace(oldPiece, newPiece, maxsplit);
        }
        StringBuilder buffer = new StringBuilder();
        if (oldPiece.getCodePointCount() == 0) {
            Iterator iter = this.newSubsequenceIterator();
            for (int i = 1; (maxsplit == -1 || i < maxsplit) && iter.hasNext(); ++i) {
                if (i == 1) {
                    buffer.append(newPiece.string);
                }
                buffer.appendCodePoint((Integer)iter.next());
                buffer.append(newPiece.string);
            }
            while (iter.hasNext()) {
                buffer.appendCodePoint((Integer)iter.next());
            }
            return new PyUnicode(buffer);
        }
        SplitIterator iter = this.newSplitIterator(oldPiece, maxsplit);
        int numSplits = 0;
        while (iter.hasNext()) {
            buffer.append(((PyUnicode)iter.next()).string);
            if (iter.hasNext()) {
                buffer.append(newPiece.string);
            }
            ++numSplits;
        }
        if (iter.getEndsWithSeparator() && (maxsplit == -1 || numSplits <= maxsplit)) {
            buffer.append(newPiece.string);
        }
        return new PyUnicode(buffer);
    }

    final PyString unicode_join(PyObject seq) {
        return this.str_join(seq);
    }

    final boolean unicode_startswith(PyObject prefix, int start, PyObject end) {
        return this.str_startswith(prefix, start, end);
    }

    final boolean unicode_endswith(PyObject suffix, int start, PyObject end) {
        return this.str_endswith(suffix, start, end);
    }

    final PyObject unicode_translate(PyObject table) {
        String trans = _codecs.translate_charmap(this.string, "ignore", table, true).__getitem__(0).toString();
        return new PyUnicode(trans);
    }

    final boolean unicode_islower() {
        if (this.isBasicPlane()) {
            return this.str_islower();
        }
        boolean cased = false;
        Iterator iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codepoint = (Integer)iter.next();
            if (Character.isUpperCase(codepoint) || Character.isTitleCase(codepoint)) {
                return false;
            }
            if (cased || !Character.isLowerCase(codepoint)) continue;
            cased = true;
        }
        return cased;
    }

    final boolean unicode_isupper() {
        if (this.isBasicPlane()) {
            return this.str_isupper();
        }
        boolean cased = false;
        Iterator iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codepoint = (Integer)iter.next();
            if (Character.isLowerCase(codepoint) || Character.isTitleCase(codepoint)) {
                return false;
            }
            if (cased || !Character.isUpperCase(codepoint)) continue;
            cased = true;
        }
        return cased;
    }

    final boolean unicode_isalpha() {
        if (this.isBasicPlane()) {
            return this.str_isalpha();
        }
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            if (Character.isLetter((Integer)iter.next())) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_isalnum() {
        if (this.isBasicPlane()) {
            return this.str_isalnum();
        }
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = (Integer)iter.next();
            if (Character.isLetterOrDigit(codePoint) || Character.getType(codePoint) == 10) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_isdecimal() {
        if (this.isBasicPlane()) {
            return this.str_isdecimal();
        }
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            if (Character.getType((Integer)iter.next()) == 9) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_isdigit() {
        if (this.isBasicPlane()) {
            return this.str_isdigit();
        }
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            if (Character.isDigit((Integer)iter.next())) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_isnumeric() {
        if (this.isBasicPlane()) {
            return this.str_isnumeric();
        }
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int type = Character.getType((Integer)iter.next());
            if (type == 9 || type == 10 || type == 11) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_istitle() {
        if (this.isBasicPlane()) {
            return this.str_istitle();
        }
        if (this.getCodePointCount() == 0) {
            return false;
        }
        boolean cased = false;
        boolean previous_is_cased = false;
        Iterator iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            int codePoint = (Integer)iter.next();
            if (Character.isUpperCase(codePoint) || Character.isTitleCase(codePoint)) {
                if (previous_is_cased) {
                    return false;
                }
                previous_is_cased = true;
                cased = true;
                continue;
            }
            if (Character.isLowerCase(codePoint)) {
                if (!previous_is_cased) {
                    return false;
                }
                previous_is_cased = true;
                cased = true;
                continue;
            }
            previous_is_cased = false;
        }
        return cased;
    }

    final boolean unicode_isspace() {
        if (this.isBasicPlane()) {
            return this.str_isspace();
        }
        if (this.getCodePointCount() == 0) {
            return false;
        }
        Iterator iter = this.newSubsequenceIterator();
        while (iter.hasNext()) {
            if (Character.isWhitespace((Integer)iter.next())) continue;
            return false;
        }
        return true;
    }

    final boolean unicode_isunicode() {
        return true;
    }

    final String unicode_encode(String encoding, String errors) {
        return this.str_encode(encoding, errors);
    }

    final PyObject unicode_decode(String encoding, String errors) {
        return this.str_decode(encoding, errors);
    }

    final PyTuple unicode___getnewargs__() {
        return new PyTuple(new PyUnicode(this.string));
    }

    public Iterator<Integer> iterator() {
        return this.newSubsequenceIterator();
    }

    final String unicode_toString() {
        return this.toString();
    }

    static {
        PyType.addBuilder(PyUnicode.class, new PyUnicode$PyExposer());
        TYPE = PyType.fromClass(PyUnicode.class);
    }

    private class SepSplitIterator
    extends SplitIterator {
        private final PyUnicode sep;

        SepSplitIterator(PyUnicode sep, int maxsplit) {
            super(maxsplit);
            this.sep = sep;
        }

        public PyUnicode next() {
            StringBuilder buffer = new StringBuilder();
            this.addLookahead(buffer);
            if (this.numSplits == this.maxsplit) {
                while (this.iter.hasNext()) {
                    buffer.appendCodePoint((Integer)this.iter.next());
                }
                return new PyUnicode(buffer);
            }
            boolean inSeparator = true;
            while (this.iter.hasNext()) {
                inSeparator = true;
                Iterator sepIter = this.sep.newSubsequenceIterator();
                while (sepIter.hasNext()) {
                    int codepoint = (Integer)this.iter.next();
                    if (codepoint != (Integer)sepIter.next()) {
                        this.addLookahead(buffer);
                        buffer.appendCodePoint(codepoint);
                        inSeparator = false;
                        break;
                    }
                    this.lookahead.add(codepoint);
                }
                if (!inSeparator) continue;
                this.lookahead.clear();
                break;
            }
            ++this.numSplits;
            this.completeSeparator = inSeparator;
            return new PyUnicode(buffer);
        }
    }

    private class LineSplitIterator
    implements Iterator {
        private final PeekIterator<Integer> iter;
        private final boolean keepends;

        LineSplitIterator(boolean keepends) {
            this.iter = new PeekIterator(PyUnicode.this.newSubsequenceIterator());
            this.keepends = keepends;
        }

        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public Object next() {
            StringBuilder buffer = new StringBuilder();
            while (this.iter.hasNext()) {
                int codepoint = this.iter.next();
                if (codepoint == 13 && this.iter.peek() != null && this.iter.peek() == 10) {
                    if (this.keepends) {
                        buffer.appendCodePoint(codepoint);
                        buffer.appendCodePoint(this.iter.next());
                        break;
                    }
                    this.iter.next();
                    break;
                }
                if (codepoint == 10 || codepoint == 13 || Character.getType(codepoint) == 13) {
                    if (!this.keepends) break;
                    buffer.appendCodePoint(codepoint);
                    break;
                }
                buffer.appendCodePoint(codepoint);
            }
            return new PyUnicode(buffer);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ReversedIterator<T>
    implements Iterator {
        private final List<T> reversed = Generic.list();
        private final Iterator<T> iter;

        ReversedIterator(Iterator<T> iter) {
            while (iter.hasNext()) {
                this.reversed.add(iter.next());
            }
            Collections.reverse(this.reversed);
            this.iter = this.reversed.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.iter.hasNext();
        }

        public T next() {
            return this.iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PeekIterator<T>
    implements Iterator {
        private T lookahead = null;
        private final Iterator<T> iter;

        public PeekIterator(Iterator<T> iter) {
            this.iter = iter;
            this.next();
        }

        public T peek() {
            return this.lookahead;
        }

        @Override
        public boolean hasNext() {
            return this.lookahead != null;
        }

        public T next() {
            T peeked = this.lookahead;
            this.lookahead = this.iter.hasNext() ? this.iter.next() : null;
            return peeked;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class WhitespaceSplitIterator
    extends SplitIterator {
        WhitespaceSplitIterator(int maxsplit) {
            super(maxsplit);
        }

        public PyUnicode next() {
            boolean atBeginning;
            StringBuilder buffer = new StringBuilder();
            this.addLookahead(buffer);
            if (this.numSplits == this.maxsplit) {
                while (this.iter.hasNext()) {
                    buffer.appendCodePoint((Integer)this.iter.next());
                }
                return new PyUnicode(buffer);
            }
            boolean inSeparator = false;
            boolean bl = atBeginning = this.numSplits == 0;
            while (this.iter.hasNext()) {
                int codepoint = (Integer)this.iter.next();
                if (Character.isWhitespace(codepoint)) {
                    this.completeSeparator = true;
                    if (!atBeginning) {
                        inSeparator = true;
                    }
                } else if (!inSeparator) {
                    this.completeSeparator = false;
                    buffer.appendCodePoint(codepoint);
                } else {
                    this.completeSeparator = false;
                    this.lookahead.add(codepoint);
                    break;
                }
                atBeginning = false;
            }
            ++this.numSplits;
            return new PyUnicode(buffer);
        }
    }

    private abstract class SplitIterator
    implements Iterator {
        protected final int maxsplit;
        protected final Iterator<Integer> iter;
        protected final LinkedList<Integer> lookahead;
        protected int numSplits;
        protected boolean completeSeparator;

        SplitIterator(int maxsplit) {
            this.iter = PyUnicode.this.newSubsequenceIterator();
            this.lookahead = new LinkedList();
            this.numSplits = 0;
            this.completeSeparator = false;
            this.maxsplit = maxsplit;
        }

        public boolean hasNext() {
            return this.lookahead.peek() != null || this.iter.hasNext() && (this.maxsplit == -1 || this.numSplits <= this.maxsplit);
        }

        protected void addLookahead(StringBuilder buffer) {
            Iterator i$ = this.lookahead.iterator();
            while (i$.hasNext()) {
                int codepoint = (Integer)i$.next();
                buffer.appendCodePoint(codepoint);
            }
            this.lookahead.clear();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }

        public boolean getEndsWithSeparator() {
            return this.completeSeparator && !this.hasNext();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class StripIterator
    implements Iterator {
        private final Iterator<Integer> iter;
        private int lookahead = -1;

        public StripIterator(PyUnicode sep, Iterator<Integer> iter) {
            this.iter = iter;
            if (sep != null) {
                Set sepSet = Generic.set();
                Iterator sepIter = sep.newSubsequenceIterator();
                while (sepIter.hasNext()) {
                    sepSet.add(sepIter.next());
                }
                while (iter.hasNext()) {
                    int codePoint = iter.next();
                    if (sepSet.contains(codePoint)) continue;
                    this.lookahead = codePoint;
                    return;
                }
            } else {
                while (iter.hasNext()) {
                    int codePoint = iter.next();
                    if (Character.isWhitespace(codePoint)) continue;
                    this.lookahead = codePoint;
                    return;
                }
            }
        }

        @Override
        public boolean hasNext() {
            return this.lookahead != -1;
        }

        public Object next() {
            int old = this.lookahead;
            this.lookahead = this.iter.hasNext() ? this.iter.next() : -1;
            return old;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SteppedIterator<T>
    implements Iterator {
        private final Iterator<T> iter;
        private final int step;
        private T lookahead = null;

        public SteppedIterator(int step, Iterator<T> iter) {
            this.iter = iter;
            this.step = step;
            this.lookahead = this.advance();
        }

        private T advance() {
            if (this.iter.hasNext()) {
                T elem = this.iter.next();
                for (int i = 1; i < this.step && this.iter.hasNext(); ++i) {
                    this.iter.next();
                }
                return elem;
            }
            return null;
        }

        @Override
        public boolean hasNext() {
            return this.lookahead != null;
        }

        public T next() {
            T old = this.lookahead;
            if (this.iter.hasNext()) {
                this.lookahead = this.iter.next();
                for (int i = 1; i < this.step && this.iter.hasNext(); ++i) {
                    this.iter.next();
                }
            } else {
                this.lookahead = null;
            }
            return old;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class SubsequenceIteratorImpl
    implements Iterator {
        private int current;
        private int k = 0;
        private int start;
        private int stop;
        private int step;

        SubsequenceIteratorImpl(int start, int stop, int step) {
            this.current = start;
            this.start = start;
            this.stop = stop;
            this.step = step;
            for (int i = 0; i < start; ++i) {
                this.nextCodePoint();
            }
        }

        SubsequenceIteratorImpl() {
            this(0, pyUnicode.getCodePointCount(), 1);
        }

        public boolean hasNext() {
            return this.current < this.stop;
        }

        public Object next() {
            int codePoint = this.nextCodePoint();
            ++this.current;
            for (int j = 1; j < this.step && this.hasNext(); ++j) {
                this.nextCodePoint();
                ++this.current;
            }
            return codePoint;
        }

        private int nextCodePoint() {
            int U;
            int W1 = PyUnicode.this.string.charAt(this.k);
            if (W1 >= 55296 && W1 < 56320) {
                char W2 = PyUnicode.this.string.charAt(this.k + 1);
                U = ((W1 & 0x3FF) << 10 | W2 & 0x3FF) + 65536;
                this.k += 2;
            } else {
                U = W1;
                ++this.k;
            }
            return U;
        }

        public void remove() {
            throw new UnsupportedOperationException("Not supported on PyUnicode objects (immutable)");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Plane {
        UNKNOWN,
        BASIC,
        ASTRAL;

    }
}

